/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.gedcomvalidate;

import ancestris.modules.gedcom.gedcomvalidate.Bundle;
import ancestris.modules.gedcom.gedcomvalidate.Test;
import ancestris.modules.gedcom.gedcomvalidate.TestAge;
import ancestris.modules.gedcom.gedcomvalidate.TestBiologicalChild;
import ancestris.modules.gedcom.gedcomvalidate.TestCardinality;
import ancestris.modules.gedcom.gedcomvalidate.TestDate;
import ancestris.modules.gedcom.gedcomvalidate.TestDateRangeValid;
import ancestris.modules.gedcom.gedcomvalidate.TestExists;
import ancestris.modules.gedcom.gedcomvalidate.TestFamilyClone;
import ancestris.modules.gedcom.gedcomvalidate.TestFile;
import ancestris.modules.gedcom.gedcomvalidate.TestOrder;
import ancestris.modules.gedcom.gedcomvalidate.TestPlace;
import ancestris.modules.gedcom.gedcomvalidate.TestSpouseGender;
import ancestris.modules.gedcom.gedcomvalidate.TestUniqueIDs;
import ancestris.modules.gedcom.gedcomvalidate.TestValid;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.util.Validator;
import genj.view.ViewContext;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class GedcomValidate
implements Validator {
    Preferences modulePreferences = NbPreferences.forModule(Gedcom.class);
    public boolean isOrderDiscretionary = this.modulePreferences.getBoolean("isOrderDiscretionary", true);
    public boolean isEmptyValueValid = this.modulePreferences.getBoolean("isEmptyValueValid", true);
    public boolean isPrivateValueValid = this.modulePreferences.getBoolean("isPrivateValueValid", true);
    public boolean isFileNotFoundValid = this.modulePreferences.getBoolean("isFileNotFoundValid", true);
    public boolean isUnderscoreValid = this.modulePreferences.getBoolean("isUnderscoreValid", true);
    public boolean isExtramaritalValid = this.modulePreferences.getBoolean("isExtramaritalValid", true);
    public boolean isRelaxedPlaceFormat = this.modulePreferences.getBoolean("isRelaxedPlaceFormat", false);
    public boolean isSameSexFamValid = this.modulePreferences.getBoolean("isSameSexFamValid", false);
    public int maxLife = this.modulePreferences.getInt("maxLife", 120);
    public int minAgeMARR = this.modulePreferences.getInt("minAgeMARR", 12);
    public int maxAgeBAPM = this.modulePreferences.getInt("maxAgeBAPM", 120);
    public int minAgeRETI = this.modulePreferences.getInt("minAgeRETI", 30);
    public int minAgeFather = this.modulePreferences.getInt("minAgeFather", 14);
    public int minAgeMother = this.modulePreferences.getInt("minAgeMother", 10);
    public int maxAgeMother = this.modulePreferences.getInt("maxAgeMother", 48);
    public int maxDiffAgeSibling = this.modulePreferences.getInt("maxDiffAgeSibling", 21);
    public int minDiffAgeSibling = this.modulePreferences.getInt("minDiffAgeSibling", 10);
    public int maxDiffAgeSpouses = this.modulePreferences.getInt("maxDiffAgeSpouses", 20);
    public PointInTime minYear = new PointInTime(0, 0, this.modulePreferences.getInt("minYear", 1));
    public PointInTime maxYear = new PointInTime(0, 0, this.modulePreferences.getInt("maxYear", 3000));
    public boolean showTwins = this.modulePreferences.getBoolean("showTwins", false);
    public static String[] ALL_EVENTS = new String[]{"INDI:BIRT", "INDI:CHR", "FAM:MARR", "INDI:OCCU", "INDI:RESI", "FAM:RESI", "INDI:RETI", "INDI:DEAT", "INDI:BURI", "INDI:BAPM", "INDI:BLES", "INDI:ADOP", "INDI:FCOM", "INDI:BARM", "INDI:BASM", "INDI:CONF", "INDI:NATI", "INDI:RELI", "INDI:CAST", "INDI:CHRA", "INDI:GRAD", "INDI:ORDN", "FAM:ENGA", "FAM:MARB", "FAM:MARL", "FAM:MARS", "FAM:MARC", "FAM:DIVF", "FAM:DIV", "FAM:ANUL", "INDI:EMIG", "INDI:IMMI", "INDI:NATU", "INDI:TITL", "INDI:SSN", "INDI:IDNO", "INDI:DSCR", "INDI:EDUC", "INDI:CENS", "FAM:CENS", "INDI:PROP", "FAM:EVEN", "INDI:EVEN", "INDI:FACT", "INDI:PROB", "INDI:WILL", "INDI:CREM"};
    private static String[] AFTER_BIRTH_EVENTS = null;
    private static String[] BEFORE_DEATH_EVENTS = null;
    private boolean cancel;
    private int entitiesNumber;
    private int entitiesCounter;
    private String entityType;
    private Gedcom gedcom;

    public GedcomValidate() {
        ArrayList<String> list1 = new ArrayList<String>();
        ArrayList<String> list2 = new ArrayList<String>();
        for (int i = 0; i < ALL_EVENTS.length; ++i) {
            list1.add(ALL_EVENTS[i] + ":DATE");
            if (ALL_EVENTS[i].contains("BURI") || ALL_EVENTS[i].contains("CREM") || ALL_EVENTS[i].contains("PROP") || ALL_EVENTS[i].contains("PROB")) continue;
            list2.add(ALL_EVENTS[i] + ":DATE");
        }
        AFTER_BIRTH_EVENTS = list1.toArray(new String[list1.size()]);
        BEFORE_DEATH_EVENTS = list2.toArray(new String[list2.size()]);
    }

    public List<ViewContext> start(Gedcom gedcom) {
        this.gedcom = gedcom;
        List<Test> tests = this.createTests(gedcom);
        ArrayList<ViewContext> issues = new ArrayList<ViewContext>();
        this.entitiesNumber = gedcom.getEntities().size();
        this.entitiesCounter = 0;
        this.entityType = "";
        String[] stringArray = Gedcom.ENTITIES;
        int n = stringArray.length;
        block0: for (int i = 0; i < n; ++i) {
            String ENTITIES;
            this.entityType = ENTITIES = stringArray[i];
            for (Entity e : gedcom.getEntities(ENTITIES)) {
                ++this.entitiesCounter;
                if (this.cancel) break block0;
                TagPath path = new TagPath(e.getTag());
                this.test((Property)e, path, gedcom.getGrammar().getMeta(path), tests, issues);
            }
        }
        return issues.isEmpty() ? null : issues;
    }

    public List<ViewContext> start(Entity e) {
        if (e == null) {
            return null;
        }
        List<Test> tests = this.createTests(e.getGedcom());
        ArrayList<ViewContext> issues = new ArrayList<ViewContext>();
        TagPath path = new TagPath(e.getTag());
        this.test((Property)e, path, e.getGedcom().getGrammar().getMeta(path), tests, issues);
        return issues.isEmpty() ? null : issues;
    }

    private void test(Property prop, TagPath path, MetaProperty meta, List<Test> tests, List<ViewContext> issues) {
        int i;
        int j = tests.size();
        for (i = 0; i < j; ++i) {
            Test tst = tests.get(i);
            if (!tst.applies(prop, path)) continue;
            tst.test(prop, path, issues, this);
        }
        if (this.isUnderscoreValid && prop.getTag().startsWith("_")) {
            return;
        }
        j = prop.getNoOfProperties();
        for (i = 0; i < j; ++i) {
            Property child = prop.getProperty(i);
            if (child.isTransient()) continue;
            String ctag = child.getTag();
            if (this.isUnderscoreValid && ctag.startsWith("_")) continue;
            if (!meta.allows(ctag)) {
                String msg = NbBundle.getMessage(this.getClass(), (String)"err.notgedcom", (Object)ctag, (Object)prop.getGedcom().getGrammar().getVersion(), (Object)path.toString());
                issues.add(new ViewContext(child).setCode("00-1").setText(msg).setImage(MetaProperty.IMG_ERROR));
                continue;
            }
            this.test(child, new TagPath(path, ctag), meta.getNested(child.getTag(), false), tests, issues);
        }
    }

    private List<Test> createTests(Gedcom gedcom) {
        ArrayList<Test> result = new ArrayList<Test>();
        result.add(new TestCardinality());
        result.add(new TestUniqueIDs());
        result.add(new TestValid(this));
        result.add(new TestDateRangeValid(this));
        if (!this.isSameSexFamValid) {
            result.add(new TestSpouseGender());
        }
        if (!this.isFileNotFoundValid) {
            result.add(new TestFile());
        }
        result.add(new TestFamilyClone());
        result.add(new TestBiologicalChild());
        if (!this.isOrderDiscretionary) {
            result.add(new TestOrder("INDI", "FAMS", "FAMS:*:..:MARR:DATE"));
        }
        if (!this.isOrderDiscretionary) {
            result.add(new TestOrder("FAM", "CHIL", "CHIL:*:..:BIRT:DATE"));
        }
        if (!this.isRelaxedPlaceFormat) {
            result.add(new TestPlace(gedcom));
        }
        result.add(new TestDate("INDI:BIRT:DATE", 0, "INDI:DEAT:DATE"));
        result.add(new TestDate("INDI:BURI:DATE", 1, "INDI:DEAT:DATE"));
        result.add(new TestDate(AFTER_BIRTH_EVENTS, 1, "INDI:BIRT:DATE"));
        result.add(new TestDate(BEFORE_DEATH_EVENTS, 0, "INDI:DEAT:DATE"));
        result.add(new TestDate("FAM:DIV:DATE", 1, "FAM:MARR:DATE"));
        result.add(new TestDate("FAM:MARR:DATE", 0, "FAM:HUSB:*:..:DEAT:DATE"));
        result.add(new TestDate("FAM:MARR:DATE", 0, "FAM:WIFE:*:..:DEAT:DATE"));
        result.add(new TestDate("FAM:MARR:DATE", 1, "FAM:HUSB:*:..:BIRT:DATE"));
        result.add(new TestDate("FAM:MARR:DATE", 1, "FAM:WIFE:*:..:BIRT:DATE"));
        result.add(new TestDate("FAM:CHIL", "*:..:BIRT:DATE", 0, "FAM:WIFE:*:..:DEAT:DATE"));
        if (!this.isExtramaritalValid) {
            result.add(new TestDate("FAM:CHIL", "*:..:BIRT:DATE", 1, "FAM:MARR:DATE"));
            result.add(new TestDate("FAM:CHIL", "*:..:BIRT:DATE", 0, "FAM:DIV:DATE"));
            result.add(new TestExists("FAM:CHIL", ".", "..:MARR"));
        }
        if (this.maxLife > 0) {
            result.add(new TestAge("INDI:DEAT:DATE", "..:..", 0, this.maxLife, "maxLife"));
        }
        if (this.maxAgeBAPM > 0) {
            result.add(new TestAge("INDI:BAPM:DATE", "..:..", 0, this.maxAgeBAPM, "maxAgeBAPM"));
        }
        if (this.maxAgeBAPM > 0) {
            result.add(new TestAge("INDI:CHR:DATE", "..:..", 0, this.maxAgeBAPM, "maxAgeBAPM"));
        }
        if (this.minAgeRETI > 0) {
            result.add(new TestAge("INDI:RETI:DATE", "..:..", 1, this.minAgeRETI, "minAgeRETI"));
        }
        if (this.minAgeMARR > 0) {
            result.add(new TestAge("FAM:MARR:DATE", "..:..:HUSB:*:..", 1, this.minAgeMARR, "minAgeMARR"));
        }
        if (this.minAgeMARR > 0) {
            result.add(new TestAge("FAM:MARR:DATE", "..:..:WIFE:*:..", 1, this.minAgeMARR, "minAgeMARR"));
        }
        if (this.minAgeMother > 0) {
            result.add(new TestAge("FAM:CHIL", "*:..:BIRT:DATE", "..:WIFE:*:..", 1, this.minAgeMother, "minAgeMother"));
        }
        if (this.maxAgeMother > 0) {
            result.add(new TestAge("FAM:CHIL", "*:..:BIRT:DATE", "..:WIFE:*:..", 0, this.maxAgeMother, "maxAgeMother"));
        }
        if (this.minAgeFather > 0) {
            result.add(new TestAge("FAM:CHIL", "*:..:BIRT:DATE", "..:HUSB:*:..", 1, this.minAgeFather, "minAgeFather"));
        }
        if (this.minAgeMother > 0) {
            result.add(new TestAge("FAM:WIFE", "*:..:BIRT:DATE", "..:CHIL:*:..", 1, this.minAgeMother, "minAgeMother"));
        }
        if (this.maxAgeMother > 0) {
            result.add(new TestAge("FAM:WIFE", "*:..:BIRT:DATE", "..:CHIL:*:..", 0, this.maxAgeMother, "maxAgeMother"));
        }
        if (this.minAgeFather > 0) {
            result.add(new TestAge("FAM:HUSB", "*:..:BIRT:DATE", "..:CHIL:*:..", 1, this.minAgeFather, "minAgeFather"));
        }
        if (this.maxDiffAgeSibling > 0) {
            result.add(new TestAge("FAM:CHIL", "*:..:BIRT:DATE", "..:CHIL:*:..", 0, this.maxDiffAgeSibling, "maxDiffAgeSibling"));
        }
        if (this.minDiffAgeSibling > 0) {
            result.add(new TestAge("FAM:CHIL", "*:..:BIRT:DATE", "..:CHIL:*:..", 1, this.minDiffAgeSibling, "minDiffAgeSibling"));
        }
        if (this.maxDiffAgeSpouses > 0) {
            result.add(new TestAge("FAM:HUSB", "*:..:BIRT:DATE", "..:WIFE:*:..", 0, this.maxDiffAgeSpouses, "maxDiffAgeSpouses"));
        }
        if (this.maxDiffAgeSpouses > 0) {
            result.add(new TestAge("FAM:WIFE", "*:..:BIRT:DATE", "..:HUSB:*:..", 0, this.maxDiffAgeSpouses, "maxDiffAgeSpouses"));
        }
        return result;
    }

    public void cancelTrackable() {
        this.cancel = true;
    }

    public int getProgress() {
        return 100 * this.entitiesCounter / this.entitiesNumber;
    }

    public String getState() {
        return Bundle.validate_progress(this.entityType, this.entitiesNumber);
    }

    public String getTaskName() {
        String name = this.gedcom == null ? "" : this.gedcom.getName();
        return Bundle.validate_title(name);
    }
}

