/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.gedcomvalidate;

import ancestris.modules.gedcom.gedcomvalidate.GedcomValidate;
import ancestris.modules.gedcom.gedcomvalidate.Test;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.view.ViewContext;
import java.util.HashMap;
import java.util.List;
import org.openide.util.NbBundle;

public class TestCardinality
extends Test {
    public TestCardinality() {
        super((String[])null, Property.class);
    }

    @Override
    void test(Property prop, TagPath path, List<ViewContext> issues, GedcomValidate report) {
        MetaProperty itsmeta = prop.getMetaProperty();
        HashMap<String, Property> seen = new HashMap<String, Property>();
        int j = prop.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property child = prop.getProperty(i);
            String tag = child.getTag();
            MetaProperty meta = itsmeta.getNested(tag, false);
            if (meta.isSingleton()) {
                if (!seen.containsKey(tag)) {
                    seen.put(tag, child);
                    continue;
                }
                Property first = (Property)seen.get(tag);
                if (first == null) continue;
                seen.put(tag, null);
                issues.add(new ViewContext(first).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)"err.cardinality.max", (Object)prop.getTag(), (Object)first.getTag(), (Object)prop.getGedcom().getGrammar().getVersion(), (Object)meta.getCardinality(), (Object[])new Object[0])));
                continue;
            }
            if (seen.containsKey(tag)) continue;
            seen.put(tag, child);
        }
        MetaProperty[] metas = prop.getNestedMetaProperties(0);
        for (int i = 0; i < metas.length; ++i) {
            if (!metas[i].isRequired() || seen.get(metas[i].getTag()) != null) continue;
            String txt = NbBundle.getMessage(this.getClass(), (String)"err.cardinality.min", (Object)prop.getTag(), (Object)metas[i].getTag(), (Object)prop.getGedcom().getGrammar().getVersion(), (Object)metas[i].getCardinality(), (Object[])new Object[0]);
            issues.add(new ViewContext(prop).setImage(metas[i].getImage()).setCode(this.getCode()).setText(txt));
        }
    }

    @Override
    String getCode() {
        return "00-2";
    }
}

