/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.api.lnf.LookAndFeelProvider;
import ancestris.app.App;
import ancestris.app.AppOptions;
import ancestris.app.OptionDisplayOptionsPanelController;
import ancestris.core.TextOptions;
import ancestris.startup.settings.StartupOptions;
import ancestris.util.Lifecycle;
import genj.gedcom.GedcomOptions;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

final class OptionDisplayPanel
extends JPanel {
    private final OptionDisplayOptionsPanelController controller;
    Locale[] locales = new Locale[]{new Locale("br"), new Locale("es"), new Locale("ca"), new Locale("cs"), new Locale("da"), Locale.GERMAN, Locale.ENGLISH, new Locale("el"), new Locale("eo"), new Locale("fi"), Locale.FRENCH, new Locale("hu"), Locale.ITALIAN, new Locale("lv"), new Locale("nl"), new Locale("no"), new Locale("pl"), new Locale("pt"), new Locale("ru"), new Locale("sv")};
    private static LookAndFeelProvider[] skins = LookAndFeelProvider.getProviders();
    private JCheckBox jCheckBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JComboBox jcbLanguage;
    private JComboBox jcbOutputLanguage;

    OptionDisplayPanel(OptionDisplayOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.jComboBox2ActionPerformed(null);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jComboBox2 = new JComboBox<LookAndFeelProvider>(skins);
        this.jcbLanguage = new JComboBox<String>(this.initLanguages(NbBundle.getMessage(App.class, (String)"options.lang.system")));
        this.jLabel3 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.jcbOutputLanguage = new JComboBox<String>(this.initLanguages(NbBundle.getMessage(App.class, (String)"options.lang.gui")));
        this.setPreferredSize(new Dimension(582, 384));
        this.jLabel2.setFont(new Font("DejaVu Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabel2.text"));
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabel1.text"));
        this.jComboBox2.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jComboBox2.toolTipText"));
        this.jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDisplayPanel.this.jComboBox2ActionPerformed(evt);
            }
        });
        this.jcbLanguage.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jcbLanguage.toolTipText"));
        this.jLabel3.setFont(new Font("DejaVu Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabel3.text"));
        this.jPanel1.setBackground(new Color(179, 179, 179));
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setPreferredSize(new Dimension(199, 224));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabel5.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 177, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 214, -2).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jCheckBox1.text"));
        this.jCheckBox1.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jCheckBox1.toolTipText"));
        this.jLabel9.setFont(new Font("DejaVu Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jLabel9.text"));
        this.jcbOutputLanguage.setToolTipText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionDisplayPanel.jcbOutputLanguage.toolTipText"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 151, Short.MAX_VALUE).addComponent(this.jLabel9, -1, 151, Short.MAX_VALUE).addComponent(this.jLabel2, -1, 151, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboBox2, 0, -1, Short.MAX_VALUE).addComponent(this.jcbLanguage, 0, -1, Short.MAX_VALUE).addComponent(this.jcbOutputLanguage, 0, 209, Short.MAX_VALUE)).addGap(32, 32, 32).addComponent(this.jPanel1, -2, 182, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(72, 72, 72).addComponent(this.jCheckBox1, -1, 450, Short.MAX_VALUE)))));
        layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel9);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jcbLanguage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jcbOutputLanguage, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBox2, -2, -1, -2)).addGap(121, 121, 121).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jCheckBox1))).addComponent(this.jPanel1, -2, 219, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        LookAndFeelProvider provider = (LookAndFeelProvider)this.jComboBox2.getSelectedItem();
        this.jLabel5.setIcon(provider == null ? null : provider.getSampleImage());
    }

    void load() {
        Registry gedcomPrefs = Registry.get(GedcomOptions.class);
        StartupOptions stopts = new StartupOptions();
        this.setLanguage(stopts.getJvmLocale());
        this.setOutputLanguage(TextOptions.getInstance().getOutputLocale(null));
        this.jComboBox2.setSelectedItem(LookAndFeelProvider.getProviderFromName((String)stopts.getJvmParameter("--laf")));
        this.jCheckBox1.setSelected(AppOptions.isRestoreViews());
    }

    void store() {
        boolean needRestart = false;
        Registry gedcomPrefs = Registry.get(GedcomOptions.class);
        StartupOptions stopts = new StartupOptions();
        needRestart |= stopts.setJvmLocale(this.getLanguage());
        TextOptions.getInstance().setOutputLocale(this.getOutputLanguage());
        needRestart |= stopts.setJvmParameter("--laf", ((LookAndFeelProvider)this.jComboBox2.getSelectedItem()).getName());
        stopts.setJvmParameter("--cp:p", ((LookAndFeelProvider)this.jComboBox2.getSelectedItem()).getClassPath());
        stopts.applyChanges();
        AppOptions.setRestoreViews(this.jCheckBox1.isSelected());
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionDisplayPanel.class, (String)"OptionPanel.saved.statustext"));
        if (needRestart) {
            Lifecycle.askForStopAndStart(null, this.getLanguage());
        }
    }

    boolean valid() {
        return true;
    }

    private String[] initLanguages(String defaultDesc) {
        ArrayList<String> langDescr = new ArrayList<String>(this.locales.length);
        langDescr.add(defaultDesc);
        for (Locale locale : this.locales) {
            if (locale.getDisplayName(locale).equals("espa\u00f1ol")) {
                langDescr.add("Castellano");
                continue;
            }
            langDescr.add(locale.getDisplayName(locale));
        }
        return langDescr.toArray(new String[0]);
    }

    private int findLanguageIndex(Locale locale) {
        int i;
        if (locale == null) {
            return -1;
        }
        for (i = 0; i < this.locales.length; ++i) {
            if (!locale.equals(this.locales[i])) continue;
            return i;
        }
        locale = new Locale(locale.getLanguage(), locale.getCountry());
        for (i = 0; i < this.locales.length; ++i) {
            if (!locale.getLanguage().equals(this.locales[i].getLanguage())) continue;
            return i;
        }
        return -1;
    }

    void setLanguage(Locale locale) {
        int i = this.findLanguageIndex(locale);
        this.jcbLanguage.setSelectedIndex(++i);
    }

    Locale getLanguage() {
        int i = this.jcbLanguage.getSelectedIndex() - 1;
        if (i < 0 || i >= this.locales.length) {
            return null;
        }
        return this.locales[i];
    }

    void setOutputLanguage(Locale locale) {
        int i = this.findLanguageIndex(locale);
        this.jcbOutputLanguage.setSelectedIndex(++i);
    }

    Locale getOutputLanguage() {
        int i = this.jcbOutputLanguage.getSelectedIndex() - 1;
        if (i < 0 || i >= this.locales.length) {
            return null;
        }
        return this.locales[i];
    }
}

