/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.explorer.ExplorerNode;
import ancestris.gedcom.PropertyNode;
import ancestris.view.AncestrisTopComponent;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Note;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

class EntityNode
extends PropertyNode
implements Comparable<EntityNode>,
ExplorerNode {
    Entity entity;

    public EntityNode(Entity e) {
        super(new Context(e));
        this.entity = e;
    }

    public String getDisplayName() {
        if (this.entity instanceof Indi) {
            Indi i = (Indi)this.entity;
            return i.getName();
        }
        if (this.entity instanceof Fam) {
            Fam f = (Fam)this.entity;
            return f.toString(false);
        }
        if (this.entity instanceof Note) {
            Note n = (Note)this.entity;
            return n.getDelegate().getLines()[0];
        }
        return this.entity.toString(false);
    }

    void fireChanges() {
        this.fireDisplayNameChange(null, this.getDisplayName());
        this.fireIconChange();
    }

    public String getHtmlDisplayName() {
        return null;
    }

    public Action getPreferredAction() {
        for (AncestrisTopComponent atc : AncestrisPlugin.lookupAll(AncestrisTopComponent.class)) {
            if (!this.getContext().getGedcom().equals(atc.getGedcom())) continue;
            atc.refreshPanel(this.getContext());
        }
        return new FireNodeSelection();
    }

    public Image getIcon(int type) {
        return this.entity.getImage().getImage();
    }

    Entity getEntity() {
        return this.entity;
    }

    @Override
    public int compareTo(EntityNode that) {
        if (this.entity instanceof Indi) {
            Indi i = (Indi)this.entity;
            Indi o = (Indi)that.getEntity();
            return i.getDisplayComparator().compare((Object)i, (Object)o);
        }
        if (this.entity instanceof Fam) {
            Fam i = (Fam)this.entity;
            Fam o = (Fam)that.getEntity();
            return i.getDisplayComparator().compare((Object)i, (Object)o);
        }
        return this.entity.getDisplayComparator().compare((Object)this.entity, (Object)that.getEntity());
    }

    @Override
    public Context getContext() {
        return new Context(this.entity);
    }

    private class FireNodeSelection
    extends AbstractAction {
        private FireNodeSelection() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectionDispatcher.fireSelection((Context)EntityNode.this.getContext());
        }
    }
}

