/*
 * Decompiled with CFR 0.152.
 */
package ancestris.explorer;

import ancestris.explorer.ExplorerNode;
import ancestris.explorer.GedcomFileChildren;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class GedcomExplorerTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static GedcomExplorerTopComponent instance;
    static final String ICON_PATH = "ancestris/explorer/explorer.png";
    private static final String PREFERRED_ID = "GedcomExplorerTopComponent";
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private boolean forceClose = false;
    private JComboBox displayType;
    private JScrollPane gedcomsPane;
    private final DefaultComboBoxModel<String> displayTypeModel = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(GedcomExplorerTopComponent.class, (String)"DisplayType.AllEntities"), NbBundle.getMessage(GedcomExplorerTopComponent.class, (String)"DisplayType.Neighbourhood")});

    public GedcomExplorerTopComponent() {
        this.initComponents();
        this.displayType.setVisible(false);
        this.setName(NbBundle.getMessage(GedcomExplorerTopComponent.class, (String)"CTL_GedcomExplorerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(GedcomExplorerTopComponent.class, (String)"HINT_GedcomExplorerTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.keep_preferred_size_when_slided_in", Boolean.TRUE);
        this.putClientProperty("TopComponentAllowDockAnywhere", Boolean.TRUE);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)this.getActionMap()));
        this.explorerManager.setRootContext((Node)new AbstractNode((Children)new GedcomFileChildren()));
        ((BeanTreeView)this.gedcomsPane).setRootVisible(false);
    }

    private void initComponents() {
        this.displayType = new JComboBox();
        this.gedcomsPane = new BeanTreeView();
        this.setLayout(new BorderLayout());
        this.displayType.setModel(this.displayTypeModel);
        this.add(this.displayType, "First");
        this.add(this.gedcomsPane, "Center");
    }

    public static synchronized GedcomExplorerTopComponent getDefault() {
        if (instance == null) {
            instance = new GedcomExplorerTopComponent();
        }
        return instance;
    }

    public static synchronized GedcomExplorerTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(GedcomExplorerTopComponent.class.getName()).warning("Cannot find GedcomExplorerTopComponent component. It will not be located properly in the window system.");
            return GedcomExplorerTopComponent.getDefault();
        }
        if (win instanceof GedcomExplorerTopComponent) {
            return (GedcomExplorerTopComponent)win;
        }
        Logger.getLogger(GedcomExplorerTopComponent.class.getName()).warning("There seem to be multiple components with the 'GedcomExplorerTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return GedcomExplorerTopComponent.getDefault();
    }

    public boolean canClose() {
        return this.forceClose;
    }

    public int getPersistenceType() {
        return 2;
    }

    public void open() {
        Mode m = WindowManager.getDefault().findMode("leftSlidingSide");
        if (m != null) {
            m.dockInto((TopComponent)this);
        }
        super.open();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public ViewContext getContext() {
        Node[] nodes = this.getActivatedNodes();
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        Node contextnode = nodes[0];
        if (contextnode instanceof ExplorerNode) {
            return new ViewContext(((ExplorerNode)contextnode).getContext());
        }
        return null;
    }

    public void expandCollapse(boolean expand) {
        Node node = this.explorerManager.getRootContext();
        if ((node = node.getChildren().getNodeAt(0)) == null) {
            return;
        }
        if (expand) {
            ((BeanTreeView)this.gedcomsPane).expandNode(node);
        } else {
            ((BeanTreeView)this.gedcomsPane).collapseNode(node);
        }
    }
}

