/*
 * Decompiled with CFR 0.152.
 */
package genj.almanac;

import genj.almanac.Event;
import genj.gedcom.GedcomException;
import genj.gedcom.time.PointInTime;
import genj.timeline.AlmanacPanel;
import genj.util.EnvironmentChecker;
import genj.util.PackageUtils;
import genj.util.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;

public class Almanac {
    private static final Logger LOG = Logger.getLogger("ancestris.almanac");
    private static final Resources RESOURCES = Resources.get(Almanac.class);
    private static final String LANG = Locale.getDefault().getLanguage();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>(10);
    private static Almanac instance;
    private List<Event> events = new ArrayList<Event>();
    private static String ALMANAC_EXTENSION;
    private Set<String> almanacs = new HashSet<String>();
    private Set<String> categories = new HashSet<String>();
    private boolean isLoaded = false;

    public static synchronized Almanac getInstance() {
        if (instance == null) {
            instance = new Almanac();
        }
        return instance;
    }

    private Almanac() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        this.isLoaded = false;
        List<Event> list = this.events;
        synchronized (list) {
            this.almanacs.clear();
            this.categories.clear();
            this.events.clear();
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if ("fr".equals(Locale.getDefault().getLanguage())) {
                            new AlmanacLoader().load();
                        } else {
                            new AlmanacLoader().load();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    LOG.info("Loaded " + Almanac.this.events.size() + " events");
                    List list = Almanac.this.events;
                    synchronized (list) {
                        Almanac.this.isLoaded = true;
                        Almanac.this.events.notifyAll();
                    }
                }
            }).start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitLoaded() {
        List<Event> list = this.events;
        synchronized (list) {
            while (!this.isLoaded) {
                try {
                    this.events.wait();
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public File getUserDir() {
        return new File(EnvironmentChecker.getProperty((String[])new String[]{"ancestris.almanac.dir", "user.home.ancestris/almanac"}, (String)"contrib/almanac", (String)"Find almanac files"));
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addCategory(String name) {
        Set<String> set = this.categories;
        synchronized (set) {
            this.categories.add(name);
        }
        return name;
    }

    protected void fireStateChanged() {
        ChangeEvent e = new ChangeEvent(this);
        ChangeListener[] ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        for (int l = 0; l < ls.length; ++l) {
            ls[l].stateChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAlmanacs() {
        Set<String> set = this.almanacs;
        synchronized (set) {
            return new ArrayList<String>(this.almanacs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCategories() {
        Set<String> set = this.categories;
        synchronized (set) {
            return new ArrayList<String>(this.categories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCategories(String almanac) {
        Set<String> set = this.categories;
        synchronized (set) {
            HashSet<String> ret = new HashSet<String>();
            for (Event event : this.events) {
                if (!event.getAlmanac().equalsIgnoreCase(almanac)) continue;
                ret.addAll(event.getCategories());
            }
            return new ArrayList<String>(ret);
        }
    }

    public Iterator<Event> getEvents(PointInTime when, int days, List<String> almanacs, List<String> cats, int sigLevel) throws GedcomException {
        return new Range(when, days, almanacs, cats, sigLevel);
    }

    public Iterator<Event> getEvents(PointInTime from, PointInTime to, List<String> almanacs, List<String> cats, int sigLevel) {
        return new Range(from, to, almanacs, cats, sigLevel);
    }

    static {
        ALMANAC_EXTENSION = ".almanac";
    }

    private class Range
    implements Iterator<Event> {
        private int start;
        private int end;
        private PointInTime earliest;
        private PointInTime latest;
        private long origin = -1L;
        private long originDelta;
        private Event next;
        private List<String> almanacs;
        private List<String> cats;
        private int sigLevel;

        Range(PointInTime when, int days, List<String> almanacs, List<String> cats, int sigLevel) throws GedcomException {
            this.earliest = new PointInTime(0, 0, when.getYear() - 1);
            this.latest = new PointInTime(30, 11, when.getYear() + 1);
            this.origin = when.getJulianDay();
            this.originDelta = days;
            this.init(almanacs, cats, sigLevel);
        }

        Range(PointInTime from, PointInTime to, List<String> almanacs, List<String> cats, int sigLevel) {
            if (!from.isValid()) {
                from = new PointInTime(1, 1, 1);
            }
            if (!to.isValid()) {
                to = new PointInTime(1, 1, 1);
            }
            this.earliest = from;
            this.latest = to;
            this.init(almanacs, cats, sigLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init(List<String> almanacs, List<String> cats, int sigLevel) {
            this.almanacs = almanacs;
            this.cats = cats;
            this.sigLevel = sigLevel;
            List list = Almanac.this.events;
            synchronized (list) {
                this.end = Almanac.this.events.size();
                this.start = this.getStartIndex(this.earliest.getYear());
                this.hasNext();
            }
        }

        boolean end() {
            this.next = null;
            this.start = this.end;
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            List list = Almanac.this.events;
            synchronized (list) {
                if (Almanac.this.events.size() != this.end) {
                    return this.end();
                }
                while (true) {
                    PointInTime time;
                    if (this.start == this.end) {
                        return this.end();
                    }
                    this.next = (Event)Almanac.this.events.get(this.start++);
                    if (this.almanacs != null && !this.next.isAlmanac(this.almanacs) || this.cats != null && !this.next.isCategory(this.cats) || this.sigLevel > -1 && !this.next.isLevel(this.sigLevel) || (time = this.next.getTime()).compareTo(this.earliest) < 0) continue;
                    if (time.compareTo(this.latest) > 0) {
                        return this.end();
                    }
                    if (this.origin <= 0L) break;
                    long delta = this.next.getJulian() - this.origin;
                    if (delta > this.originDelta) {
                        return this.end();
                    }
                    if (delta >= -this.originDelta) break;
                }
                return true;
            }
        }

        @Override
        public Event next() {
            if (this.next == null && !this.hasNext()) {
                throw new IllegalArgumentException("no next");
            }
            Event result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private int getStartIndex(int year) {
            if (Almanac.this.events.isEmpty()) {
                return 0;
            }
            return this.getStartIndex(year, 0, Almanac.this.events.size() - 1);
        }

        private int getStartIndex(int year, int start, int end) {
            if (end == start) {
                return start;
            }
            int pivot = (start + end) / 2;
            int y = ((Event)Almanac.this.events.get(pivot)).getTime().getYear();
            if (y < year) {
                return this.getStartIndex(year, pivot + 1, end);
            }
            return this.getStartIndex(year, start, pivot);
        }
    }

    private class WikipediaLoader
    extends Loader {
        private Pattern REGEX_LINE;
        private String SUFFIX;
        private String file;

        private WikipediaLoader() {
            this.REGEX_LINE = Pattern.compile("(.*?)\\\\(.*?)\\\\(.*)");
            this.SUFFIX = ".wikipedia.zip";
        }

        @Override
        protected File getDirectory() {
            File result = new File(EnvironmentChecker.getProperty((String[])new String[]{"ancestris.wikipedia.dir", "user.home.ancestris/contrib/wikipedia"}, (String)"contrib/wikipedia", (String)"find wikipedia files"));
            String lang = Locale.getDefault().getLanguage();
            String[] list = result.list(this);
            if (list != null) {
                List<String> files = Arrays.asList(list);
                if (files.contains(lang + this.SUFFIX)) {
                    this.file = lang + this.SUFFIX;
                } else if (files.contains("en" + this.SUFFIX)) {
                    this.file = "en" + this.SUFFIX;
                } else if (!files.isEmpty()) {
                    this.file = files.get(0);
                }
            }
            return result;
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.file == null ? name.endsWith(this.SUFFIX) : this.file.equals(name);
        }

        @Override
        protected BufferedReader open(File file) throws IOException {
            ZipInputStream in = new ZipInputStream(new FileInputStream(file));
            ZipEntry entry = in.getNextEntry();
            if (!file.getName().startsWith(entry.getName())) {
                throw new IOException("Unexpected entry " + entry + " in " + file);
            }
            return new BufferedReader(new InputStreamReader((InputStream)in, Charset.forName("UTF-8")));
        }

        @Override
        protected Event load(String almanacName, String line) throws GedcomException {
            if (line.startsWith("#")) {
                return null;
            }
            Matcher match = this.REGEX_LINE.matcher(line);
            if (!match.matches()) {
                return null;
            }
            String yyyymmdd = match.group(1);
            String group = match.group(2) + " (Wikipedia)";
            String text = match.group(3);
            PointInTime pit = new PointInTime(yyyymmdd);
            if (!pit.isValid()) {
                return null;
            }
            List<String> cats = Collections.singletonList(Almanac.this.addCategory(group));
            return new Event(almanacName, cats, AlmanacPanel.MIN_SIG, pit, text);
        }

        @Override
        protected void loadFromResources(File[] loaded) {
        }
    }

    private class AlmanacLoader
    extends Loader {
        private AlmanacLoader() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(ALMANAC_EXTENSION);
        }

        @Override
        protected File getDirectory() {
            return Almanac.this.getUserDir();
        }

        @Override
        protected BufferedReader open(File file) throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
        }

        @Override
        protected Event load(String almanacName, String line) throws GedcomException {
            String region;
            String state;
            String country;
            if (line.startsWith("#") || line.startsWith(" ")) {
                return null;
            }
            StringTokenizer cols = new StringTokenizer(line, ";", true);
            String date = cols.nextToken().trim();
            cols.nextToken();
            if (date.length() < 4) {
                return null;
            }
            int year = Integer.parseInt(date.substring(0, 4));
            int month = date.length() >= 6 ? Integer.parseInt(date.substring(4, 6)) - 1 : Integer.MAX_VALUE;
            int day = date.length() >= 8 ? Integer.parseInt(date.substring(6, 8)) - 1 : Integer.MAX_VALUE;
            PointInTime time = new PointInTime(day, month, year);
            if (!time.isValid()) {
                return null;
            }
            String date2 = cols.nextToken();
            if (!date2.equals(";")) {
                cols.nextToken();
            }
            if (!(country = cols.nextToken().trim()).equals(";")) {
                cols.nextToken();
            }
            if (!(state = cols.nextToken().trim()).equals(";")) {
                cols.nextToken();
            }
            if (!(region = cols.nextToken().trim()).equals(";")) {
                cols.nextToken();
            }
            int sig = Integer.parseInt(cols.nextToken());
            cols.nextToken();
            List<String> cats = this.getCategories(cols.nextToken().trim());
            if (cats.isEmpty()) {
                return null;
            }
            cols.nextToken();
            String desc = null;
            while (cols.hasMoreTokens()) {
                int i;
                String translation = cols.nextToken().trim();
                if (translation.equals(";") || (i = translation.indexOf(61)) < 0) continue;
                String lang = translation.substring(0, i);
                if (desc != null && !LANG.equals(lang)) continue;
                desc = translation.substring(i + 1);
            }
            if (desc == null) {
                return null;
            }
            return new Event(almanacName, cats, sig, time, desc);
        }

        private List<String> getCategories(String cats) {
            ArrayList<String> result = new ArrayList<String>();
            for (int c = 0; c < cats.length(); ++c) {
                String key = cats.substring(c, c + 1);
                String cat = RESOURCES.getString("category." + key, false);
                if (cat == null) {
                    cat = RESOURCES.getString("category.*");
                }
                result.add(Almanac.this.addCategory(cat));
            }
            return result;
        }

        @Override
        protected void loadFromResources(File[] loaded) {
            HashSet<String> seen = new HashSet<String>();
            for (File file : loaded) {
                seen.add(file.getName());
            }
            String PCKNAME = "genj.almanac.resources";
            try {
                for (String res : PackageUtils.findInPackage((String)"genj.almanac.resources", (Pattern)Pattern.compile(".*/[^/]*\\" + ALMANAC_EXTENSION))) {
                    String name = res.substring("genj.almanac.resources".length() + 1);
                    if (seen.contains(name)) continue;
                    try {
                        String almanacName = this.incrementAlmanacs(name);
                        this.load(almanacName, new BufferedReader(new InputStreamReader(Almanac.class.getResourceAsStream("/" + "genj.almanac.resources".replace('.', '/') + "/" + name))));
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, "IO Problem reading " + res, ex);
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private abstract class Loader
    implements FilenameFilter {
        private Loader() {
        }

        protected void load() {
            File dir = this.getDirectory();
            File[] files = !dir.exists() || !dir.isDirectory() ? new File[]{} : dir.listFiles();
            if (files.length == 0) {
                LOG.info("No files found in user dir: " + dir.getAbsoluteFile() + ". Using resource almanacs only...");
            } else {
                for (int f = 0; f < files.length; ++f) {
                    File file = files[f];
                    if (!this.accept(dir, file.getName())) continue;
                    LOG.info("Loading " + file.getAbsoluteFile());
                    try {
                        String almanacName = this.incrementAlmanacs(file.getName());
                        this.load(almanacName, this.open(file));
                        continue;
                    }
                    catch (IOException e) {
                        LOG.log(Level.WARNING, "IO Problem reading " + file.getAbsoluteFile(), e);
                    }
                }
            }
            this.loadFromResources(files);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void load(String almanacName, BufferedReader in) throws IOException {
            String line = in.readLine();
            while (line != null) {
                block7: {
                    try {
                        Event event = this.load(almanacName, line);
                        if (event == null) break block7;
                        int index = Collections.binarySearch(Almanac.this.events, event);
                        if (index < 0) {
                            index = -index - 1;
                        }
                        List list = Almanac.this.events;
                        synchronized (list) {
                            Almanac.this.events.add(index, event);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                line = in.readLine();
            }
            Almanac.this.fireStateChanged();
        }

        protected abstract void loadFromResources(File[] var1);

        protected abstract BufferedReader open(File var1) throws IOException;

        protected abstract Event load(String var1, String var2) throws GedcomException;

        protected abstract File getDirectory();

        protected String incrementAlmanacs(String name) {
            name = name.replace(ALMANAC_EXTENSION, "");
            String countryCode = name.substring(0, 2);
            String countryName = new Locale("", countryCode).getDisplayCountry();
            String ret = countryName + (name.length() > 2 ? name.substring(2) : "");
            Almanac.this.almanacs.add(ret);
            return ret;
        }
    }
}

