/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import ancestris.api.editor.Editor;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.AncestrisActionProvider;
import ancestris.core.actions.SubMenuAction;
import ancestris.core.resources.Images;
import ancestris.util.swing.DialogManager;
import ancestris.view.SelectionDispatcher;
import genj.edit.ChoosePropertyBean;
import genj.edit.EditView;
import genj.edit.EditViewFactory;
import genj.edit.PropertyTreeWidget;
import genj.edit.SelectEntityToPropagatePanel;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.io.PropertyReader;
import genj.io.PropertyTransferable;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.openide.nodes.Node;
import org.openide.windows.WindowManager;

class AdvancedEditor
extends Editor {
    private static final String ACC_CUT = "ctrl X";
    private static final String ACC_COPY = "ctrl C";
    private static final String ACC_PASTE = "ctrl V";
    private static final Clipboard clipboard = AdvancedEditor.initClipboard();
    private static final Registry REGISTRY = Registry.get(AdvancedEditor.class);
    private Set<TagPath> expands = new TreeSet<TagPath>();
    private boolean ignoreTreeSelection = false;
    private static Resources resources = Resources.get(AdvancedEditor.class);
    private Gedcom gedcom;
    private PropertyTreeWidget tree = null;
    private JPanel editPane;
    private PropertyBean bean = null;
    private JSplitPane splitPane = null;
    private EditView view;
    private Callback callback;

    private static Clipboard initClipboard() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Throwable t) {
            return new Clipboard("Ancestris");
        }
    }

    public AdvancedEditor(Gedcom gedcom, EditView view) {
        this.gedcom = gedcom;
        this.view = view;
        this.tree = new Tree();
        this.callback = new Callback();
        this.tree.addTreeSelectionListener(this.callback);
        this.tree.addTreeWillExpandListener(this.callback);
        JScrollPane treePane = new JScrollPane((Component)((Object)this.tree));
        treePane.setMinimumSize(new Dimension(160, 128));
        treePane.setPreferredSize(new Dimension(160, 128));
        treePane.getHorizontalScrollBar().setFocusable(false);
        treePane.getVerticalScrollBar().setFocusable(false);
        this.editPane = new JPanel(new BorderLayout());
        JScrollPane editScroll = new JScrollPane(this.editPane);
        editScroll.getVerticalScrollBar().setFocusable(false);
        editScroll.getHorizontalScrollBar().setFocusable(false);
        this.splitPane = new JSplitPane(0, treePane, editScroll);
        this.splitPane.setDividerLocation(REGISTRY.get("divider", 300));
        this.splitPane.setContinuousLayout(true);
        this.splitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("dividerLocation".equals(evt.getPropertyName())) {
                    REGISTRY.put("divider", AdvancedEditor.this.splitPane.getDividerLocation());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.splitPane, "Center");
        this.setFocusTraversalPolicy(new FocusPolicy());
        this.setFocusCycleRoot(true);
        String paths = REGISTRY.get("expand", "INDI:BIRT,INDI:RESI,INDI:OBJE,FAM:MARR");
        for (String path : paths.split(",")) {
            try {
                this.expands.add(new TagPath(path));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public Component getEditorComponent() {
        return this.tree;
    }

    public void removeNotify() {
        WordBuffer paths = new WordBuffer(",");
        for (TagPath path : this.expands) {
            paths.append((Object)path);
        }
        REGISTRY.put("expand", paths.toString());
        super.removeNotify();
    }

    public ViewContext getContext() {
        return this.tree.getContext();
    }

    protected void setContextImpl(Context context) {
        this.setContextImpl(context, false);
    }

    private void setContextImpl(Context context, boolean pickFirstProperty) {
        List<Object> props;
        Property root;
        if (this.bean != null) {
            this.bean.removeChangeListener((ChangeListener)this.changes);
        }
        this.bean = null;
        this.editPane.removeAll();
        this.editPane.revalidate();
        this.editPane.repaint();
        this.changes.setChanged(false);
        if (context.getGedcom() == null) {
            try {
                this.ignoreTreeSelection = true;
                this.tree.setRoot(null);
            }
            finally {
                this.ignoreTreeSelection = false;
            }
            return;
        }
        if (context.getEntities().isEmpty()) {
            context = new Context(context.getGedcom().getFirstEntity("HEAD"));
        }
        this.ignoreTreeSelection = true;
        this.tree.clearSelection();
        Entity entity = context.getEntity();
        if (entity != this.tree.getRoot()) {
            this.tree.setRoot((Property)entity);
            for (TagPath path : this.expands) {
                this.expand(path);
            }
        }
        if ((root = this.tree.getRoot()) != null) {
            Gedcom gedcom = root.getGedcom();
            this.view.commit();
        }
        if ((props = context.getProperties()).isEmpty()) {
            props = pickFirstProperty && entity.getNoOfProperties() > 0 ? Collections.singletonList(entity.getProperty(0)) : Collections.singletonList(entity);
        }
        this.tree.setSelection((List<? extends Property>)props);
        this.ignoreTreeSelection = false;
        if (props.isEmpty()) {
            return;
        }
        Property prop = (Property)props.get(props.size() - 1);
        try {
            this.expand(prop.getPath());
            this.bean = PropertyBean.getBean(prop.getClass()).setContext(prop);
            this.editPane.add((Component)this.bean, "Center");
            JToolBar header = new JToolBar();
            header.setFloatable(false);
            if (prop instanceof PropertyXRef) {
                JButton follow = new JButton((Action)((Object)new Follow((PropertyXRef)prop)));
                header.add(follow);
            } else {
                JLabel label = new JLabel(Gedcom.getName((String)prop.getTag()), (Icon)prop.getImage(false), 2);
                label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                header.add(label);
            }
            this.editPane.add((Component)header, "North");
            this.changes.setChanged(false);
            this.bean.addChangeListener((ChangeListener)this.changes);
            if (this.view.isGrabFocus()) {
                this.bean.requestFocus();
            }
        }
        catch (Throwable t) {
            EditView.LOG.log(Level.WARNING, "Property bean " + this.bean, t);
        }
    }

    public void expand(TagPath path) {
        this.tree.expand(path);
    }

    public void commit() throws GedcomException {
        Property root = this.tree.getRoot();
        if (root == null) {
            return;
        }
        if (this.bean != null) {
            this.bean.commit();
        }
    }

    public Image getImageIcon() {
        return new EditViewFactory().getImage().getImage();
    }

    public String getName() {
        return new EditViewFactory().getTitle();
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Entity getEditedEntity() {
        return this.view.getEntity();
    }

    private class Tree
    extends PropertyTreeWidget
    implements AncestrisActionProvider {
        private Tree() {
            super(AdvancedEditor.this.gedcom);
            this.setRequestFocusEnabled(false);
        }

        public List<Action> getActions(boolean hasFocus, Node[] nodes) {
            if (!hasFocus) {
                return new ArrayList<Action>();
            }
            List<Property> selection = AdvancedEditor.this.tree.getSelection();
            ArrayList<Action> result = new ArrayList<Action>();
            if (nodes.length != 0) {
                result.add((Action)((Object)new Cut(selection)));
                result.add((Action)((Object)new Copy(selection)));
            }
            if (selection.size() == 1) {
                result.add((Action)((Object)new Paste(selection.get(0))));
                result.add(null);
                Property prop = selection.get(0);
                if (!prop.isTransient()) {
                    SubMenuAction menu = new SubMenuAction(resources.getString("action.add"));
                    menu.setTip(resources.getString("action.add.tip"));
                    Object[] metas = prop.getNestedMetaProperties(5);
                    Arrays.sort(metas);
                    for (int i = 0; i < metas.length; ++i) {
                        if (!metas[i].isInstantiated()) {
                            // empty if block
                        }
                        menu.addAction((Action)((Object)new Add(prop, (MetaProperty)metas[i])));
                    }
                    result.add((Action)menu);
                    result.add((Action)((Object)new Add(prop)));
                }
            } else {
                result.add(null);
            }
            if (!selection.isEmpty() && !selection.contains(AdvancedEditor.this.tree.getRoot())) {
                result.add((Action)((Object)new Propagate(selection)));
            }
            return result;
        }
    }

    private class FocusPolicy
    extends LayoutFocusTraversalPolicy {
        private FocusPolicy() {
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int[] selection;
            Component result = super.getComponentAfter(focusCycleRoot, aComponent);
            if (result == null) {
                return null;
            }
            if (AdvancedEditor.this.bean != null && !SwingUtilities.isDescendingFrom(result, (Component)AdvancedEditor.this.bean) && (selection = AdvancedEditor.this.tree.getSelectionRows()) != null && selection.length > 0) {
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        AdvancedEditor.this.tree.setSelectionRow((selection[0] + 1) % AdvancedEditor.this.tree.getRowCount());
                    }
                });
            }
            return result;
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int[] selection;
            Component result = super.getComponentBefore(focusCycleRoot, aComponent);
            if (result == null) {
                return null;
            }
            if (AdvancedEditor.this.bean != null && !SwingUtilities.isDescendingFrom(result, (Component)AdvancedEditor.this.bean) && (selection = AdvancedEditor.this.tree.getSelectionRows()) != null && selection.length > 0) {
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        int i = selection[0] - 1;
                        if (i >= 0) {
                            AdvancedEditor.this.tree.setSelectionRow(i % AdvancedEditor.this.tree.getRowCount());
                        }
                    }
                });
            }
            return result;
        }
    }

    private class Callback
    implements TreeSelectionListener,
    TreeWillExpandListener {
        private Callback() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (AdvancedEditor.this.ignoreTreeSelection || AdvancedEditor.this.tree.getRoot() == null) {
                return;
            }
            List<Property> selection = AdvancedEditor.this.tree.getSelection();
            Context ctx = new Context(AdvancedEditor.this.gedcom, Collections.singletonList((Entity)AdvancedEditor.this.tree.getRoot()), selection);
            if (!selection.isEmpty()) {
                SelectionDispatcher.fireSelection((Context)ctx);
                if (ctx.getProperties().size() != 1) {
                    AdvancedEditor.this.setContextImpl(ctx, false);
                }
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            int len = path.getPathCount();
            if (len == 1) {
                throw new ExpandVetoException(event);
            }
            String[] tags = new String[len];
            for (int i = 0; i < len; ++i) {
                tags[i] = ((Property)path.getPathComponent(i)).getTag();
            }
            AdvancedEditor.this.expands.remove(new TagPath(tags, null));
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            TreePath path = event.getPath();
            int len = path.getPathCount();
            if (len == 1) {
                return;
            }
            String[] tags = new String[len];
            for (int i = 0; i < len; ++i) {
                tags[i] = ((Property)path.getPathComponent(i)).getTag();
            }
            AdvancedEditor.this.expands.add(new TagPath(tags, null));
        }
    }

    private class Add
    extends AbstractAncestrisAction {
        private Property parent;
        private String[] tags;
        private boolean addDefaults = true;

        protected Add(Property parent, MetaProperty meta) {
            this.parent = parent;
            String txt = meta.getName();
            if (!txt.equals(meta.getTag())) {
                txt = txt + " (" + meta.getTag() + ")";
            }
            this.setText(txt);
            this.setImage((Icon)meta.getImage());
            this.tags = new String[]{meta.getTag()};
        }

        protected Add(Property parent) {
            this.parent = parent;
            this.setText(resources.getString("action.list.add") + "...");
            this.setTip(resources.getString("action.list.add.tip"));
            this.setImage((Icon)Images.imgAdd);
        }

        public void actionPerformed(ActionEvent event) {
            PropertyDate pdate;
            Property newProp;
            if (this.tags == null) {
                JLabel label = new JLabel(resources.getString("add.choose"));
                label.setBorder(BorderFactory.createEmptyBorder(6, 0, 6, 0));
                ChoosePropertyBean choose = new ChoosePropertyBean(this.parent);
                JCheckBox check = new JCheckBox(resources.getString("add.default_too"), this.addDefaults);
                if (DialogManager.create((String)resources.getString("add.title"), (JComponent[])new JComponent[]{label, choose, check}).setMessageType(3).setOptionType(2).setDialogId("add.title").show() != DialogManager.OK_OPTION) {
                    return;
                }
                this.tags = choose.getSelectedTags();
                this.addDefaults = check.isSelected();
                if (this.tags.length == 0) {
                    DialogManager.createError(null, (String)resources.getString("add.must_enter")).show();
                    return;
                }
            }
            AdvancedEditor.this.tree.clearSelection();
            final ArrayList newProps = new ArrayList();
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) {
                    for (int i = 0; i < Add.this.tags.length; ++i) {
                        Property prop = Add.this.parent.addProperty(Add.this.tags[i], "");
                        newProps.add(prop);
                        if (!Add.this.addDefaults) continue;
                        prop.addDefaultProperties();
                    }
                }
            });
            Property property = newProp = newProps.isEmpty() ? null : (Property)newProps.get(0);
            if (newProp instanceof PropertyEvent && (pdate = ((PropertyEvent)newProp).getDate(false)) != null) {
                newProp = pdate;
            }
            try {
                AdvancedEditor.this.tree.setSelectionPath(new TreePath(AdvancedEditor.this.tree.getPathFor(newProp)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private class Follow
    extends AbstractAncestrisAction {
        private PropertyXRef xref;

        public Follow(PropertyXRef xref) {
            this.xref = xref;
            this.setText(Gedcom.getName((String)xref.getTag()));
            this.setImage((Icon)xref.getImage(false));
        }

        public void actionPerformed(ActionEvent e) {
            SelectionDispatcher.fireSelection((Context)new Context((Property)this.xref));
        }
    }

    private class Paste
    extends AbstractAncestrisAction {
        private Property presetParent;

        protected Paste(Property property) {
            this.presetParent = property;
            this.setText(resources.getString("action.paste"));
            this.setTip(resources.getString("action.paste.tip"));
            this.setImage((Icon)Images.imgPaste);
        }

        protected Paste() {
        }

        public void actionPerformed(ActionEvent event) {
            Property parent;
            String content;
            try {
                content = clipboard.getContents((Object)this).getTransferData(DataFlavor.stringFlavor).toString();
            }
            catch (Throwable t) {
                EditView.LOG.log(Level.INFO, "Accessing system clipboard as stringFlavor failed ({0})", t.getMessage());
                return;
            }
            if (this.presetParent != null) {
                parent = this.presetParent;
            } else if (AdvancedEditor.this.tree.getSelectionCount() == 1) {
                parent = AdvancedEditor.this.tree.getSelection().get(0);
            } else {
                return;
            }
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    PropertyReader reader = new PropertyReader((Reader)new StringReader(content), null, true);
                    reader.setMerge(true);
                    try {
                        reader.read(parent);
                    }
                    catch (IOException e) {
                        throw new GedcomException("IO during read()");
                    }
                }
            });
        }
    }

    private class Copy
    extends AbstractAncestrisAction {
        protected List<Property> presetSelection;

        protected Copy(List<Property> preset) {
            this.presetSelection = Property.normalize(preset);
            this.setText(resources.getString("action.copy"));
            this.setTip(resources.getString("action.copy.tip"));
            this.setImage((Icon)Images.imgCopy);
        }

        protected Copy() {
        }

        public void actionPerformed(ActionEvent event) {
            List<Property> selection = this.presetSelection;
            if (selection == null) {
                selection = Property.normalize(AdvancedEditor.this.tree.getSelection());
            }
            if (selection.contains(AdvancedEditor.this.tree.getRoot())) {
                selection = Arrays.asList(AdvancedEditor.this.tree.getRoot().getProperties());
            }
            try {
                clipboard.setContents(new PropertyTransferable((List)selection).getStringTransferable(), null);
            }
            catch (Throwable t) {
                EditView.LOG.log(Level.WARNING, "Couldn't copy properties", t);
            }
        }
    }

    private class Cut
    extends AbstractAncestrisAction {
        protected List<Property> presetSelection;

        private Cut(List<Property> preset) {
            this.presetSelection = Property.normalize(preset);
            this.setImage((Icon)Images.imgCut);
            this.setText(resources.getString("action.cut"));
            this.setTip(resources.getString("action.cut.tip"));
        }

        private Cut() {
        }

        public void actionPerformed(ActionEvent event) {
            String veto;
            List selection;
            List list = selection = this.presetSelection != null ? this.presetSelection : Property.normalize(AdvancedEditor.this.tree.getSelection());
            if (selection.isEmpty()) {
                return;
            }
            if (selection.contains(AdvancedEditor.this.tree.getRoot())) {
                selection.clear();
                selection.addAll(Arrays.asList(AdvancedEditor.this.tree.getRoot().getProperties()));
            }
            if ((veto = this.getVeto(selection)).length() > 0) {
                String cut = resources.getString("action.cut");
                if (DialogManager.create((String)resources.getString("action.cut"), (String)veto).setMessageType(2).setOptions(new Object[]{cut, DialogManager.CANCEL_OPTION}).setDialogId("action.cut").show() != cut) {
                    return;
                }
            }
            try {
                clipboard.setContents(new PropertyTransferable(selection).getStringTransferable(), null);
            }
            catch (Throwable t) {
                EditView.LOG.log(Level.WARNING, "Couldn't copy properties", t);
                return;
            }
            AdvancedEditor.this.gedcom.doMuteUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) {
                    Property parent = null;
                    for (Property prop : selection) {
                        parent = prop.getParent();
                        parent.delProperty(prop);
                    }
                    if (parent != null) {
                        SelectionDispatcher.fireSelection((Context)new Context(parent));
                        AdvancedEditor.this.expand(parent.getPath());
                    }
                }
            });
        }

        private String getVeto(List<Property> properties) {
            boolean found = false;
            String msg = resources.getString("del.warning.message");
            StringBuilder result = new StringBuilder();
            for (Property p : properties) {
                String veto = p.getDeleteVeto();
                if (veto == null) continue;
                found = true;
                result.append(resources.getString("del.warning", new Object[]{p.getPropertyName(), p.getParent().getPropertyName(), veto}));
                result.append("\n\n");
            }
            if (found) {
                return msg + result.toString();
            }
            return "";
        }
    }

    private class Propagate
    extends AbstractAncestrisAction {
        private Entity entity;
        private List<Property> properties;
        private String what;

        private Propagate(List<Property> selection) {
            this.entity = (Entity)AdvancedEditor.this.tree.getRoot();
            this.properties = Property.normalize(selection);
            this.setImage((Icon)Images.imgPropagate);
            if (this.properties.isEmpty()) {
                this.setText(resources.getString("action.propagate", new Object[]{""}));
                this.setEnabled(false);
                return;
            }
            this.what = "'" + Property.getPropertyNames(this.properties, (int)5) + "'";
            this.setText(resources.getString("action.propagate") + "...");
            this.setTip(resources.getString("action.propagate.tip", new Object[]{this.what}));
        }

        public void actionPerformed(ActionEvent event) {
            final SelectEntityToPropagatePanel select = new SelectEntityToPropagatePanel(AdvancedEditor.this.gedcom, this.entity.getTag(), this.what, AdvancedEditor.this.gedcom.getEntity(REGISTRY.get("select." + this.entity.getTag(), (String)null)), resources.getString("action.propagate.toall"));
            if (DialogManager.OK_OPTION != DialogManager.create((String)resources.getString("action.propagate", new Object[]{""}), (JComponent)select).setMessageType(2).setOptionType(2).setDialogId("propagate.entityselected").show()) {
                return;
            }
            final Entity selection = select.getSelection();
            REGISTRY.put("select." + this.entity.getTag(), selection != null ? selection.getId() : null);
            try {
                AdvancedEditor.this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        for (Entity entity : selection != null ? Collections.singletonList(selection) : gedcom.getEntities(Propagate.this.entity.getTag())) {
                            Propagate.this.copy(Propagate.this.properties, Propagate.this.entity, entity, select.isSelected());
                        }
                    }
                });
            }
            catch (GedcomException e) {
                DialogManager.createError(null, (String)e.getMessage()).show();
            }
        }

        private void copy(List<Property> selection, Entity from, Entity to, boolean values) throws GedcomException {
            if (from == to) {
                return;
            }
            for (Property property : selection) {
                TagPath path = property.getParent().getPath();
                Property root = to.getProperty(path);
                if (root == null) {
                    root = to.setValue(path, "");
                }
                root.copyProperties(property, values);
            }
        }
    }
}

