/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.resources.Images;
import ancestris.util.swing.DialogManager;
import genj.edit.BeanPanel;
import genj.edit.actions.CreateXReference;
import genj.edit.actions.GedcomDialog;
import genj.edit.beans.ReferencesBean;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TableWidget;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class EditSource
extends AbstractAncestrisAction {
    private static final Resources RESOURCES = Resources.get(EditSource.class);
    public static final ImageIcon EDIT_SOUR = Grammar.V551.getMeta(new TagPath("SOUR")).getImage();
    public static final ImageIcon NEW_SOUR = EDIT_SOUR.getOverLayed(Images.imgNew);
    public static final ImageIcon NO_SOUR = EDIT_SOUR.getTransparent(128);
    private Property property;

    public EditSource(Property property) {
        this(property, false);
    }

    public EditSource(Property property, boolean showNone) {
        boolean has;
        this.property = property;
        boolean bl = has = !this.getSources(property).isEmpty();
        this.setImage((Icon)(has ? EDIT_SOUR : (showNone ? NO_SOUR : NEW_SOUR)));
        this.setText(has ? RESOURCES.getString("edit", new Object[]{Gedcom.getName((String)"SOUR", (boolean)true)}) : RESOURCES.getString("new", new Object[]{Gedcom.getName((String)"SOUR")}));
        this.setTip(this.getText());
    }

    private List<PropertySource> getSources(Property property) {
        ArrayList<PropertySource> sources = new ArrayList<PropertySource>();
        for (Property source : property.getProperties("SOUR", true)) {
            if (!(source instanceof PropertySource)) continue;
            sources.add((PropertySource)source);
        }
        return sources;
    }

    public void actionPerformed(ActionEvent e) {
        List<PropertySource> sources = this.getSources(this.property);
        if (!sources.isEmpty()) {
            TableWidget table = new TableWidget();
            String linkSource = RESOURCES.getString("link", new Object[]{Gedcom.getName((String)"SOUR")});
            final GedcomDialog dlg = new GedcomDialog(this.property.getGedcom(), this.property.toString() + " - " + this.getTip(), new JScrollPane((Component)table));
            dlg.setMessageType(3);
            dlg.setOptions(new Object[]{DialogManager.OK_OPTION, linkSource});
            TableWidget tableWidget = table;
            tableWidget.getClass();
            new TableWidget.Column(tableWidget, Gedcom.getName((String)"SOUR")){
                {
                    TableWidget tableWidget = x0;
                    tableWidget.getClass();
                    super(tableWidget, x1);
                }

                public Object getValue(PropertySource source) {
                    return source.getTargetEntity().getId();
                }
            };
            TableWidget tableWidget2 = table;
            tableWidget2.getClass();
            new TableWidget.Column(tableWidget2, Gedcom.getName((String)"AUTH")){
                {
                    TableWidget tableWidget = x0;
                    tableWidget.getClass();
                    super(tableWidget, x1);
                }

                public Object getValue(PropertySource source) {
                    return source.getTargetEntity().getPropertyDisplayValue("AUTH");
                }
            };
            TableWidget tableWidget3 = table;
            tableWidget3.getClass();
            new TableWidget.Column(tableWidget3, Gedcom.getName((String)"TITL")){
                {
                    TableWidget tableWidget = x0;
                    tableWidget.getClass();
                    super(tableWidget, x1);
                }

                public Object getValue(PropertySource source) {
                    return source.getTargetEntity().getPropertyDisplayValue("TITL");
                }
            };
            TableWidget tableWidget4 = table;
            tableWidget4.getClass();
            new TableWidget.Column(tableWidget4, Gedcom.getName((String)"PAGE")){
                {
                    TableWidget tableWidget = x0;
                    tableWidget.getClass();
                    super(tableWidget, x1);
                }

                public Object getValue(PropertySource source) {
                    return source.getPropertyDisplayValue("PAGE");
                }
            };
            TableWidget tableWidget5 = table;
            tableWidget5.getClass();
            new TableWidget.Column(tableWidget5, "", AbstractAncestrisAction.class){
                {
                    TableWidget tableWidget = x0;
                    tableWidget.getClass();
                    super(tableWidget, x1, x2);
                }

                public Object getValue(PropertySource source) {
                    return new Edit(source, false){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            dlg.cancel();
                            super.actionPerformed(event);
                        }
                    };
                }
            };
            table.setRows(sources);
            if (dlg.show() != linkSource) {
                return;
            }
        }
        CreateXReference create = new CreateXReference(this.property, "SOUR");
        create.actionPerformed(e);
        PropertySource source = (PropertySource)create.getReference();
        if (source != null) {
            new Edit(source, true).actionPerformed(new ActionEvent(e.getSource(), 0, ""));
        }
    }

    private class Edit
    extends AbstractAncestrisAction {
        private boolean deleteOnCancel;
        private PropertySource citation;

        public Edit(PropertySource citation, boolean deleteOnCancel) {
            this.deleteOnCancel = deleteOnCancel;
            this.setText(RESOURCES.getString("edit", new Object[]{Gedcom.getName((String)"SOUR")}));
            this.setTip(this.getText());
            this.setImage((Icon)Images.imgView);
            this.citation = citation;
        }

        public void actionPerformed(ActionEvent e) {
            JTabbedPane tabs = new JTabbedPane();
            final BeanPanel citationPanel = new BeanPanel();
            citationPanel.setRoot((Property)this.citation);
            tabs.add(RESOURCES.getString("citation"), citationPanel);
            final BeanPanel sourcePanel = new BeanPanel(){

                @Override
                protected JComponent createComponent(Property root, Property property, NestedBlockLayout.Cell cell, Set<String> beanifiedTags) {
                    JComponent c = super.createComponent(root, property, cell, beanifiedTags);
                    return c instanceof ReferencesBean || c instanceof NestedBlockLayout.Expander ? null : c;
                }
            };
            sourcePanel.setRoot((Property)this.citation.getTargetEntity());
            tabs.add(Gedcom.getName((String)"SOUR"), sourcePanel);
            GedcomDialog dlg = new GedcomDialog(this.citation.getGedcom(), this.getText(), tabs);
            dlg.setMessageType(3);
            dlg.setOptionType(2);
            if (dlg.show() == DialogManager.OK_OPTION) {
                this.citation.getGedcom().doMuteUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        sourcePanel.commit();
                        citationPanel.commit();
                    }
                });
            } else if (this.deleteOnCancel) {
                this.citation.getGedcom().doMuteUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        Source source = (Source)Edit.this.citation.getTargetEntity();
                        Edit.this.citation.getParent().delProperty((Property)Edit.this.citation);
                        if (!source.isConnected()) {
                            gedcom.deleteEntity((Entity)source);
                        }
                    }
                });
            }
        }
    }
}

