/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.boot.script;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.netbeans.html.boot.spi.Fn;

final class ScriptPresenter
implements Fn.KeepAlive,
Fn.Presenter,
Fn.FromJavaScript,
Fn.ToJavaScript,
Executor {
    private static final Logger LOG = Logger.getLogger(ScriptPresenter.class.getName());
    private final ScriptEngine eng;
    private final Executor exc;
    private FnImpl wrapArrImpl;
    private FnImpl arraySize;

    public ScriptPresenter(Executor exc) {
        this.exc = exc;
        try {
            this.eng = new ScriptEngineManager().getEngineByName("javascript");
            this.eng.eval("function alert(msg) { Packages.java.lang.System.out.println(msg); };");
            this.eng.eval("function confirm(msg) { Packages.java.lang.System.out.println(msg); return true; };");
            this.eng.eval("function prompt(msg, txt) { Packages.java.lang.System.out.println(msg + ':' + txt); return txt; };");
        }
        catch (ScriptException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Fn defineFn(String code, String ... names) {
        return this.defineImpl(code, names, null);
    }

    public Fn defineFn(String code, String[] names, boolean[] keepAlive) {
        return this.defineImpl(code, names, keepAlive);
    }

    private FnImpl defineImpl(String code, String[] names, boolean[] keepAlive) {
        Object fn;
        StringBuilder sb = new StringBuilder();
        sb.append("(function() {\n");
        sb.append("  return function(");
        String sep = "";
        if (names != null) {
            for (String n : names) {
                sb.append(sep).append(n);
                sep = ",";
            }
        }
        sb.append(") {\n");
        sb.append(code);
        sb.append("\n  };\n");
        sb.append("})()\n");
        try {
            fn = this.eng.eval(sb.toString());
        }
        catch (ScriptException ex) {
            throw new IllegalStateException(ex);
        }
        return new FnImpl(this, fn, keepAlive);
    }

    public void displayPage(URL page, Runnable onPageLoad) {
        try {
            this.eng.eval("if (typeof window !== 'undefined') window.location = '" + page + "'");
        }
        catch (ScriptException ex) {
            LOG.log(Level.SEVERE, "Cannot load " + page, ex);
        }
        if (onPageLoad != null) {
            onPageLoad.run();
        }
    }

    public void loadScript(Reader code) throws Exception {
        this.eng.eval(code);
    }

    final Object convertArrays(Object[] arr) throws Exception {
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] instanceof Object[])) continue;
            arr[i] = this.convertArrays((Object[])arr[i]);
        }
        Object wrapArr = this.wrapArrFn().invokeImpl(null, false, arr);
        return wrapArr;
    }

    private FnImpl wrapArrFn() {
        if (this.wrapArrImpl == null) {
            try {
                this.wrapArrImpl = this.defineImpl("return Array.prototype.slice.call(arguments);", null, null);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.wrapArrImpl;
    }

    final Object checkArray(Object val) throws Exception {
        FnImpl fn = this.arraySizeFn();
        Object fnRes = fn.invokeImpl(null, false, val, null);
        int length = ((Number)fnRes).intValue();
        if (length == -1) {
            return val;
        }
        Object[] arr = new Object[length];
        fn.invokeImpl(null, false, val, arr);
        return arr;
    }

    private FnImpl arraySizeFn() {
        if (this.arraySize == null) {
            try {
                this.arraySize = this.defineImpl("\nif (to === null) {\n  if (Object.prototype.toString.call(arr) === '[object Array]') return arr.length;\n  else return -1;\n} else {\n  var l = arr.length;\n  for (var i = 0; i < l; i++) to[i] = arr[i];\n  return l;\n}", new String[]{"arr", "to"}, null);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.arraySize;
    }

    public Object toJava(Object jsArray) {
        if (jsArray instanceof Weak) {
            jsArray = ((Weak)jsArray).get();
        }
        try {
            return this.checkArray(jsArray);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Object toJavaScript(Object toReturn) {
        if (toReturn instanceof Object[]) {
            try {
                return this.convertArrays((Object[])toReturn);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        return toReturn;
    }

    @Override
    public void execute(final Runnable command) {
        if (Fn.activePresenter() == this) {
            command.run();
            return;
        }
        class Wrap
        implements Runnable {
            Wrap() {
            }

            @Override
            public void run() {
                try (Closeable c = Fn.activate((Fn.Presenter)ScriptPresenter.this);){
                    command.run();
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        Wrap wrap = new Wrap();
        if (this.exc == null) {
            wrap.run();
        } else {
            this.exc.execute(wrap);
        }
    }

    private static boolean isJSReady(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return true;
        }
        if (obj instanceof Number) {
            return true;
        }
        String cn = obj.getClass().getName();
        if (cn.startsWith("jdk.nashorn") || cn.contains(".mozilla.") && cn.contains(".Native")) {
            return true;
        }
        return obj instanceof Character;
    }

    private class FnImpl
    extends Fn {
        private final Object fn;
        private final boolean[] keepAlive;

        public FnImpl(Fn.Presenter presenter, Object fn, boolean[] keepAlive) {
            super(presenter);
            this.fn = fn;
            this.keepAlive = keepAlive;
        }

        public Object invoke(Object thiz, Object ... args) throws Exception {
            return this.invokeImpl(thiz, true, args);
        }

        final Object invokeImpl(Object thiz, boolean arrayChecks, Object ... args) throws Exception {
            ArrayList<Object> all = new ArrayList<Object>(args.length + 1);
            all.add(thiz == null ? this.fn : thiz);
            for (int i = 0; i < args.length; ++i) {
                Object conv = args[i];
                if (arrayChecks) {
                    if (args[i] instanceof Object[]) {
                        Object[] arr = (Object[])args[i];
                        conv = ((ScriptPresenter)this.presenter()).convertArrays(arr);
                    }
                    if (!(conv == null || this.keepAlive == null || this.keepAlive[i] || ScriptPresenter.isJSReady(conv) || conv.getClass().getSimpleName().equals("$JsCallbacks$"))) {
                        conv = new Weak(conv);
                    }
                    if (conv instanceof Character) {
                        conv = (int)((Character)conv).charValue();
                    }
                }
                all.add(conv);
            }
            Object ret = ((Invocable)((Object)ScriptPresenter.this.eng)).invokeMethod(this.fn, "call", all.toArray());
            if (ret instanceof Weak) {
                ret = ((Weak)ret).get();
            }
            if (ret == this.fn) {
                return null;
            }
            if (!arrayChecks) {
                return ret;
            }
            return ((ScriptPresenter)this.presenter()).checkArray(ret);
        }
    }

    private static final class Weak
    extends WeakReference<Object> {
        public Weak(Object referent) {
            super(referent);
        }
    }
}

