/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.familygroups;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.modules.familygroups.OpenFamilyGroupsAction;
import ancestris.util.Utilities;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyXRef;
import genj.io.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class FamilyGroupsPlugin
extends AncestrisPlugin {
    private int minGroupSize = 0;
    private int maxGroupSize = 0;
    private List<FamilyGroupFilter> filters = null;

    public Document start(Gedcom myGedcom) {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        Document doc = null;
        this.setMinGroupSize(Integer.valueOf(NbPreferences.forModule(OpenFamilyGroupsAction.class).get("minGroupSize", "2")));
        this.setMaxGroupSize(Integer.valueOf(NbPreferences.forModule(OpenFamilyGroupsAction.class).get("maxGroupSize", "20")));
        Collection indiList = myGedcom.getIndis();
        HashSet<Indi> unvisited = new HashSet<Indi>(indiList);
        while (!unvisited.isEmpty()) {
            Indi indi = (Indi)unvisited.iterator().next();
            Tree tree = new Tree();
            this.iterate(indi, tree, unvisited);
            if (tree.isEmpty()) continue;
            trees.add(tree);
        }
        if (!trees.isEmpty()) {
            int grandtotal = 0;
            int loners = 0;
            doc = new Document(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_OpenFamilyGroups"));
            this.filters = new ArrayList<FamilyGroupFilter>(10);
            doc.startSection(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_OpenFamilyGroups"));
            doc.startTable("width=100%, border=1");
            Collections.sort(trees);
            for (int i = 0; i < trees.size(); ++i) {
                Tree tree = (Tree)trees.get(i);
                grandtotal += tree.size();
                if (tree.size() < this.getMinGroupSize()) {
                    loners += tree.size();
                    continue;
                }
                tree.setNb(i);
                doc.nextTableRow("font-size=1.125em, font-weight=bold, line-height=200%");
                doc.nextTableCell("colspan=6, width=100%");
                doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FamilyGroupsTopComponent.groupCount", (Object[])new Object[]{i, tree.size()}));
                doc.nextTableRow();
                doc.nextTableCell("colspan=6, width=100%");
                doc.addText(tree.getTitle());
                if (tree.size() < this.getMaxGroupSize()) {
                    for (PropertyPlace PropertyPlace2 : tree.getPlaces()) {
                        if (PropertyPlace2.format(null).length() <= 0) continue;
                        doc.nextTableRow();
                        doc.nextTableCell("colspan=6, width=100%");
                        String str = PropertyPlace2.format(null).replaceAll("\\<.*?>", "").replaceAll(",", " ").trim().replaceAll(" ", ", ");
                        doc.addText(str);
                    }
                    doc.nextTableRow("font-weight=bold");
                    doc.nextTableCell("colspan=2, width=34%");
                    doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FamilyGroupsTopComponent.indi_name"));
                    doc.nextTableCell("colspan=2, width=33%");
                    doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FamilyGroupsTopComponent.familySpouse"));
                    doc.nextTableCell("colspan=2, width=33%");
                    doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FamilyGroupsTopComponent.familyChild"));
                    for (Indi indi : tree) {
                        Fam[] familiesWhereChild = indi.getFamiliesWhereChild();
                        Fam[] familiesWhereSpouse = indi.getFamiliesWhereSpouse();
                        int maxRows = Math.max(familiesWhereChild.length, familiesWhereSpouse.length);
                        for (int index = 0; index < maxRows; ++index) {
                            doc.nextTableRow();
                            if (index == 0) {
                                doc.nextTableCell("width=4%");
                                doc.addLink(indi.getId(), indi.getAnchor());
                                doc.nextTableCell("width=30%");
                                doc.addText(indi.getLastName(), "font-weight=bold, color=blue");
                                doc.addText(" " + indi.getFirstName());
                                doc.addText(" (" + indi.getBirthAsString() + " - " + indi.getDeathAsString() + ")");
                            } else {
                                doc.nextTableCell("width=4%");
                                doc.nextTableCell("width=30%");
                            }
                            if (index < familiesWhereSpouse.length) {
                                doc.nextTableCell("width=4%");
                                doc.addLink(familiesWhereSpouse[index].getId(), familiesWhereSpouse[index].getAnchor());
                                doc.nextTableCell("width=29%");
                                doc.addText(familiesWhereSpouse[index].getHusband() + " - " + familiesWhereSpouse[index].getWife());
                            } else {
                                doc.nextTableCell("width=4%");
                                doc.nextTableCell("width=29%");
                            }
                            if (index < familiesWhereChild.length) {
                                doc.nextTableCell("width=4%");
                                doc.addLink(familiesWhereChild[index].getId(), familiesWhereChild[index].getAnchor());
                                doc.nextTableCell("width=29%");
                                doc.addText(familiesWhereChild[index].getHusband() + " - " + familiesWhereChild[index].getWife());
                                continue;
                            }
                            doc.nextTableCell("width=4%");
                            doc.nextTableCell("width=29%");
                        }
                    }
                }
                FamilyGroupFilter filter = new FamilyGroupFilter(tree);
                AncestrisPlugin.register((Object)filter);
                this.filters.add(filter);
            }
            doc.endTable();
            doc.nextParagraph(" ");
            doc.addText("   ");
            doc.nextParagraph("font-size=1.1em,font-weight=bold,line-height=200%");
            doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FamilyGroupsTopComponent.grandtotal", (Object)grandtotal));
            if (loners > 0) {
                doc.nextParagraph("font-size=1.1em,font-weight=bold,line-height=200%");
                doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FamilyGroupsTopComponent.loners", (Object)loners, (Object)this.getMinGroupSize()));
            }
            doc.nextParagraph(" ");
            doc.addText("   ");
            doc.nextParagraph("font-size=1em,line-height=200%");
            doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FamilyGroupsTopComponent.saveas"));
        }
        return doc;
    }

    private void iterate(Indi indi, Tree tree, Set<Indi> unvisited) {
        Stack<Indi> todos = new Stack<Indi>();
        if (unvisited.remove(indi)) {
            todos.add(indi);
        }
        while (!todos.isEmpty()) {
            Indi todo = (Indi)todos.pop();
            tree.add(todo);
            Fam famc = todo.getFamilyWhereBiologicalChild();
            if (famc != null) {
                Indi father;
                Indi mother = famc.getWife();
                if (mother != null && unvisited.remove(mother)) {
                    todos.push(mother);
                }
                if ((father = famc.getHusband()) != null && unvisited.remove(father)) {
                    todos.push(father);
                }
            }
            Fam[] fams = todo.getFamiliesWhereSpouse();
            for (int f = 0; f < fams.length; ++f) {
                Fam fam = fams[f];
                Indi spouse = fam.getOtherSpouse(todo);
                if (spouse != null && unvisited.remove(spouse)) {
                    todos.push(spouse);
                }
                Indi[] children = fam.getChildren();
                for (int c = 0; c < children.length; ++c) {
                    if (!unvisited.remove(children[c])) continue;
                    todos.push(children[c]);
                }
            }
        }
    }

    public int getMinGroupSize() {
        return this.minGroupSize;
    }

    public void setMinGroupSize(int minGroupSize) {
        this.minGroupSize = minGroupSize;
    }

    public int getMaxGroupSize() {
        return this.maxGroupSize;
    }

    public void setMaxGroupSize(int maxGroupSize) {
        this.maxGroupSize = maxGroupSize;
    }

    public void stop() {
        if (this.filters != null) {
            for (FamilyGroupFilter filter : this.filters) {
                filter.setTree(null);
                AncestrisPlugin.unregister((Object)filter);
            }
        }
        this.filters = null;
    }

    private static class FamilyGroupFilter
    implements Filter {
        private Tree tree;
        private int SIZEMAX = 90;

        public FamilyGroupFilter(Tree tree) {
            this.tree = tree;
        }

        public void setTree(Tree tree) {
            this.tree = tree;
        }

        public String getFilterName() {
            String text = NbBundle.getMessage(FamilyGroupFilter.class, (String)"TTL_Filter", (Object)this.tree.size(), (Object)this.tree.getNb(), (Object)this.tree.getOldestIndividual());
            if (text.length() > this.SIZEMAX) {
                int index = text.substring(0, this.SIZEMAX).lastIndexOf(" ");
                text = text.substring(0, index) + "...";
            }
            return text;
        }

        public boolean veto(Entity entity) {
            if (this.tree.connectedEntities.isEmpty()) {
                for (Entity hit : this.tree.entities) {
                    this.tree.connectedEntities.addAll(Utilities.getDependingEntitiesRecursively((Entity)hit));
                }
            }
            return !this.tree.connectedEntities.contains(entity);
        }

        public boolean veto(Property property) {
            PropertyXRef xref;
            return property instanceof PropertyXRef && (xref = (PropertyXRef)property).isValid() && !this.tree.connectedEntities.contains(xref.getTargetEntity());
        }

        public boolean canApplyTo(Gedcom gedcom) {
            if (this.tree == null) {
                return false;
            }
            return this.tree.oldestIndividual.getGedcom().equals(gedcom);
        }
    }

    private class Tree
    extends HashSet<Indi>
    implements Comparable<Tree> {
        private int number;
        private Indi oldestIndividual;
        private Indi youngestIndividual;
        private HashSet<Entity> entities = new HashSet();
        public HashSet<Entity> connectedEntities = new HashSet();

        private Tree() {
        }

        @Override
        public int compareTo(Tree that) {
            return that.size() - this.size();
        }

        public void setNb(int i) {
            this.number = i;
        }

        public int getNb() {
            return this.number;
        }

        public Indi getOldestIndividual() {
            return this.oldestIndividual;
        }

        public Indi getYoungestIndividual() {
            return this.youngestIndividual;
        }

        public HashSet<PropertyPlace> getPlaces() {
            HashSet<PropertyPlace> propertyPlaces = new HashSet<PropertyPlace>();
            for (Indi indi : this) {
                List findProperties = indi.findProperties(Pattern.compile("PLAC"), null);
                Iterator indiPlacesIt = findProperties.iterator();
                while (indiPlacesIt.hasNext()) {
                    boolean found = false;
                    Property findProperty = (Property)indiPlacesIt.next();
                    for (PropertyPlace propertyPlace : propertyPlaces) {
                        if (propertyPlace.compareTo(findProperty) != 0) continue;
                        found = true;
                    }
                    if (found) continue;
                    propertyPlaces.add((PropertyPlace)findProperty);
                }
            }
            return propertyPlaces;
        }

        @Override
        public String toString() {
            return this.oldestIndividual.getId() + " " + this.getTitle();
        }

        public String getTitle() {
            return NbBundle.getMessage(this.getClass(), (String)"FamilyGroupsTopComponent.treeTitle", (Object[])new Object[]{this.oldestIndividual.getName(), this.oldestIndividual.getBirthAsString().length() > 0 ? this.oldestIndividual.getBirthAsString() : "-", this.oldestIndividual.getDeathAsString().length() > 0 ? this.oldestIndividual.getDeathAsString() : "-", this.youngestIndividual.getName(), this.youngestIndividual.getBirthAsString().length() > 0 ? this.youngestIndividual.getBirthAsString() : "-", this.youngestIndividual.getDeathAsString().length() > 0 ? this.youngestIndividual.getDeathAsString() : "-"});
        }

        @Override
        public boolean add(Indi indi) {
            if (this.isOldest(indi)) {
                this.oldestIndividual = indi;
            }
            if (this.isYoungest(indi)) {
                this.youngestIndividual = indi;
            }
            this.addEntity((Entity)indi);
            return super.add(indi);
        }

        public void addEntity(Entity entity) {
            this.entities.add(entity);
        }

        public boolean hasEntity(Entity e) {
            return this.entities.contains(e);
        }

        private boolean isOldest(Indi indi) {
            long jd;
            try {
                jd = this.oldestIndividual.getBirthDate().getStart().getJulianDay();
            }
            catch (Throwable t) {
                return true;
            }
            try {
                return (long)indi.getBirthDate().getStart().getJulianDay() < jd;
            }
            catch (Throwable t) {
                return false;
            }
        }

        private boolean isYoungest(Indi indi) {
            long jd;
            try {
                jd = this.youngestIndividual.getBirthDate().getStart().getJulianDay();
            }
            catch (Throwable t) {
                return true;
            }
            try {
                return (long)indi.getBirthDate().getStart().getJulianDay() > jd;
            }
            catch (Throwable t) {
                return false;
            }
        }
    }
}

