/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.autoupdate.ui.wizards.CustomHandleStep;
import org.netbeans.modules.autoupdate.ui.wizards.InstallStep;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.LicenseApprovalStep;
import org.netbeans.modules.autoupdate.ui.wizards.OperationDescriptionStep;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public final class InstallUnitWizardIterator
implements WizardDescriptor.Iterator<WizardDescriptor> {
    private int index;
    private final List<WizardDescriptor.Panel<WizardDescriptor>> panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
    private InstallUnitWizardModel installModel;
    private WizardDescriptor.Panel<WizardDescriptor> licenseApprovalStep = null;
    private WizardDescriptor.Panel<WizardDescriptor> customHandleStep = null;
    private WizardDescriptor.Panel<WizardDescriptor> installStep = null;
    private boolean isCompact = false;
    private boolean clearLazyUnits = false;
    private final boolean allowRunInBackground;
    private final boolean runInBackground;

    public InstallUnitWizardIterator(InstallUnitWizardModel model) {
        this(model, false);
    }

    public InstallUnitWizardIterator(InstallUnitWizardModel model, boolean clearLazyUnits) {
        this(model, clearLazyUnits, true, true);
    }

    public InstallUnitWizardIterator(InstallUnitWizardModel model, boolean clearLazyUnits, boolean allowRunInBackground) {
        this(model, clearLazyUnits, allowRunInBackground, false);
    }

    public InstallUnitWizardIterator(InstallUnitWizardModel model, boolean clearLazyUnits, boolean allowRunInBackground, boolean runInBackground) {
        this.installModel = model;
        this.clearLazyUnits = clearLazyUnits;
        this.allowRunInBackground = allowRunInBackground;
        this.runInBackground = runInBackground;
        this.createPanels();
        this.index = 0;
    }

    public InstallUnitWizardModel getModel() {
        assert (this.installModel != null);
        return this.installModel;
    }

    private void createPanels() {
        assert (this.panels != null && this.panels.isEmpty()) : "Panels are still empty";
        this.panels.add(new OperationDescriptionStep(this.installModel));
        this.licenseApprovalStep = new LicenseApprovalStep(this.installModel);
        this.panels.add(this.licenseApprovalStep);
        this.customHandleStep = new CustomHandleStep(this.installModel);
        this.panels.add(this.customHandleStep);
        this.installStep = new InstallStep(this.installModel, this.clearLazyUnits, this.allowRunInBackground, this.runInBackground);
        this.panels.add(this.installStep);
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        assert (this.panels != null);
        return this.panels.get(this.index);
    }

    public String name() {
        return NbBundle.getMessage(InstallUnitWizardIterator.class, (String)"InstallUnitWizard_Title");
    }

    public boolean hasNext() {
        this.compactPanels();
        return this.index < this.panels.size() - 1;
    }

    public boolean hasPrevious() {
        this.compactPanels();
        return this.index > 0 && !(this.current() instanceof InstallStep) && !(this.current() instanceof CustomHandleStep);
    }

    public void nextPanel() {
        this.compactPanels();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        this.compactPanels();
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private void compactPanels() {
        if (this.isCompact) {
            return;
        }
        boolean allLicensesTouched = this.getModel().allLicensesTouched();
        if (allLicensesTouched && this.getModel().allLicensesApproved()) {
            this.panels.remove(this.licenseApprovalStep);
        }
        if (!this.getModel().hasCustomComponents()) {
            this.panels.remove(this.customHandleStep);
        }
        if (!this.getModel().hasStandardComponents()) {
            this.panels.remove(this.installStep);
        }
        this.isCompact = allLicensesTouched;
    }
}

