/* Automatically generated nanopb header */
/* Generated by nanopb-0.4.4 */

#ifndef PB_MSG_PB_H_INCLUDED
#define PB_MSG_PB_H_INCLUDED
#include <pb.h>

#if PB_PROTO_HEADER_VERSION != 40
#error Regenerate this file with the current version of nanopb generator.
#endif

/* Struct definitions */
typedef struct _NActorDie {
    int32_t UID;
} NActorDie;

typedef struct _NActorDir {
    uint32_t UID;
    int32_t Dir;
} NActorDir;

typedef struct _NActorHeal {
    uint32_t UID;
    int32_t PlayerUID;
    int32_t Amount;
    bool IsRandomSpawned;
} NActorHeal;

typedef struct _NActorMelee {
    uint32_t UID;
    char BulletClass[128];
    int32_t HitType;
    int32_t TargetKind;
    uint32_t TargetUID;
} NActorMelee;

typedef struct _NActorPickupAll {
    uint32_t UID;
    bool PickupAll;
} NActorPickupAll;

typedef struct _NActorPilot {
    uint32_t UID;
    int32_t VehicleUID;
    bool On;
} NActorPilot;

typedef struct _NActorReplaceGun {
    uint32_t UID;
    uint32_t GunIdx;
    char Gun[128];
} NActorReplaceGun;

typedef struct _NActorState {
    uint32_t UID;
    int32_t State;
} NActorState;

typedef struct _NActorSwitchGun {
    uint32_t UID;
    uint32_t GunIdx;
} NActorSwitchGun;

typedef struct _NAmmo {
    uint32_t Id;
    uint32_t Amount;
} NAmmo;

typedef struct _NCampaignDef {
    char Path[4096];
    int32_t GameMode;
    uint32_t Mission;
} NCampaignDef;

typedef struct _NClientId {
    uint32_t Id;
    uint32_t FirstPlayerUID;
} NClientId;

typedef struct _NColor {
    int32_t RGBA;
} NColor;

typedef struct _NConfig {
    char Name[128];
    char Value[128];
} NConfig;

typedef struct _NGameBegin {
    int32_t MissionTime;
} NGameBegin;

typedef struct _NGunState {
    uint32_t ActorUID;
    int32_t Barrel;
    int32_t State;
} NGunState;

typedef struct _NMapObjectRemove {
    uint32_t UID;
    int32_t ActorUID;
    uint32_t Flags;
} NMapObjectRemove;

typedef struct _NMissionComplete {
    bool ShowMsg;
} NMissionComplete;

typedef struct _NMissionEnd {
    int32_t Delay;
    bool IsQuit;
    char Msg[128];
    uint32_t Mission;
} NMissionEnd;

typedef struct _NObjectiveUpdate {
    uint32_t ObjectiveId;
    int32_t Count;
} NObjectiveUpdate;

typedef struct _NPlayerAddLives {
    int32_t UID;
    uint32_t Lives;
} NPlayerAddLives;

typedef struct _NPlayerRemove {
    uint32_t UID;
} NPlayerRemove;

typedef struct _NPlayerStats {
    uint32_t Score;
    uint32_t Kills;
    uint32_t Suicides;
    uint32_t Friendlies;
    uint32_t TimeTicks;
} NPlayerStats;

typedef struct _NRemoveBullet {
    uint32_t UID;
} NRemoveBullet;

typedef struct _NRemovePickup {
    uint32_t UID;
    int32_t SpawnerUID;
} NRemovePickup;

typedef struct _NRescueCharacter {
    uint32_t UID;
} NRescueCharacter;

typedef struct _NScore {
    uint32_t PlayerUID;
    int32_t Score;
} NScore;

typedef struct _NServerInfo {
    int32_t ProtocolVersion;
    uint32_t ENetPort;
    char Hostname[12];
    int32_t GameMode;
    char CampaignName[20];
    int32_t MissionNumber;
    int32_t NumPlayers;
    int32_t MaxPlayers;
} NServerInfo;

typedef struct _NVec2 {
    float x;
    float y;
} NVec2;

typedef struct _NVec2i {
    int32_t x;
    int32_t y;
} NVec2i;

typedef struct _NActorAdd {
    uint32_t UID;
    int32_t PilotUID;
    int32_t VehicleUID;
    uint32_t CharId;
    int32_t Direction;
    int32_t Health;
    int32_t PlayerUID;
    uint32_t ThingFlags;
    bool has_Pos;
    NVec2 Pos;
    pb_size_t Ammo_count;
    NAmmo Ammo[128];
} NActorAdd;

typedef struct _NActorAddAmmo {
    uint32_t UID;
    int32_t PlayerUID;
    bool has_Ammo;
    NAmmo Ammo;
    bool IsRandomSpawned;
} NActorAddAmmo;

typedef struct _NActorImpulse {
    uint32_t UID;
    bool has_Vel;
    NVec2 Vel;
    bool has_Pos;
    NVec2 Pos;
} NActorImpulse;

typedef struct _NActorMove {
    uint32_t UID;
    bool has_Pos;
    NVec2 Pos;
    bool has_MoveVel;
    NVec2 MoveVel;
} NActorMove;

typedef struct _NActorSlide {
    uint32_t UID;
    bool has_Vel;
    NVec2 Vel;
} NActorSlide;

typedef struct _NActorUseAmmo {
    uint32_t UID;
    int32_t PlayerUID;
    bool has_Ammo;
    NAmmo Ammo;
} NActorUseAmmo;

typedef struct _NAddBullet {
    uint32_t UID;
    char BulletClass[128];
    bool has_MuzzlePos;
    NVec2 MuzzlePos;
    int32_t MuzzleHeight;
    float Angle;
    int32_t Elevation;
    uint32_t Flags;
    int32_t ActorUID;
} NAddBullet;

typedef struct _NAddKeys {
    uint32_t KeyFlags;
    bool has_Pos;
    NVec2 Pos;
} NAddKeys;

typedef struct _NAddPickup {
    uint32_t UID;
    char PickupClass[128];
    bool IsRandomSpawned;
    int32_t SpawnerUID;
    uint32_t ThingFlags;
    bool has_Pos;
    NVec2 Pos;
} NAddPickup;

typedef struct _NBulletBounce {
    uint32_t UID;
    int32_t HitType;
    bool Spark;
    bool has_BouncePos;
    NVec2 BouncePos;
    bool has_Pos;
    NVec2 Pos;
    bool has_Vel;
    NVec2 Vel;
    bool HitSound;
    bool WallMark;
} NBulletBounce;

typedef struct _NCharColors {
    bool has_Skin;
    NColor Skin;
    bool has_Arms;
    NColor Arms;
    bool has_Body;
    NColor Body;
    bool has_Legs;
    NColor Legs;
    bool has_Hair;
    NColor Hair;
    bool has_Feet;
    NColor Feet;
} NCharColors;

typedef struct _NDoorToggle {
    bool IsOpen;
    bool has_Pos;
    NVec2i Pos;
} NDoorToggle;

typedef struct _NExploreTiles_Run {
    bool has_Tile;
    NVec2i Tile;
    int32_t Run;
} NExploreTiles_Run;

typedef struct _NGunFire {
    int32_t ActorUID;
    char Gun[128];
    bool has_MuzzlePos;
    NVec2 MuzzlePos;
    int32_t Z;
    float Angle;
    bool Sound;
    uint32_t Flags;
    bool IsGun;
} NGunFire;

typedef struct _NGunReload {
    int32_t PlayerUID;
    char Gun[128];
    bool has_Pos;
    NVec2 Pos;
    int32_t Direction;
} NGunReload;

typedef struct _NMapObjectAdd {
    uint32_t UID;
    char MapObjectClass[128];
    bool has_Pos;
    NVec2 Pos;
    uint32_t ThingFlags;
    int32_t Health;
    bool has_Mask;
    NColor Mask;
} NMapObjectAdd;

typedef struct _NSound {
    char Sound[128];
    bool has_Pos;
    NVec2 Pos;
    uint32_t Distance;
} NSound;

typedef struct _NThingDamage {
    uint32_t UID;
    int32_t Kind;
    int32_t SourceActorUID;
    int32_t Power;
    bool has_Vel;
    NVec2 Vel;
    float Mass;
    uint32_t Flags;
    int32_t Special;
    int32_t SpecialTicks;
} NThingDamage;

typedef struct _NTileSet {
    bool has_Pos;
    NVec2i Pos;
    char ClassName[128];
    char DoorClassName[128];
    char DoorClass2Name[128];
    int32_t RunLength;
} NTileSet;

typedef struct _NTrigger {
    uint32_t ID;
    bool has_Tile;
    NVec2i Tile;
} NTrigger;

typedef struct _NExploreTiles {
    pb_size_t Runs_count;
    NExploreTiles_Run Runs[16];
} NExploreTiles;

typedef struct _NPlayerData {
    char Name[20];
    char CharacterClass[128];
    char Hair[128];
    bool has_Colors;
    NCharColors Colors;
    pb_size_t Weapons_count;
    char Weapons[3][128];
    uint32_t Lives;
    bool has_Stats;
    NPlayerStats Stats;
    bool has_Totals;
    NPlayerStats Totals;
    uint32_t MaxHealth;
    uint32_t LastMission;
    uint32_t UID;
    pb_size_t Ammo_count;
    NAmmo Ammo[128];
} NPlayerData;


#ifdef __cplusplus
extern "C" {
#endif

/* Initializer values for message structs */
#define NServerInfo_init_default                 {0, 0, "", 0, "", 0, 0, 0}
#define NClientId_init_default                   {0, 0}
#define NCampaignDef_init_default                {"", 0, 0}
#define NColor_init_default                      {0}
#define NCharColors_init_default                 {false, NColor_init_default, false, NColor_init_default, false, NColor_init_default, false, NColor_init_default, false, NColor_init_default, false, NColor_init_default}
#define NPlayerStats_init_default                {0, 0, 0, 0, 0}
#define NPlayerData_init_default                 {"", "", "", false, NCharColors_init_default, 0, {"", "", ""}, 0, false, NPlayerStats_init_default, false, NPlayerStats_init_default, 0, 0, 0, 0, {NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default}}
#define NPlayerRemove_init_default               {0}
#define NConfig_init_default                     {"", ""}
#define NTileSet_init_default                    {false, NVec2i_init_default, "", "", "", 0}
#define NThingDamage_init_default                {0, 0, 0, 0, false, NVec2_init_default, 0, 0, 0, 0}
#define NMapObjectAdd_init_default               {0, "", false, NVec2_init_default, 0, 0, false, NColor_init_default}
#define NMapObjectRemove_init_default            {0, 0, 0}
#define NScore_init_default                      {0, 0}
#define NSound_init_default                      {"", false, NVec2_init_default, 0}
#define NVec2i_init_default                      {0, 0}
#define NVec2_init_default                       {0, 0}
#define NGameBegin_init_default                  {0}
#define NActorAdd_init_default                   {0, 0, 0, 0, 0, 0, 0, 0, false, NVec2_init_default, 0, {NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default, NAmmo_init_default}}
#define NActorMove_init_default                  {0, false, NVec2_init_default, false, NVec2_init_default}
#define NActorState_init_default                 {0, 0}
#define NActorDir_init_default                   {0, 0}
#define NActorSlide_init_default                 {0, false, NVec2_init_default}
#define NActorImpulse_init_default               {0, false, NVec2_init_default, false, NVec2_init_default}
#define NActorSwitchGun_init_default             {0, 0}
#define NActorPickupAll_init_default             {0, 0}
#define NActorReplaceGun_init_default            {0, 0, ""}
#define NActorHeal_init_default                  {0, 0, 0, 0}
#define NAmmo_init_default                       {0, 0}
#define NActorAddAmmo_init_default               {0, 0, false, NAmmo_init_default, 0}
#define NActorUseAmmo_init_default               {0, 0, false, NAmmo_init_default}
#define NActorDie_init_default                   {0}
#define NPlayerAddLives_init_default             {0, 0}
#define NActorMelee_init_default                 {0, "", 0, 0, 0}
#define NActorPilot_init_default                 {0, 0, 0}
#define NAddPickup_init_default                  {0, "", 0, 0, 0, false, NVec2_init_default}
#define NRemovePickup_init_default               {0, 0}
#define NBulletBounce_init_default               {0, 0, 0, false, NVec2_init_default, false, NVec2_init_default, false, NVec2_init_default, 0, 0}
#define NRemoveBullet_init_default               {0}
#define NGunReload_init_default                  {0, "", false, NVec2_init_default, 0}
#define NGunFire_init_default                    {0, "", false, NVec2_init_default, 0, 0, 0, 0, 0}
#define NGunState_init_default                   {0, 0, 0}
#define NAddBullet_init_default                  {0, "", false, NVec2_init_default, 0, 0, 0, 0, 0}
#define NTrigger_init_default                    {0, false, NVec2i_init_default}
#define NExploreTiles_init_default               {0, {NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default, NExploreTiles_Run_init_default}}
#define NExploreTiles_Run_init_default           {false, NVec2i_init_default, 0}
#define NRescueCharacter_init_default            {0}
#define NObjectiveUpdate_init_default            {0, 0}
#define NAddKeys_init_default                    {0, false, NVec2_init_default}
#define NDoorToggle_init_default                 {0, false, NVec2i_init_default}
#define NMissionComplete_init_default            {0}
#define NMissionEnd_init_default                 {0, 0, "", 0}
#define NServerInfo_init_zero                    {0, 0, "", 0, "", 0, 0, 0}
#define NClientId_init_zero                      {0, 0}
#define NCampaignDef_init_zero                   {"", 0, 0}
#define NColor_init_zero                         {0}
#define NCharColors_init_zero                    {false, NColor_init_zero, false, NColor_init_zero, false, NColor_init_zero, false, NColor_init_zero, false, NColor_init_zero, false, NColor_init_zero}
#define NPlayerStats_init_zero                   {0, 0, 0, 0, 0}
#define NPlayerData_init_zero                    {"", "", "", false, NCharColors_init_zero, 0, {"", "", ""}, 0, false, NPlayerStats_init_zero, false, NPlayerStats_init_zero, 0, 0, 0, 0, {NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero}}
#define NPlayerRemove_init_zero                  {0}
#define NConfig_init_zero                        {"", ""}
#define NTileSet_init_zero                       {false, NVec2i_init_zero, "", "", "", 0}
#define NThingDamage_init_zero                   {0, 0, 0, 0, false, NVec2_init_zero, 0, 0, 0, 0}
#define NMapObjectAdd_init_zero                  {0, "", false, NVec2_init_zero, 0, 0, false, NColor_init_zero}
#define NMapObjectRemove_init_zero               {0, 0, 0}
#define NScore_init_zero                         {0, 0}
#define NSound_init_zero                         {"", false, NVec2_init_zero, 0}
#define NVec2i_init_zero                         {0, 0}
#define NVec2_init_zero                          {0, 0}
#define NGameBegin_init_zero                     {0}
#define NActorAdd_init_zero                      {0, 0, 0, 0, 0, 0, 0, 0, false, NVec2_init_zero, 0, {NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero, NAmmo_init_zero}}
#define NActorMove_init_zero                     {0, false, NVec2_init_zero, false, NVec2_init_zero}
#define NActorState_init_zero                    {0, 0}
#define NActorDir_init_zero                      {0, 0}
#define NActorSlide_init_zero                    {0, false, NVec2_init_zero}
#define NActorImpulse_init_zero                  {0, false, NVec2_init_zero, false, NVec2_init_zero}
#define NActorSwitchGun_init_zero                {0, 0}
#define NActorPickupAll_init_zero                {0, 0}
#define NActorReplaceGun_init_zero               {0, 0, ""}
#define NActorHeal_init_zero                     {0, 0, 0, 0}
#define NAmmo_init_zero                          {0, 0}
#define NActorAddAmmo_init_zero                  {0, 0, false, NAmmo_init_zero, 0}
#define NActorUseAmmo_init_zero                  {0, 0, false, NAmmo_init_zero}
#define NActorDie_init_zero                      {0}
#define NPlayerAddLives_init_zero                {0, 0}
#define NActorMelee_init_zero                    {0, "", 0, 0, 0}
#define NActorPilot_init_zero                    {0, 0, 0}
#define NAddPickup_init_zero                     {0, "", 0, 0, 0, false, NVec2_init_zero}
#define NRemovePickup_init_zero                  {0, 0}
#define NBulletBounce_init_zero                  {0, 0, 0, false, NVec2_init_zero, false, NVec2_init_zero, false, NVec2_init_zero, 0, 0}
#define NRemoveBullet_init_zero                  {0}
#define NGunReload_init_zero                     {0, "", false, NVec2_init_zero, 0}
#define NGunFire_init_zero                       {0, "", false, NVec2_init_zero, 0, 0, 0, 0, 0}
#define NGunState_init_zero                      {0, 0, 0}
#define NAddBullet_init_zero                     {0, "", false, NVec2_init_zero, 0, 0, 0, 0, 0}
#define NTrigger_init_zero                       {0, false, NVec2i_init_zero}
#define NExploreTiles_init_zero                  {0, {NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero, NExploreTiles_Run_init_zero}}
#define NExploreTiles_Run_init_zero              {false, NVec2i_init_zero, 0}
#define NRescueCharacter_init_zero               {0}
#define NObjectiveUpdate_init_zero               {0, 0}
#define NAddKeys_init_zero                       {0, false, NVec2_init_zero}
#define NDoorToggle_init_zero                    {0, false, NVec2i_init_zero}
#define NMissionComplete_init_zero               {0}
#define NMissionEnd_init_zero                    {0, 0, "", 0}

/* Field tags (for use in manual encoding/decoding) */
#define NActorDie_UID_tag                        1
#define NActorDir_UID_tag                        1
#define NActorDir_Dir_tag                        2
#define NActorHeal_UID_tag                       1
#define NActorHeal_PlayerUID_tag                 2
#define NActorHeal_Amount_tag                    3
#define NActorHeal_IsRandomSpawned_tag           4
#define NActorMelee_UID_tag                      1
#define NActorMelee_BulletClass_tag              2
#define NActorMelee_HitType_tag                  3
#define NActorMelee_TargetKind_tag               4
#define NActorMelee_TargetUID_tag                5
#define NActorPickupAll_UID_tag                  1
#define NActorPickupAll_PickupAll_tag            2
#define NActorPilot_UID_tag                      1
#define NActorPilot_VehicleUID_tag               2
#define NActorPilot_On_tag                       3
#define NActorReplaceGun_UID_tag                 1
#define NActorReplaceGun_GunIdx_tag              2
#define NActorReplaceGun_Gun_tag                 3
#define NActorState_UID_tag                      1
#define NActorState_State_tag                    2
#define NActorSwitchGun_UID_tag                  1
#define NActorSwitchGun_GunIdx_tag               2
#define NAmmo_Id_tag                             1
#define NAmmo_Amount_tag                         2
#define NCampaignDef_Path_tag                    1
#define NCampaignDef_GameMode_tag                2
#define NCampaignDef_Mission_tag                 3
#define NClientId_Id_tag                         1
#define NClientId_FirstPlayerUID_tag             2
#define NColor_RGBA_tag                          1
#define NConfig_Name_tag                         1
#define NConfig_Value_tag                        2
#define NGameBegin_MissionTime_tag               1
#define NGunState_ActorUID_tag                   1
#define NGunState_Barrel_tag                     2
#define NGunState_State_tag                      3
#define NMapObjectRemove_UID_tag                 1
#define NMapObjectRemove_ActorUID_tag            2
#define NMapObjectRemove_Flags_tag               3
#define NMissionComplete_ShowMsg_tag             1
#define NMissionEnd_Delay_tag                    1
#define NMissionEnd_IsQuit_tag                   2
#define NMissionEnd_Msg_tag                      3
#define NMissionEnd_Mission_tag                  4
#define NObjectiveUpdate_ObjectiveId_tag         1
#define NObjectiveUpdate_Count_tag               2
#define NPlayerAddLives_UID_tag                  1
#define NPlayerAddLives_Lives_tag                2
#define NPlayerRemove_UID_tag                    1
#define NPlayerStats_Score_tag                   1
#define NPlayerStats_Kills_tag                   2
#define NPlayerStats_Suicides_tag                3
#define NPlayerStats_Friendlies_tag              4
#define NPlayerStats_TimeTicks_tag               5
#define NRemoveBullet_UID_tag                    1
#define NRemovePickup_UID_tag                    1
#define NRemovePickup_SpawnerUID_tag             2
#define NRescueCharacter_UID_tag                 1
#define NScore_PlayerUID_tag                     1
#define NScore_Score_tag                         2
#define NServerInfo_ProtocolVersion_tag          1
#define NServerInfo_ENetPort_tag                 2
#define NServerInfo_Hostname_tag                 3
#define NServerInfo_GameMode_tag                 4
#define NServerInfo_CampaignName_tag             5
#define NServerInfo_MissionNumber_tag            6
#define NServerInfo_NumPlayers_tag               7
#define NServerInfo_MaxPlayers_tag               8
#define NVec2_x_tag                              1
#define NVec2_y_tag                              2
#define NVec2i_x_tag                             1
#define NVec2i_y_tag                             2
#define NActorAdd_UID_tag                        1
#define NActorAdd_PilotUID_tag                   2
#define NActorAdd_VehicleUID_tag                 3
#define NActorAdd_CharId_tag                     4
#define NActorAdd_Direction_tag                  5
#define NActorAdd_Health_tag                     6
#define NActorAdd_PlayerUID_tag                  7
#define NActorAdd_ThingFlags_tag                 8
#define NActorAdd_Pos_tag                        9
#define NActorAdd_Ammo_tag                       10
#define NActorAddAmmo_UID_tag                    1
#define NActorAddAmmo_PlayerUID_tag              2
#define NActorAddAmmo_Ammo_tag                   3
#define NActorAddAmmo_IsRandomSpawned_tag        4
#define NActorImpulse_UID_tag                    1
#define NActorImpulse_Vel_tag                    2
#define NActorImpulse_Pos_tag                    3
#define NActorMove_UID_tag                       1
#define NActorMove_Pos_tag                       2
#define NActorMove_MoveVel_tag                   3
#define NActorSlide_UID_tag                      1
#define NActorSlide_Vel_tag                      2
#define NActorUseAmmo_UID_tag                    1
#define NActorUseAmmo_PlayerUID_tag              2
#define NActorUseAmmo_Ammo_tag                   3
#define NAddBullet_UID_tag                       1
#define NAddBullet_BulletClass_tag               2
#define NAddBullet_MuzzlePos_tag                 3
#define NAddBullet_MuzzleHeight_tag              4
#define NAddBullet_Angle_tag                     5
#define NAddBullet_Elevation_tag                 6
#define NAddBullet_Flags_tag                     7
#define NAddBullet_ActorUID_tag                  8
#define NAddKeys_KeyFlags_tag                    1
#define NAddKeys_Pos_tag                         2
#define NAddPickup_UID_tag                       1
#define NAddPickup_PickupClass_tag               2
#define NAddPickup_IsRandomSpawned_tag           3
#define NAddPickup_SpawnerUID_tag                4
#define NAddPickup_ThingFlags_tag                5
#define NAddPickup_Pos_tag                       6
#define NBulletBounce_UID_tag                    1
#define NBulletBounce_HitType_tag                2
#define NBulletBounce_Spark_tag                  3
#define NBulletBounce_BouncePos_tag              4
#define NBulletBounce_Pos_tag                    5
#define NBulletBounce_Vel_tag                    6
#define NBulletBounce_HitSound_tag               7
#define NBulletBounce_WallMark_tag               8
#define NCharColors_Skin_tag                     1
#define NCharColors_Arms_tag                     2
#define NCharColors_Body_tag                     3
#define NCharColors_Legs_tag                     4
#define NCharColors_Hair_tag                     5
#define NCharColors_Feet_tag                     6
#define NDoorToggle_IsOpen_tag                   1
#define NDoorToggle_Pos_tag                      2
#define NExploreTiles_Run_Tile_tag               1
#define NExploreTiles_Run_Run_tag                2
#define NGunFire_ActorUID_tag                    1
#define NGunFire_Gun_tag                         2
#define NGunFire_MuzzlePos_tag                   3
#define NGunFire_Z_tag                           4
#define NGunFire_Angle_tag                       5
#define NGunFire_Sound_tag                       6
#define NGunFire_Flags_tag                       7
#define NGunFire_IsGun_tag                       8
#define NGunReload_PlayerUID_tag                 1
#define NGunReload_Gun_tag                       2
#define NGunReload_Pos_tag                       3
#define NGunReload_Direction_tag                 4
#define NMapObjectAdd_UID_tag                    1
#define NMapObjectAdd_MapObjectClass_tag         2
#define NMapObjectAdd_Pos_tag                    3
#define NMapObjectAdd_ThingFlags_tag             4
#define NMapObjectAdd_Health_tag                 5
#define NMapObjectAdd_Mask_tag                   6
#define NSound_Sound_tag                         1
#define NSound_Pos_tag                           2
#define NSound_Distance_tag                      3
#define NThingDamage_UID_tag                     1
#define NThingDamage_Kind_tag                    2
#define NThingDamage_SourceActorUID_tag          3
#define NThingDamage_Power_tag                   4
#define NThingDamage_Vel_tag                     5
#define NThingDamage_Mass_tag                    6
#define NThingDamage_Flags_tag                   7
#define NThingDamage_Special_tag                 8
#define NThingDamage_SpecialTicks_tag            9
#define NTileSet_Pos_tag                         1
#define NTileSet_ClassName_tag                   2
#define NTileSet_DoorClassName_tag               3
#define NTileSet_DoorClass2Name_tag              4
#define NTileSet_RunLength_tag                   5
#define NTrigger_ID_tag                          1
#define NTrigger_Tile_tag                        2
#define NExploreTiles_Runs_tag                   1
#define NPlayerData_Name_tag                     1
#define NPlayerData_CharacterClass_tag           2
#define NPlayerData_Hair_tag                     3
#define NPlayerData_Colors_tag                   4
#define NPlayerData_Weapons_tag                  5
#define NPlayerData_Lives_tag                    6
#define NPlayerData_Stats_tag                    7
#define NPlayerData_Totals_tag                   8
#define NPlayerData_MaxHealth_tag                9
#define NPlayerData_LastMission_tag              10
#define NPlayerData_UID_tag                      11
#define NPlayerData_Ammo_tag                     12

/* Struct field encoding specification for nanopb */
#define NServerInfo_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, INT32,    ProtocolVersion,   1) \
X(a, STATIC,   SINGULAR, UINT32,   ENetPort,          2) \
X(a, STATIC,   SINGULAR, STRING,   Hostname,          3) \
X(a, STATIC,   SINGULAR, INT32,    GameMode,          4) \
X(a, STATIC,   SINGULAR, STRING,   CampaignName,      5) \
X(a, STATIC,   SINGULAR, INT32,    MissionNumber,     6) \
X(a, STATIC,   SINGULAR, INT32,    NumPlayers,        7) \
X(a, STATIC,   SINGULAR, INT32,    MaxPlayers,        8)
#define NServerInfo_CALLBACK NULL
#define NServerInfo_DEFAULT NULL

#define NClientId_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   Id,                1) \
X(a, STATIC,   SINGULAR, UINT32,   FirstPlayerUID,    2)
#define NClientId_CALLBACK NULL
#define NClientId_DEFAULT NULL

#define NCampaignDef_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, STRING,   Path,              1) \
X(a, STATIC,   SINGULAR, INT32,    GameMode,          2) \
X(a, STATIC,   SINGULAR, UINT32,   Mission,           3)
#define NCampaignDef_CALLBACK NULL
#define NCampaignDef_DEFAULT NULL

#define NColor_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, INT32,    RGBA,              1)
#define NColor_CALLBACK NULL
#define NColor_DEFAULT NULL

#define NCharColors_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Skin,              1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Arms,              2) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Body,              3) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Legs,              4) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Hair,              5) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Feet,              6)
#define NCharColors_CALLBACK NULL
#define NCharColors_DEFAULT NULL
#define NCharColors_Skin_MSGTYPE NColor
#define NCharColors_Arms_MSGTYPE NColor
#define NCharColors_Body_MSGTYPE NColor
#define NCharColors_Legs_MSGTYPE NColor
#define NCharColors_Hair_MSGTYPE NColor
#define NCharColors_Feet_MSGTYPE NColor

#define NPlayerStats_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   Score,             1) \
X(a, STATIC,   SINGULAR, UINT32,   Kills,             2) \
X(a, STATIC,   SINGULAR, UINT32,   Suicides,          3) \
X(a, STATIC,   SINGULAR, UINT32,   Friendlies,        4) \
X(a, STATIC,   SINGULAR, UINT32,   TimeTicks,         5)
#define NPlayerStats_CALLBACK NULL
#define NPlayerStats_DEFAULT NULL

#define NPlayerData_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, STRING,   Name,              1) \
X(a, STATIC,   SINGULAR, STRING,   CharacterClass,    2) \
X(a, STATIC,   SINGULAR, STRING,   Hair,              3) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Colors,            4) \
X(a, STATIC,   REPEATED, STRING,   Weapons,           5) \
X(a, STATIC,   SINGULAR, UINT32,   Lives,             6) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Stats,             7) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Totals,            8) \
X(a, STATIC,   SINGULAR, UINT32,   MaxHealth,         9) \
X(a, STATIC,   SINGULAR, UINT32,   LastMission,      10) \
X(a, STATIC,   SINGULAR, UINT32,   UID,              11) \
X(a, STATIC,   REPEATED, MESSAGE,  Ammo,             12)
#define NPlayerData_CALLBACK NULL
#define NPlayerData_DEFAULT NULL
#define NPlayerData_Colors_MSGTYPE NCharColors
#define NPlayerData_Stats_MSGTYPE NPlayerStats
#define NPlayerData_Totals_MSGTYPE NPlayerStats
#define NPlayerData_Ammo_MSGTYPE NAmmo

#define NPlayerRemove_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1)
#define NPlayerRemove_CALLBACK NULL
#define NPlayerRemove_DEFAULT NULL

#define NConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, STRING,   Name,              1) \
X(a, STATIC,   SINGULAR, STRING,   Value,             2)
#define NConfig_CALLBACK NULL
#define NConfig_DEFAULT NULL

#define NTileSet_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Pos,               1) \
X(a, STATIC,   SINGULAR, STRING,   ClassName,         2) \
X(a, STATIC,   SINGULAR, STRING,   DoorClassName,     3) \
X(a, STATIC,   SINGULAR, STRING,   DoorClass2Name,    4) \
X(a, STATIC,   SINGULAR, INT32,    RunLength,         5)
#define NTileSet_CALLBACK NULL
#define NTileSet_DEFAULT NULL
#define NTileSet_Pos_MSGTYPE NVec2i

#define NThingDamage_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, INT32,    Kind,              2) \
X(a, STATIC,   SINGULAR, INT32,    SourceActorUID,    3) \
X(a, STATIC,   SINGULAR, INT32,    Power,             4) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Vel,               5) \
X(a, STATIC,   SINGULAR, FLOAT,    Mass,              6) \
X(a, STATIC,   SINGULAR, UINT32,   Flags,             7) \
X(a, STATIC,   SINGULAR, INT32,    Special,           8) \
X(a, STATIC,   SINGULAR, INT32,    SpecialTicks,      9)
#define NThingDamage_CALLBACK NULL
#define NThingDamage_DEFAULT NULL
#define NThingDamage_Vel_MSGTYPE NVec2

#define NMapObjectAdd_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, STRING,   MapObjectClass,    2) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Pos,               3) \
X(a, STATIC,   SINGULAR, UINT32,   ThingFlags,        4) \
X(a, STATIC,   SINGULAR, INT32,    Health,            5) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Mask,              6)
#define NMapObjectAdd_CALLBACK NULL
#define NMapObjectAdd_DEFAULT NULL
#define NMapObjectAdd_Pos_MSGTYPE NVec2
#define NMapObjectAdd_Mask_MSGTYPE NColor

#define NMapObjectRemove_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, INT32,    ActorUID,          2) \
X(a, STATIC,   SINGULAR, UINT32,   Flags,             3)
#define NMapObjectRemove_CALLBACK NULL
#define NMapObjectRemove_DEFAULT NULL

#define NScore_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   PlayerUID,         1) \
X(a, STATIC,   SINGULAR, INT32,    Score,             2)
#define NScore_CALLBACK NULL
#define NScore_DEFAULT NULL

#define NSound_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, STRING,   Sound,             1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Pos,               2) \
X(a, STATIC,   SINGULAR, UINT32,   Distance,          3)
#define NSound_CALLBACK NULL
#define NSound_DEFAULT NULL
#define NSound_Pos_MSGTYPE NVec2

#define NVec2i_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, INT32,    x,                 1) \
X(a, STATIC,   SINGULAR, INT32,    y,                 2)
#define NVec2i_CALLBACK NULL
#define NVec2i_DEFAULT NULL

#define NVec2_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, FLOAT,    x,                 1) \
X(a, STATIC,   SINGULAR, FLOAT,    y,                 2)
#define NVec2_CALLBACK NULL
#define NVec2_DEFAULT NULL

#define NGameBegin_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, INT32,    MissionTime,       1)
#define NGameBegin_CALLBACK NULL
#define NGameBegin_DEFAULT NULL

#define NActorAdd_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, INT32,    PilotUID,          2) \
X(a, STATIC,   SINGULAR, INT32,    VehicleUID,        3) \
X(a, STATIC,   SINGULAR, UINT32,   CharId,            4) \
X(a, STATIC,   SINGULAR, INT32,    Direction,         5) \
X(a, STATIC,   SINGULAR, INT32,    Health,            6) \
X(a, STATIC,   SINGULAR, INT32,    PlayerUID,         7) \
X(a, STATIC,   SINGULAR, UINT32,   ThingFlags,        8) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Pos,               9) \
X(a, STATIC,   REPEATED, MESSAGE,  Ammo,             10)
#define NActorAdd_CALLBACK NULL
#define NActorAdd_DEFAULT NULL
#define NActorAdd_Pos_MSGTYPE NVec2
#define NActorAdd_Ammo_MSGTYPE NAmmo

#define NActorMove_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Pos,               2) \
X(a, STATIC,   OPTIONAL, MESSAGE,  MoveVel,           3)
#define NActorMove_CALLBACK NULL
#define NActorMove_DEFAULT NULL
#define NActorMove_Pos_MSGTYPE NVec2
#define NActorMove_MoveVel_MSGTYPE NVec2

#define NActorState_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, INT32,    State,             2)
#define NActorState_CALLBACK NULL
#define NActorState_DEFAULT NULL

#define NActorDir_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, INT32,    Dir,               2)
#define NActorDir_CALLBACK NULL
#define NActorDir_DEFAULT NULL

#define NActorSlide_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Vel,               2)
#define NActorSlide_CALLBACK NULL
#define NActorSlide_DEFAULT NULL
#define NActorSlide_Vel_MSGTYPE NVec2

#define NActorImpulse_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Vel,               2) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Pos,               3)
#define NActorImpulse_CALLBACK NULL
#define NActorImpulse_DEFAULT NULL
#define NActorImpulse_Vel_MSGTYPE NVec2
#define NActorImpulse_Pos_MSGTYPE NVec2

#define NActorSwitchGun_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, UINT32,   GunIdx,            2)
#define NActorSwitchGun_CALLBACK NULL
#define NActorSwitchGun_DEFAULT NULL

#define NActorPickupAll_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, BOOL,     PickupAll,         2)
#define NActorPickupAll_CALLBACK NULL
#define NActorPickupAll_DEFAULT NULL

#define NActorReplaceGun_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, UINT32,   GunIdx,            2) \
X(a, STATIC,   SINGULAR, STRING,   Gun,               3)
#define NActorReplaceGun_CALLBACK NULL
#define NActorReplaceGun_DEFAULT NULL

#define NActorHeal_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, INT32,    PlayerUID,         2) \
X(a, STATIC,   SINGULAR, INT32,    Amount,            3) \
X(a, STATIC,   SINGULAR, BOOL,     IsRandomSpawned,   4)
#define NActorHeal_CALLBACK NULL
#define NActorHeal_DEFAULT NULL

#define NAmmo_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   Id,                1) \
X(a, STATIC,   SINGULAR, UINT32,   Amount,            2)
#define NAmmo_CALLBACK NULL
#define NAmmo_DEFAULT NULL

#define NActorAddAmmo_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, INT32,    PlayerUID,         2) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Ammo,              3) \
X(a, STATIC,   SINGULAR, BOOL,     IsRandomSpawned,   4)
#define NActorAddAmmo_CALLBACK NULL
#define NActorAddAmmo_DEFAULT NULL
#define NActorAddAmmo_Ammo_MSGTYPE NAmmo

#define NActorUseAmmo_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, INT32,    PlayerUID,         2) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Ammo,              3)
#define NActorUseAmmo_CALLBACK NULL
#define NActorUseAmmo_DEFAULT NULL
#define NActorUseAmmo_Ammo_MSGTYPE NAmmo

#define NActorDie_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, INT32,    UID,               1)
#define NActorDie_CALLBACK NULL
#define NActorDie_DEFAULT NULL

#define NPlayerAddLives_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, INT32,    UID,               1) \
X(a, STATIC,   SINGULAR, UINT32,   Lives,             2)
#define NPlayerAddLives_CALLBACK NULL
#define NPlayerAddLives_DEFAULT NULL

#define NActorMelee_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, STRING,   BulletClass,       2) \
X(a, STATIC,   SINGULAR, INT32,    HitType,           3) \
X(a, STATIC,   SINGULAR, INT32,    TargetKind,        4) \
X(a, STATIC,   SINGULAR, UINT32,   TargetUID,         5)
#define NActorMelee_CALLBACK NULL
#define NActorMelee_DEFAULT NULL

#define NActorPilot_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, INT32,    VehicleUID,        2) \
X(a, STATIC,   SINGULAR, BOOL,     On,                3)
#define NActorPilot_CALLBACK NULL
#define NActorPilot_DEFAULT NULL

#define NAddPickup_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, STRING,   PickupClass,       2) \
X(a, STATIC,   SINGULAR, BOOL,     IsRandomSpawned,   3) \
X(a, STATIC,   SINGULAR, INT32,    SpawnerUID,        4) \
X(a, STATIC,   SINGULAR, UINT32,   ThingFlags,        5) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Pos,               6)
#define NAddPickup_CALLBACK NULL
#define NAddPickup_DEFAULT NULL
#define NAddPickup_Pos_MSGTYPE NVec2

#define NRemovePickup_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, INT32,    SpawnerUID,        2)
#define NRemovePickup_CALLBACK NULL
#define NRemovePickup_DEFAULT NULL

#define NBulletBounce_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, INT32,    HitType,           2) \
X(a, STATIC,   SINGULAR, BOOL,     Spark,             3) \
X(a, STATIC,   OPTIONAL, MESSAGE,  BouncePos,         4) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Pos,               5) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Vel,               6) \
X(a, STATIC,   SINGULAR, BOOL,     HitSound,          7) \
X(a, STATIC,   SINGULAR, BOOL,     WallMark,          8)
#define NBulletBounce_CALLBACK NULL
#define NBulletBounce_DEFAULT NULL
#define NBulletBounce_BouncePos_MSGTYPE NVec2
#define NBulletBounce_Pos_MSGTYPE NVec2
#define NBulletBounce_Vel_MSGTYPE NVec2

#define NRemoveBullet_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1)
#define NRemoveBullet_CALLBACK NULL
#define NRemoveBullet_DEFAULT NULL

#define NGunReload_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, INT32,    PlayerUID,         1) \
X(a, STATIC,   SINGULAR, STRING,   Gun,               2) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Pos,               3) \
X(a, STATIC,   SINGULAR, INT32,    Direction,         4)
#define NGunReload_CALLBACK NULL
#define NGunReload_DEFAULT NULL
#define NGunReload_Pos_MSGTYPE NVec2

#define NGunFire_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, INT32,    ActorUID,          1) \
X(a, STATIC,   SINGULAR, STRING,   Gun,               2) \
X(a, STATIC,   OPTIONAL, MESSAGE,  MuzzlePos,         3) \
X(a, STATIC,   SINGULAR, INT32,    Z,                 4) \
X(a, STATIC,   SINGULAR, FLOAT,    Angle,             5) \
X(a, STATIC,   SINGULAR, BOOL,     Sound,             6) \
X(a, STATIC,   SINGULAR, UINT32,   Flags,             7) \
X(a, STATIC,   SINGULAR, BOOL,     IsGun,             8)
#define NGunFire_CALLBACK NULL
#define NGunFire_DEFAULT NULL
#define NGunFire_MuzzlePos_MSGTYPE NVec2

#define NGunState_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   ActorUID,          1) \
X(a, STATIC,   SINGULAR, INT32,    Barrel,            2) \
X(a, STATIC,   SINGULAR, INT32,    State,             3)
#define NGunState_CALLBACK NULL
#define NGunState_DEFAULT NULL

#define NAddBullet_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1) \
X(a, STATIC,   SINGULAR, STRING,   BulletClass,       2) \
X(a, STATIC,   OPTIONAL, MESSAGE,  MuzzlePos,         3) \
X(a, STATIC,   SINGULAR, INT32,    MuzzleHeight,      4) \
X(a, STATIC,   SINGULAR, FLOAT,    Angle,             5) \
X(a, STATIC,   SINGULAR, INT32,    Elevation,         6) \
X(a, STATIC,   SINGULAR, UINT32,   Flags,             7) \
X(a, STATIC,   SINGULAR, INT32,    ActorUID,          8)
#define NAddBullet_CALLBACK NULL
#define NAddBullet_DEFAULT NULL
#define NAddBullet_MuzzlePos_MSGTYPE NVec2

#define NTrigger_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   ID,                1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Tile,              2)
#define NTrigger_CALLBACK NULL
#define NTrigger_DEFAULT NULL
#define NTrigger_Tile_MSGTYPE NVec2i

#define NExploreTiles_FIELDLIST(X, a) \
X(a, STATIC,   REPEATED, MESSAGE,  Runs,              1)
#define NExploreTiles_CALLBACK NULL
#define NExploreTiles_DEFAULT NULL
#define NExploreTiles_Runs_MSGTYPE NExploreTiles_Run

#define NExploreTiles_Run_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Tile,              1) \
X(a, STATIC,   SINGULAR, INT32,    Run,               2)
#define NExploreTiles_Run_CALLBACK NULL
#define NExploreTiles_Run_DEFAULT NULL
#define NExploreTiles_Run_Tile_MSGTYPE NVec2i

#define NRescueCharacter_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   UID,               1)
#define NRescueCharacter_CALLBACK NULL
#define NRescueCharacter_DEFAULT NULL

#define NObjectiveUpdate_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   ObjectiveId,       1) \
X(a, STATIC,   SINGULAR, INT32,    Count,             2)
#define NObjectiveUpdate_CALLBACK NULL
#define NObjectiveUpdate_DEFAULT NULL

#define NAddKeys_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   KeyFlags,          1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Pos,               2)
#define NAddKeys_CALLBACK NULL
#define NAddKeys_DEFAULT NULL
#define NAddKeys_Pos_MSGTYPE NVec2

#define NDoorToggle_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     IsOpen,            1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  Pos,               2)
#define NDoorToggle_CALLBACK NULL
#define NDoorToggle_DEFAULT NULL
#define NDoorToggle_Pos_MSGTYPE NVec2i

#define NMissionComplete_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     ShowMsg,           1)
#define NMissionComplete_CALLBACK NULL
#define NMissionComplete_DEFAULT NULL

#define NMissionEnd_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, INT32,    Delay,             1) \
X(a, STATIC,   SINGULAR, BOOL,     IsQuit,            2) \
X(a, STATIC,   SINGULAR, STRING,   Msg,               3) \
X(a, STATIC,   SINGULAR, UINT32,   Mission,           4)
#define NMissionEnd_CALLBACK NULL
#define NMissionEnd_DEFAULT NULL

extern const pb_msgdesc_t NServerInfo_msg;
extern const pb_msgdesc_t NClientId_msg;
extern const pb_msgdesc_t NCampaignDef_msg;
extern const pb_msgdesc_t NColor_msg;
extern const pb_msgdesc_t NCharColors_msg;
extern const pb_msgdesc_t NPlayerStats_msg;
extern const pb_msgdesc_t NPlayerData_msg;
extern const pb_msgdesc_t NPlayerRemove_msg;
extern const pb_msgdesc_t NConfig_msg;
extern const pb_msgdesc_t NTileSet_msg;
extern const pb_msgdesc_t NThingDamage_msg;
extern const pb_msgdesc_t NMapObjectAdd_msg;
extern const pb_msgdesc_t NMapObjectRemove_msg;
extern const pb_msgdesc_t NScore_msg;
extern const pb_msgdesc_t NSound_msg;
extern const pb_msgdesc_t NVec2i_msg;
extern const pb_msgdesc_t NVec2_msg;
extern const pb_msgdesc_t NGameBegin_msg;
extern const pb_msgdesc_t NActorAdd_msg;
extern const pb_msgdesc_t NActorMove_msg;
extern const pb_msgdesc_t NActorState_msg;
extern const pb_msgdesc_t NActorDir_msg;
extern const pb_msgdesc_t NActorSlide_msg;
extern const pb_msgdesc_t NActorImpulse_msg;
extern const pb_msgdesc_t NActorSwitchGun_msg;
extern const pb_msgdesc_t NActorPickupAll_msg;
extern const pb_msgdesc_t NActorReplaceGun_msg;
extern const pb_msgdesc_t NActorHeal_msg;
extern const pb_msgdesc_t NAmmo_msg;
extern const pb_msgdesc_t NActorAddAmmo_msg;
extern const pb_msgdesc_t NActorUseAmmo_msg;
extern const pb_msgdesc_t NActorDie_msg;
extern const pb_msgdesc_t NPlayerAddLives_msg;
extern const pb_msgdesc_t NActorMelee_msg;
extern const pb_msgdesc_t NActorPilot_msg;
extern const pb_msgdesc_t NAddPickup_msg;
extern const pb_msgdesc_t NRemovePickup_msg;
extern const pb_msgdesc_t NBulletBounce_msg;
extern const pb_msgdesc_t NRemoveBullet_msg;
extern const pb_msgdesc_t NGunReload_msg;
extern const pb_msgdesc_t NGunFire_msg;
extern const pb_msgdesc_t NGunState_msg;
extern const pb_msgdesc_t NAddBullet_msg;
extern const pb_msgdesc_t NTrigger_msg;
extern const pb_msgdesc_t NExploreTiles_msg;
extern const pb_msgdesc_t NExploreTiles_Run_msg;
extern const pb_msgdesc_t NRescueCharacter_msg;
extern const pb_msgdesc_t NObjectiveUpdate_msg;
extern const pb_msgdesc_t NAddKeys_msg;
extern const pb_msgdesc_t NDoorToggle_msg;
extern const pb_msgdesc_t NMissionComplete_msg;
extern const pb_msgdesc_t NMissionEnd_msg;

/* Defines for backwards compatibility with code written before nanopb-0.4.0 */
#define NServerInfo_fields &NServerInfo_msg
#define NClientId_fields &NClientId_msg
#define NCampaignDef_fields &NCampaignDef_msg
#define NColor_fields &NColor_msg
#define NCharColors_fields &NCharColors_msg
#define NPlayerStats_fields &NPlayerStats_msg
#define NPlayerData_fields &NPlayerData_msg
#define NPlayerRemove_fields &NPlayerRemove_msg
#define NConfig_fields &NConfig_msg
#define NTileSet_fields &NTileSet_msg
#define NThingDamage_fields &NThingDamage_msg
#define NMapObjectAdd_fields &NMapObjectAdd_msg
#define NMapObjectRemove_fields &NMapObjectRemove_msg
#define NScore_fields &NScore_msg
#define NSound_fields &NSound_msg
#define NVec2i_fields &NVec2i_msg
#define NVec2_fields &NVec2_msg
#define NGameBegin_fields &NGameBegin_msg
#define NActorAdd_fields &NActorAdd_msg
#define NActorMove_fields &NActorMove_msg
#define NActorState_fields &NActorState_msg
#define NActorDir_fields &NActorDir_msg
#define NActorSlide_fields &NActorSlide_msg
#define NActorImpulse_fields &NActorImpulse_msg
#define NActorSwitchGun_fields &NActorSwitchGun_msg
#define NActorPickupAll_fields &NActorPickupAll_msg
#define NActorReplaceGun_fields &NActorReplaceGun_msg
#define NActorHeal_fields &NActorHeal_msg
#define NAmmo_fields &NAmmo_msg
#define NActorAddAmmo_fields &NActorAddAmmo_msg
#define NActorUseAmmo_fields &NActorUseAmmo_msg
#define NActorDie_fields &NActorDie_msg
#define NPlayerAddLives_fields &NPlayerAddLives_msg
#define NActorMelee_fields &NActorMelee_msg
#define NActorPilot_fields &NActorPilot_msg
#define NAddPickup_fields &NAddPickup_msg
#define NRemovePickup_fields &NRemovePickup_msg
#define NBulletBounce_fields &NBulletBounce_msg
#define NRemoveBullet_fields &NRemoveBullet_msg
#define NGunReload_fields &NGunReload_msg
#define NGunFire_fields &NGunFire_msg
#define NGunState_fields &NGunState_msg
#define NAddBullet_fields &NAddBullet_msg
#define NTrigger_fields &NTrigger_msg
#define NExploreTiles_fields &NExploreTiles_msg
#define NExploreTiles_Run_fields &NExploreTiles_Run_msg
#define NRescueCharacter_fields &NRescueCharacter_msg
#define NObjectiveUpdate_fields &NObjectiveUpdate_msg
#define NAddKeys_fields &NAddKeys_msg
#define NDoorToggle_fields &NDoorToggle_msg
#define NMissionComplete_fields &NMissionComplete_msg
#define NMissionEnd_fields &NMissionEnd_msg

/* Maximum encoded size of messages (where known) */
#define NServerInfo_size                         95
#define NClientId_size                           12
#define NCampaignDef_size                        4115
#define NColor_size                              11
#define NCharColors_size                         78
#define NPlayerStats_size                        30
#define NPlayerData_size                         2631
#define NPlayerRemove_size                       6
#define NConfig_size                             260
#define NTileSet_size                            425
#define NThingDamage_size                        84
#define NMapObjectAdd_size                       178
#define NMapObjectRemove_size                    23
#define NScore_size                              17
#define NSound_size                              148
#define NVec2i_size                              22
#define NVec2_size                               10
#define NGameBegin_size                          11
#define NActorAdd_size                           1877
#define NActorMove_size                          30
#define NActorState_size                         17
#define NActorDir_size                           17
#define NActorSlide_size                         18
#define NActorImpulse_size                       30
#define NActorSwitchGun_size                     12
#define NActorPickupAll_size                     8
#define NActorReplaceGun_size                    142
#define NActorHeal_size                          30
#define NAmmo_size                               12
#define NActorAddAmmo_size                       33
#define NActorUseAmmo_size                       31
#define NActorDie_size                           11
#define NPlayerAddLives_size                     17
#define NActorMelee_size                         164
#define NActorPilot_size                         19
#define NAddPickup_size                          167
#define NRemovePickup_size                       17
#define NBulletBounce_size                       59
#define NRemoveBullet_size                       6
#define NGunReload_size                          164
#define NGunFire_size                            179
#define NGunState_size                           28
#define NAddBullet_size                          192
#define NTrigger_size                            30
#define NExploreTiles_size                       592
#define NExploreTiles_Run_size                   35
#define NRescueCharacter_size                    6
#define NObjectiveUpdate_size                    17
#define NAddKeys_size                            18
#define NDoorToggle_size                         26
#define NMissionComplete_size                    2
#define NMissionEnd_size                         149

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
