/*
 * ct_config.h
 * 
 * Copyright 2017-2018 Giuseppe Penone <giuspen@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#pragma once

#include <unordered_map>
#include <glibmm.h>
#include "ct_const.h"

enum class CtRestoreExpColl : int {FROM_STR=0, ALL_EXP=1, ALL_COLL=2};

enum class CtTableColMode : int {RENAME=0, ADD=1, DELETE=2, RIGHT=3, LEFT=4};

struct CtRecentDocRestore
{
    Glib::ustring   doc_name;
    Glib::ustring   exp_coll_str;
    Glib::ustring   node_path;
    int             cursor_pos;
};

class CtConfig
{
public:
    CtConfig();
    virtual ~CtConfig();

    // [state]
    Glib::ustring                               fileDir;
    Glib::ustring                               fileName;
    bool                                        toolbarVisible{true};
    bool                                        winIsMaximised{false};
    int                                         winRect[4]{10, 10, 963, 630};
    int                                         hpanedPos{170};
    bool                                        treeVisible{true};
    Glib::ustring                               nodePath;
    int                                         cursorPosition;
    std::list<Glib::ustring>                    recentDocs;
    Glib::ustring                               pickDirImport;
    Glib::ustring                               pickDirExport;
    Glib::ustring                               pickDirFile;
    Glib::ustring                               pickDirImg;
    Glib::ustring                               pickDirCsv;
    Glib::ustring                               pickDirCbox;
    Glib::ustring                               linkType{CtConst::LINK_TYPE_WEBS};
    bool                                        showNodeNameHeader{true};
    int                                         nodesOnNodeNameHeader{3};
    int                                         toolbarIconSize{Gtk::BuiltinIconSize::ICON_SIZE_MENU};
    std::unordered_map<gchar, Glib::ustring>    currColors{{'f', ""}, {'b', ""}, {'n', ""}};

    // [tree]
    CtRestoreExpColl                            restoreExpColl{CtRestoreExpColl::FROM_STR};
    Glib::ustring                               expandedCollapsedString;
    std::vector<CtRecentDocRestore>             recentDocsRestore;
    bool                                        nodesBookmExp{false};
    Glib::ustring                               nodesIcons{CtConst::NODE_ICON_TYPE_CHERRY};
    bool                                        auxIconHide{false};
    int                                         defaultIconText{CtConst::NODE_ICON_BULLET_ID};
    bool                                        treeRightSide{false};
    int                                         cherryWrapWidth{130};
    bool                                        treeClickFocusText{false};
    bool                                        treeClickExpand{false};

    // [editor]
    std::string                                 syntaxHighlighting{CtConst::RICH_TEXT_ID};
    std::string                                 autoSynHighl{CtConst::SYN_HIGHL_BASH};
    std::string                                 styleSchemeId{CtConst::STYLE_SCHEME_DARK};
    bool                                        enableSpellCheck{false};
    Glib::ustring                               spellCheckLang;
    bool                                        showLineNumbers{false};
    bool                                        spacesInsteadTabs{false};
    int                                         tabsWidth{4};
    int                                         anchorSize{16};
    int                                         embfileSize{48};
    bool                                        embfileShowFileName{true};
    int                                         embfileMaxSize{10};
    bool                                        lineWrapping{true};
    bool                                        autoSmartQuotes{true};
    int                                         wrappingIndent{-14};
    bool                                        autoIndent{true};
    bool                                        rtShowWhiteSpaces{false};
    bool                                        ptShowWhiteSpaces{true};
    bool                                        rtHighlCurrLine{true};
    bool                                        ptHighlCurrLine{true};
    int                                         spaceAroundLines{0};
    int                                         relativeWrappedSpace{50};
    Glib::ustring                               hRule{"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"};
    Glib::ustring                               specialChars{CtConst::SPECIAL_CHARS_DEFAULT};
    Glib::ustring                               selwordChars{CtConst::SELWORD_CHARS_DEFAULT};
    Glib::ustring                               charsListbul{CtConst::CHARS_LISTBUL_DEFAULT};
    Glib::ustring                               charsToc{CtConst::CHARS_TOC_DEFAULT};
    Glib::ustring                               charsTodo{CtConst::CHARS_TODO_DEFAULT};
    Glib::ustring                               latestTagProp;
    Glib::ustring                               latestTagVal;
    Glib::ustring                               timestampFormat{CtConst::TIMESTAMP_FORMAT_DEFAULT};
    bool                                        linksUnderline{true};
    bool                                        linksRelative{false};
    bool                                        weblinkCustomOn{false};
    bool                                        filelinkCustomOn{false};
    bool                                        folderlinkCustomOn{false};
    Glib::ustring                               weblinkCustomAct{"firefox %s &"};
    Glib::ustring                               filelinkCustomAct{"xdg-open %s &"};
    Glib::ustring                               folderlinkCustomAct{"xdg-open %s &"};

    // [codebox]
    double                                      codeboxWidth{500};
    double                                      codeboxHeight{100};
    bool                                        codeboxWidthPixels{true};
    bool                                        codeboxLineNum{false};
    bool                                        codeboxMatchBra{true};
    Glib::ustring                               codeboxSynHighl{CtConst::PLAIN_TEXT_ID};
    bool                                        codeboxAutoResize{false};

    // [table]
    int                                         tableRows{3};
    int                                         tableColumns{3};
    CtTableColMode                              tableColMode{CtTableColMode::RENAME};
    int                                         tableColMin{40};
    int                                         tableColMax{60};

    // [fonts]
    std::string                                 rtFont{"Sans 9"};
    std::string                                 ptFont{"Sans 9"};
    std::string                                 treeFont{"Sans 8"};
    std::string                                 codeFont{"Monospace 9"};

    // [colors]
    Glib::ustring                               rtDefFg{CtConst::RICH_TEXT_DARK_FG};
    Glib::ustring                               rtDefBg{CtConst::RICH_TEXT_DARK_BG};
    Glib::ustring                               ttDefFg{CtConst::TREE_TEXT_LIGHT_FG};
    Glib::ustring                               ttDefBg{CtConst::TREE_TEXT_LIGHT_BG};
    Glib::ustring                               monospaceBg{CtConst::DEFAULT_MONOSPACE_BG};
    Glib::ustring                               colorPalette{"#000000:#ffffff:#7f7f7f:#ff0000:#a020f0:"
                                                             "#0000ff:#add8e6:#00ff00:#ffff00:#ffa500:"
                                                             "#e6e6fa:#a52a2a:#8b6914:#1e90ff:#ffc0cb:"
                                                             "#90ee90:#1a1a1a:#4d4d4d:#bfbfbf:#e5e5e5"};
    Glib::ustring                               colLinkWebs{CtConst::COLOR_48_LINK_WEBS};
    Glib::ustring                               colLinkNode{CtConst::COLOR_48_LINK_NODE};
    Glib::ustring                               colLinkFile{CtConst::COLOR_48_LINK_FILE};
    Glib::ustring                               colLinkFold{CtConst::COLOR_48_LINK_FOLD};

    // [misc]
    Glib::ustring                               toolbarUiList{CtConst::TOOLBAR_VEC_DEFAULT};
    bool                                        systrayOn{false};
    bool                                        startOnSystray{false};
    bool                                        useAppInd{false};
    bool                                        autosaveOn{false};
    int                                         autosaveVal{5};
    bool                                        checkVersion{false};
    bool                                        wordCountOn{false};
    bool                                        reloadDocLast{true};
    bool                                        modTimeSentinel{true};
    bool                                        backupCopy{true};
    int                                         backupNum{3};
    bool                                        autosaveOnQuit{false};
    int                                         limitUndoableSteps{20};

    // [keyboard]
    std::map<Glib::ustring, Glib::ustring>     customKbShortcuts;

    // [codexec_term]
    Glib::ustring                              customCodexecTerm;

    // [codexec_type]
    std::map<Glib::ustring, Glib::ustring>     customCodexecType;

    // [codexec_ext]
    std::map<Glib::ustring, Glib::ustring>     customCodexecExt;

protected:
    bool _populateStringFromKeyfile(const gchar* key, Glib::ustring* pTarget);
    bool _populateStringFromKeyfile(const gchar* key, std::string* pTarget);
    bool _populateBoolFromKeyfile(const gchar* key, bool* pTarget);
    bool _populateIntFromKeyfile(const gchar* key, int* pTarget);
    bool _populateDoubleFromKeyfile(const gchar* key, double* pTarget);
    void _populateMapFromCurrentGroup(std::map<Glib::ustring, Glib::ustring>* pTarget);
    void _populateFromKeyfile();
    bool _checkLoadFromFile();
    void _unexpectedKeyfileError(const gchar* key, const Glib::KeyFileError& kferror);

    Glib::ustring _filepath;
    Glib::KeyFile* _pKeyFile{nullptr};
    Glib::ustring _currentGroup;
};
