# Copyright 2019 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

from selenium import webdriver
from pywinauto.application import Application
from pywinauto.findwindows import ElementNotFoundError
import os

options = webdriver.ChromeOptions()
options.add_argument("--force-renderer-accessibility")

os.environ["CHROME_LOG_FILE"] = r"c:\temp\chrome_log.txt"

driver = webdriver.Chrome(
    "C:/ProgramData/chocolatey/lib/chromedriver/tools/chromedriver.exe",
    chrome_options=options,
    service_args=["--verbose", r"--log-path=c:\temp\chromedriver.log"])

try:
  app = Application(backend="uia")
  app.connect(title_re='.*Chrome|.*Chromium')
  app.top_window().child_window(title="Bookmarks", control_type="ToolBar") \
      .print_control_identifiers()
  print "Bookmarkbar is found"
except ElementNotFoundError as error:
  print error
  print "Bookmarkbar is missing"
finally:
  driver.quit()
