// Copyright 2015 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * Explains why a download is in DANGEROUS state.
 * @enum {string}
 */
export const DangerType = {
  NOT_DANGEROUS: 'NOT_DANGEROUS',
  DANGEROUS_FILE: 'DANGEROUS_FILE',
  DANGEROUS_URL: 'DANGEROUS_URL',
  DANGEROUS_CONTENT: 'DANGEROUS_CONTENT',
  UNCOMMON_CONTENT: 'UNCOMMON_CONTENT',
  DANGEROUS_HOST: 'DANGEROUS_HOST',
  POTENTIALLY_UNWANTED: 'POTENTIALLY_UNWANTED',
  DEEP_SCANNED_SAFE: 'DEEP_SCANNED_SAFE',
  DEEP_SCANNED_OPENED_DANGEROUS: 'DEEP_SCANNED_OPENED_DANGEROUS',
  SENSITIVE_CONTENT_WARNING: 'SENSITIVE_CONTENT_WARNING',
  SENSITIVE_CONTENT_BLOCK: 'SENSITIVE_CONTENT_BLOCK',
  BLOCKED_TOO_LARGE: 'BLOCKED_TOO_LARGE',
  BLOCKED_PASSWORD_PROTECTED: 'BLOCKED_PASSWORD_PROTECTED',
};

/**
 * The states a download can be in. These correspond to states defined in
 * DownloadsDOMHandler::CreateDownloadItemValue
 * @enum {string}
 */
export const States = {
  IN_PROGRESS: 'IN_PROGRESS',
  CANCELLED: 'CANCELLED',
  COMPLETE: 'COMPLETE',
  PAUSED: 'PAUSED',
  DANGEROUS: 'DANGEROUS',
  INTERRUPTED: 'INTERRUPTED',
  MIXED_CONTENT: 'MIXED_CONTENT',
};
