// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * Specifies all possible routes in settings.
 *
 * @typedef {{
 *   ABOUT: (undefined|!settings.Route),
 *   ABOUT_ABOUT: (undefined|!settings.Route),
 *   ACCESSIBILITY: (undefined|!settings.Route),
 *   ACCOUNTS: (undefined|!settings.Route),
 *   ACCOUNT_MANAGER: (undefined|!settings.Route),
 *   ADVANCED: (undefined|!settings.Route),
 *   ADDRESSES: (undefined|!settings.Route),
 *   APP_MANAGEMENT: (undefined|!settings.Route),
 *   APP_MANAGEMENT_DETAIL: (undefined|!settings.Route),
 *   APPS: (undefined|!settings.Route),
 *   ANDROID_APPS: (undefined|!settings.Route),
 *   ANDROID_APPS_DETAILS: (undefined|!settings.Route),
 *   CROSTINI: (undefined|!settings.Route),
 *   CROSTINI_ANDROID_ADB: (undefined|!settings.Route),
 *   CROSTINI_DETAILS: (undefined|!settings.Route),
 *   CROSTINI_EXPORT_IMPORT: (undefined|!settings.Route),
 *   CROSTINI_SHARED_PATHS: (undefined|!settings.Route),
 *   CROSTINI_SHARED_USB_DEVICES: (undefined|!settings.Route),
 *   APPEARANCE: (undefined|!settings.Route),
 *   AUTOFILL: (undefined|!settings.Route),
 *   BASIC: (undefined|!settings.Route),
 *   BLUETOOTH: (undefined|!settings.Route),
 *   BLUETOOTH_DEVICES: (undefined|!settings.Route),
 *   CAPTIONS: (undefined|!settings.Route),
 *   CERTIFICATES: (undefined|!settings.Route),
 *   CHANGE_PICTURE: (undefined|!settings.Route),
 *   CHROME_CLEANUP: (undefined|!settings.Route),
 *   CLEAR_BROWSER_DATA: (undefined|!settings.Route),
 *   CLOUD_PRINTERS: (undefined|!settings.Route),
 *   CUPS_PRINTERS: (undefined|!settings.Route),
 *   DATETIME: (undefined|!settings.Route),
 *   DATETIME_TIMEZONE_SUBPAGE: (undefined|!settings.Route),
 *   DEFAULT_BROWSER: (undefined|!settings.Route),
 *   DETAILED_BUILD_INFO: (undefined|!settings.Route),
 *   DEVICE: (undefined|!settings.Route),
 *   DISPLAY: (undefined|!settings.Route),
 *   DOWNLOADS: (undefined|!settings.Route),
 *   EDIT_DICTIONARY: (undefined|!settings.Route),
 *   EXTERNAL_STORAGE_PREFERENCES: (undefined|!settings.Route),
 *   FINGERPRINT: (undefined|!settings.Route),
 *   FILES: (undefined|!settings.Route),
 *   FONTS: (undefined|!settings.Route),
 *   GOOGLE_ASSISTANT: (undefined|!settings.Route),
 *   IMPORT_DATA: (undefined|!settings.Route),
 *   INCOMPATIBLE_APPLICATIONS: (undefined|!settings.Route),
 *   INPUT_METHODS: (undefined|!settings.Route),
 *   INTERNET: (undefined|!settings.Route),
 *   INTERNET_NETWORKS: (undefined|!settings.Route),
 *   KERBEROS_ACCOUNTS: (undefined|!settings.Route),
 *   KEYBOARD: (undefined|!settings.Route),
 *   KNOWN_NETWORKS: (undefined|!settings.Route),
 *   LANGUAGES: (undefined|!settings.Route),
 *   LANGUAGES_DETAILS: (undefined|!settings.Route),
 *   LOCK_SCREEN: (undefined|!settings.Route),
 *   MANAGE_ACCESSIBILITY: (undefined|!settings.Route),
 *   MANAGE_CAPTION_SETTINGS: (undefined|!settings.Route),
 *   MANAGE_PROFILE: (undefined|!settings.Route),
 *   MANAGE_SWITCH_ACCESS_SETTINGS: (undefined|!settings.Route),
 *   MANAGE_TTS_SETTINGS: (undefined|!settings.Route),
 *   MULTIDEVICE: (undefined|!settings.Route),
 *   MULTIDEVICE_FEATURES: (undefined|!settings.Route),
 *   NETWORK_DETAIL: (undefined|!settings.Route),
 *   ON_STARTUP: (undefined|!settings.Route),
 *   OS_SYNC: (undefined|!settings.Route),
 *   PASSWORDS: (undefined|!settings.Route),
 *   PAYMENTS: (undefined|!settings.Route),
 *   PEOPLE: (undefined|!settings.Route),
 *   PERSONALIZATION: (undefined|!settings.Route),
 *   PLUGIN_VM: (undefined|!settings.Route),
 *   PLUGIN_VM_DETAILS: (undefined|!settings.Route),
 *   PLUGIN_VM_SHARED_PATHS: (undefined|!settings.Route),
 *   POINTERS: (undefined|!settings.Route),
 *   POWER: (undefined|!settings.Route),
 *   PRINTING: (undefined|!settings.Route),
 *   PRIVACY: (undefined|!settings.Route),
 *   RESET: (undefined|!settings.Route),
 *   RESET_DIALOG: (undefined|!settings.Route),
 *   SEARCH: (undefined|!settings.Route),
 *   SEARCH_ENGINES: (undefined|!settings.Route),
 *   SECURITY: (undefined|!settings.Route),
 *   SECURITY_KEYS: (undefined|!settings.Route),
 *   SIGN_OUT: (undefined|!settings.Route),
 *   SITE_SETTINGS: (undefined|!settings.Route),
 *   SITE_SETTINGS_ADS: (undefined|!settings.Route),
 *   SITE_SETTINGS_ALL: (undefined|!settings.Route),
 *   SITE_SETTINGS_AUTOMATIC_DOWNLOADS: (undefined|!settings.Route),
 *   SITE_SETTINGS_BACKGROUND_SYNC: (undefined|!settings.Route),
 *   SITE_SETTINGS_BLUETOOTH_SCANNING: (undefined|!settings.Route),
 *   SITE_SETTINGS_CAMERA: (undefined|!settings.Route),
 *   SITE_SETTINGS_CLIPBOARD: (undefined|!settings.Route),
 *   SITE_SETTINGS_COOKIES: (undefined|!settings.Route),
 *   SITE_SETTINGS_DATA_DETAILS: (undefined|!settings.Route),
 *   SITE_SETTINGS_FLASH: (undefined|!settings.Route),
 *   SITE_SETTINGS_HANDLERS: (undefined|!settings.Route),
 *   SITE_SETTINGS_HID_DEVICES: (undefined|!settings.Route),
 *   SITE_SETTINGS_IMAGES: (undefined|!settings.Route),
 *   SITE_SETTINGS_MIXEDSCRIPT: (undefined|!settings.Route),
 *   SITE_SETTINGS_JAVASCRIPT: (undefined|!settings.Route),
 *   SITE_SETTINGS_SENSORS: (undefined|!settings.Route),
 *   SITE_SETTINGS_SOUND: (undefined|!settings.Route),
 *   SITE_SETTINGS_LOCATION: (undefined|!settings.Route),
 *   SITE_SETTINGS_MICROPHONE: (undefined|!settings.Route),
 *   SITE_SETTINGS_MIDI_DEVICES: (undefined|!settings.Route),
 *   SITE_SETTINGS_NATIVE_FILE_SYSTEM_WRITE: (undefined|!settings.Route),
 *   SITE_SETTINGS_NOTIFICATIONS: (undefined|!settings.Route),
 *   SITE_SETTINGS_PAYMENT_HANDLER: (undefined|!settings.Route),
 *   SITE_SETTINGS_PDF_DOCUMENTS: (undefined|!settings.Route),
 *   SITE_SETTINGS_POPUPS: (undefined|!settings.Route),
 *   SITE_SETTINGS_PROTECTED_CONTENT: (undefined|!settings.Route),
 *   SITE_SETTINGS_SITE_DATA: (undefined|!settings.Route),
 *   SITE_SETTINGS_SITE_DETAILS: (undefined|!settings.Route),
 *   SITE_SETTINGS_UNSANDBOXED_PLUGINS: (undefined|!settings.Route),
 *   SITE_SETTINGS_USB_DEVICES: (undefined|!settings.Route),
 *   SITE_SETTINGS_SERIAL_PORTS: (undefined|!settings.Route),
 *   SITE_SETTINGS_ZOOM_LEVELS: (undefined|!settings.Route),
 *   SMART_LOCK: (undefined|!settings.Route),
 *   SMB_SHARES: (undefined|!settings.Route),
 *   STORAGE: (undefined|!settings.Route),
 *   STYLUS: (undefined|!settings.Route),
 *   SYNC: (undefined|!settings.Route),
 *   SYNC_ADVANCED: (undefined|!settings.Route),
 *   SYSTEM: (undefined|!settings.Route),
 *   TRIGGERED_RESET_DIALOG: (undefined|!settings.Route),
 * }}
 */
let SettingsRoutes;
