// Copyright (c) 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_HANDLER_H_
#define CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_HANDLER_H_

#include "base/macros.h"
#include "base/memory/weak_ptr.h"
#include "chrome/browser/search/instant_service_observer.h"
#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom.h"
#include "chrome/common/search/instant_types.h"
#include "content/public/browser/web_contents_observer.h"
#include "mojo/public/cpp/bindings/pending_receiver.h"
#include "mojo/public/cpp/bindings/pending_remote.h"
#include "mojo/public/cpp/bindings/receiver.h"
#include "mojo/public/cpp/bindings/remote.h"

class GURL;
class InstantService;
class Profile;

namespace chrome_colors {
class ChromeColorsService;
}  // namespace chrome_colors

class NewTabPageHandler : public content::WebContentsObserver,
                          public new_tab_page::mojom::PageHandler,
                          public InstantServiceObserver {
 public:
  NewTabPageHandler(mojo::PendingReceiver<new_tab_page::mojom::PageHandler>
                        pending_page_handler,
                    mojo::PendingRemote<new_tab_page::mojom::Page> pending_page,
                    Profile* profile);
  ~NewTabPageHandler() override;

  // new_tab_page::mojom::PageHandler:
  void AddMostVisitedTile(const GURL& url,
                          const std::string& title,
                          AddMostVisitedTileCallback callback) override;
  void DeleteMostVisitedTile(const GURL& url) override;
  void RestoreMostVisitedDefaults() override;
  void ReorderMostVisitedTile(const GURL& url, uint8_t new_pos) override;
  void SetMostVisitedSettings(bool custom_links_enabled, bool visible) override;
  void UndoMostVisitedTileAction() override;
  void UpdateMostVisitedInfo() override;
  void UpdateMostVisitedTile(const GURL& url,
                             const GURL& new_url,
                             const std::string& new_title,
                             UpdateMostVisitedTileCallback callback) override;
  void ApplyDefaultTheme() override;
  void ApplyAutogeneratedTheme(const SkColor& frame_color) override;
  void ApplyChromeTheme(int32_t id) override;
  void ConfirmThemeChanges() override;
  void GetChromeThemes(GetChromeThemesCallback callback) override;
  void RevertThemeChanges() override;

 private:
  // InstantServiceObserver:
  void NtpThemeChanged(const NtpTheme& theme) override;
  void MostVisitedInfoChanged(const InstantMostVisitedInfo& info) override;

  chrome_colors::ChromeColorsService* chrome_colors_service_;
  InstantService* instant_service_;
  GURL last_blacklisted_;
  mojo::Remote<new_tab_page::mojom::Page> page_;
  mojo::Receiver<new_tab_page::mojom::PageHandler> receiver_;

  DISALLOW_COPY_AND_ASSIGN(NewTabPageHandler);
};

#endif  // CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_HANDLER_H_
