// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chromeos/services/ime/public/cpp/rulebased/def/th_pattajoti.h"

namespace th_pattajoti {

const char* kId = "th_pattajoti";
bool kIs102 = false;
const char* kNormal[] = {
    u8"_",       // BackQuote
    u8"=",       // Digit1
    u8"\u0e52",  // Digit2
    u8"\u0e53",  // Digit3
    u8"\u0e54",  // Digit4
    u8"\u0e55",  // Digit5
    u8"\u0e39",  // Digit6
    u8"\u0e57",  // Digit7
    u8"\u0e58",  // Digit8
    u8"\u0e59",  // Digit9
    u8"\u0e50",  // Digit0
    u8"\u0e51",  // Minus
    u8"\u0e56",  // Equal
    u8"\u0e47",  // KeyQ
    u8"\u0e15",  // KeyW
    u8"\u0e22",  // KeyE
    u8"\u0e2d",  // KeyR
    u8"\u0e23",  // KeyT
    u8"\u0e48",  // KeyY
    u8"\u0e14",  // KeyU
    u8"\u0e21",  // KeyI
    u8"\u0e27",  // KeyO
    u8"\u0e41",  // KeyP
    u8"\u0e43",  // BracketLeft
    u8"\u0e0c",  // BracketRight
    u8"\u0e3a",  // Backslash
    u8"\u0e49",  // KeyA
    u8"\u0e17",  // KeyS
    u8"\u0e07",  // KeyD
    u8"\u0e01",  // KeyF
    u8"\u0e31",  // KeyG
    u8"\u0e35",  // KeyH
    u8"\u0e32",  // KeyJ
    u8"\u0e19",  // KeyK
    u8"\u0e40",  // KeyL
    u8"\u0e44",  // Semicolon
    u8"\u0e02",  // Quote
    u8"\u0e1a",  // KeyZ
    u8"\u0e1b",  // KeyX
    u8"\u0e25",  // KeyC
    u8"\u0e2b",  // KeyV
    u8"\u0e34",  // KeyB
    u8"\u0e04",  // KeyN
    u8"\u0e2a",  // KeyM
    u8"\u0e30",  // Comma
    u8"\u0e08",  // Period
    u8"\u0e1e",  // Slash
    u8"\u0020",  // Space
};
const char* kShift[] = {
    u8"\u0e3f",        // BackQuote
    u8"+",             // Digit1
    u8"\"",            // Digit2
    u8"/",             // Digit3
    u8",",             // Digit4
    u8"?",             // Digit5
    u8"\u0e38",        // Digit6
    u8"\u0e45",        // Digit7
    u8".",             // Digit8
    u8"(",             // Digit9
    u8")",             // Digit0
    u8"-",             // Minus
    u8"%",             // Equal
    u8"\u0e4a",        // KeyQ
    u8"\u0e24",        // KeyW
    u8"\u0e46",        // KeyE
    u8"\u0e0d",        // KeyR
    u8"\u0e29",        // KeyT
    u8"\u0e36",        // KeyY
    u8"\u0e1d",        // KeyU
    u8"\u0e0b",        // KeyI
    u8"\u0e16",        // KeyO
    u8"\u0e12",        // KeyP
    u8"\u0e2f",        // BracketLeft
    u8"\u0e26",        // BracketRight
    u8"\u0e4d",        // Backslash
    u8"\u0e4b",        // KeyA
    u8"\u0e18",        // KeyS
    u8"\u0e33",        // KeyD
    u8"\u0e13",        // KeyF
    u8"\u0e4c",        // KeyG
    u8"\u0e37",        // KeyH
    u8"\u0e1c",        // KeyJ
    u8"\u0e0a",        // KeyK
    u8"\u0e42",        // KeyL
    u8"\u0e06",        // Semicolon
    u8"\u0e11",        // Quote
    u8"\u0e0e",        // KeyZ
    u8"\u0e0f",        // KeyX
    u8"\u0e10",        // KeyC
    u8"\u0e20",        // KeyV
    u8"\u0e31\u0e49",  // KeyB
    u8"\u0e28",        // KeyN
    u8"\u0e2e",        // KeyM
    u8"\u0e1f",        // Comma
    u8"\u0e09",        // Period
    u8"\u0e2c",        // Slash
    u8"\u0020",        // Space
};
const char* kAltGr[] = {
    u8"_",       // BackQuote
    u8"=",       // Digit1
    u8"\u0e52",  // Digit2
    u8"\u0e53",  // Digit3
    u8"\u0e54",  // Digit4
    u8"\u0e55",  // Digit5
    u8"\u0e39",  // Digit6
    u8"\u0e57",  // Digit7
    u8"\u0e58",  // Digit8
    u8"\u0e59",  // Digit9
    u8"\u0e50",  // Digit0
    u8"\u0e51",  // Minus
    u8"\u0e56",  // Equal
    u8"\u0e47",  // KeyQ
    u8"\u0e15",  // KeyW
    u8"\u0e22",  // KeyE
    u8"\u0e2d",  // KeyR
    u8"\u0e23",  // KeyT
    u8"\u0e48",  // KeyY
    u8"\u0e14",  // KeyU
    u8"\u0e21",  // KeyI
    u8"\u0e27",  // KeyO
    u8"\u0e41",  // KeyP
    u8"\u0e43",  // BracketLeft
    u8"\u0e0c",  // BracketRight
    u8"\u0e3a",  // Backslash
    u8"\u0e49",  // KeyA
    u8"\u0e17",  // KeyS
    u8"\u0e07",  // KeyD
    u8"\u0e01",  // KeyF
    u8"\u0e31",  // KeyG
    u8"\u0e35",  // KeyH
    u8"\u0e32",  // KeyJ
    u8"\u0e19",  // KeyK
    u8"\u0e40",  // KeyL
    u8"\u0e44",  // Semicolon
    u8"\u0e02",  // Quote
    u8"\u0e1a",  // KeyZ
    u8"\u0e1b",  // KeyX
    u8"\u0e25",  // KeyC
    u8"\u0e2b",  // KeyV
    u8"\u0e34",  // KeyB
    u8"\u0e04",  // KeyN
    u8"\u0e2a",  // KeyM
    u8"\u0e30",  // Comma
    u8"\u0e08",  // Period
    u8"\u0e1e",  // Slash
    u8"\u0020",  // Space
};
const char* kCapslock[] = {
    u8"\u0e3f",        // BackQuote
    u8"+",             // Digit1
    u8"\"",            // Digit2
    u8"/",             // Digit3
    u8",",             // Digit4
    u8"?",             // Digit5
    u8"\u0e38",        // Digit6
    u8"\u0e45",        // Digit7
    u8".",             // Digit8
    u8"(",             // Digit9
    u8")",             // Digit0
    u8"-",             // Minus
    u8"%",             // Equal
    u8"\u0e4a",        // KeyQ
    u8"\u0e24",        // KeyW
    u8"\u0e46",        // KeyE
    u8"\u0e0d",        // KeyR
    u8"\u0e29",        // KeyT
    u8"\u0e36",        // KeyY
    u8"\u0e1d",        // KeyU
    u8"\u0e0b",        // KeyI
    u8"\u0e16",        // KeyO
    u8"\u0e12",        // KeyP
    u8"\u0e2f",        // BracketLeft
    u8"\u0e26",        // BracketRight
    u8"\u0e4d",        // Backslash
    u8"\u0e4b",        // KeyA
    u8"\u0e18",        // KeyS
    u8"\u0e33",        // KeyD
    u8"\u0e13",        // KeyF
    u8"\u0e4c",        // KeyG
    u8"\u0e37",        // KeyH
    u8"\u0e1c",        // KeyJ
    u8"\u0e0a",        // KeyK
    u8"\u0e42",        // KeyL
    u8"\u0e06",        // Semicolon
    u8"\u0e11",        // Quote
    u8"\u0e0e",        // KeyZ
    u8"\u0e0f",        // KeyX
    u8"\u0e10",        // KeyC
    u8"\u0e20",        // KeyV
    u8"\u0e31\u0e49",  // KeyB
    u8"\u0e28",        // KeyN
    u8"\u0e2e",        // KeyM
    u8"\u0e1f",        // Comma
    u8"\u0e09",        // Period
    u8"\u0e2c",        // Slash
    u8"\u0020",        // Space
};
const char* kShiftAltGr[] = {
    u8"\u0e3f",        // BackQuote
    u8"+",             // Digit1
    u8"\"",            // Digit2
    u8"/",             // Digit3
    u8",",             // Digit4
    u8"?",             // Digit5
    u8"\u0e38",        // Digit6
    u8"\u0e45",        // Digit7
    u8".",             // Digit8
    u8"(",             // Digit9
    u8")",             // Digit0
    u8"-",             // Minus
    u8"%",             // Equal
    u8"\u0e4a",        // KeyQ
    u8"\u0e24",        // KeyW
    u8"\u0e46",        // KeyE
    u8"\u0e0d",        // KeyR
    u8"\u0e29",        // KeyT
    u8"\u0e36",        // KeyY
    u8"\u0e1d",        // KeyU
    u8"\u0e0b",        // KeyI
    u8"\u0e16",        // KeyO
    u8"\u0e12",        // KeyP
    u8"\u0e2f",        // BracketLeft
    u8"\u0e26",        // BracketRight
    u8"\u0e4d",        // Backslash
    u8"\u0e4b",        // KeyA
    u8"\u0e18",        // KeyS
    u8"\u0e33",        // KeyD
    u8"\u0e13",        // KeyF
    u8"\u0e4c",        // KeyG
    u8"\u0e37",        // KeyH
    u8"\u0e1c",        // KeyJ
    u8"\u0e0a",        // KeyK
    u8"\u0e42",        // KeyL
    u8"\u0e06",        // Semicolon
    u8"\u0e11",        // Quote
    u8"\u0e0e",        // KeyZ
    u8"\u0e0f",        // KeyX
    u8"\u0e10",        // KeyC
    u8"\u0e20",        // KeyV
    u8"\u0e31\u0e49",  // KeyB
    u8"\u0e28",        // KeyN
    u8"\u0e2e",        // KeyM
    u8"\u0e1f",        // Comma
    u8"\u0e09",        // Period
    u8"\u0e2c",        // Slash
    u8"\u0020",        // Space
};
const char* kAltgrCapslock[] = {
    u8"\u0e3f",        // BackQuote
    u8"+",             // Digit1
    u8"\"",            // Digit2
    u8"/",             // Digit3
    u8",",             // Digit4
    u8"?",             // Digit5
    u8"\u0e38",        // Digit6
    u8"\u0e45",        // Digit7
    u8".",             // Digit8
    u8"(",             // Digit9
    u8")",             // Digit0
    u8"-",             // Minus
    u8"%",             // Equal
    u8"\u0e4a",        // KeyQ
    u8"\u0e24",        // KeyW
    u8"\u0e46",        // KeyE
    u8"\u0e0d",        // KeyR
    u8"\u0e29",        // KeyT
    u8"\u0e36",        // KeyY
    u8"\u0e1d",        // KeyU
    u8"\u0e0b",        // KeyI
    u8"\u0e16",        // KeyO
    u8"\u0e12",        // KeyP
    u8"\u0e2f",        // BracketLeft
    u8"\u0e26",        // BracketRight
    u8"\u0e4d",        // Backslash
    u8"\u0e4b",        // KeyA
    u8"\u0e18",        // KeyS
    u8"\u0e33",        // KeyD
    u8"\u0e13",        // KeyF
    u8"\u0e4c",        // KeyG
    u8"\u0e37",        // KeyH
    u8"\u0e1c",        // KeyJ
    u8"\u0e0a",        // KeyK
    u8"\u0e42",        // KeyL
    u8"\u0e06",        // Semicolon
    u8"\u0e11",        // Quote
    u8"\u0e0e",        // KeyZ
    u8"\u0e0f",        // KeyX
    u8"\u0e10",        // KeyC
    u8"\u0e20",        // KeyV
    u8"\u0e31\u0e49",  // KeyB
    u8"\u0e28",        // KeyN
    u8"\u0e2e",        // KeyM
    u8"\u0e1f",        // Comma
    u8"\u0e09",        // Period
    u8"\u0e2c",        // Slash
    u8"\u0020",        // Space
};
const char* kShiftCapslock[] = {
    u8"_",       // BackQuote
    u8"=",       // Digit1
    u8"\u0e52",  // Digit2
    u8"\u0e53",  // Digit3
    u8"\u0e54",  // Digit4
    u8"\u0e55",  // Digit5
    u8"\u0e39",  // Digit6
    u8"\u0e57",  // Digit7
    u8"\u0e58",  // Digit8
    u8"\u0e59",  // Digit9
    u8"\u0e50",  // Digit0
    u8"\u0e51",  // Minus
    u8"\u0e56",  // Equal
    u8"\u0e47",  // KeyQ
    u8"\u0e15",  // KeyW
    u8"\u0e22",  // KeyE
    u8"\u0e2d",  // KeyR
    u8"\u0e23",  // KeyT
    u8"\u0e48",  // KeyY
    u8"\u0e14",  // KeyU
    u8"\u0e21",  // KeyI
    u8"\u0e27",  // KeyO
    u8"\u0e41",  // KeyP
    u8"\u0e43",  // BracketLeft
    u8"\u0e0c",  // BracketRight
    u8"\u0e3a",  // Backslash
    u8"\u0e49",  // KeyA
    u8"\u0e17",  // KeyS
    u8"\u0e07",  // KeyD
    u8"\u0e01",  // KeyF
    u8"\u0e31",  // KeyG
    u8"\u0e35",  // KeyH
    u8"\u0e32",  // KeyJ
    u8"\u0e19",  // KeyK
    u8"\u0e40",  // KeyL
    u8"\u0e44",  // Semicolon
    u8"\u0e02",  // Quote
    u8"\u0e1a",  // KeyZ
    u8"\u0e1b",  // KeyX
    u8"\u0e25",  // KeyC
    u8"\u0e2b",  // KeyV
    u8"\u0e34",  // KeyB
    u8"\u0e04",  // KeyN
    u8"\u0e2a",  // KeyM
    u8"\u0e30",  // Comma
    u8"\u0e08",  // Period
    u8"\u0e1e",  // Slash
    u8"\u0020",  // Space
};
const char* kShiftAltGrCapslock[] = {
    u8"_",       // BackQuote
    u8"=",       // Digit1
    u8"\u0e52",  // Digit2
    u8"\u0e53",  // Digit3
    u8"\u0e54",  // Digit4
    u8"\u0e55",  // Digit5
    u8"\u0e39",  // Digit6
    u8"\u0e57",  // Digit7
    u8"\u0e58",  // Digit8
    u8"\u0e59",  // Digit9
    u8"\u0e50",  // Digit0
    u8"\u0e51",  // Minus
    u8"\u0e56",  // Equal
    u8"\u0e47",  // KeyQ
    u8"\u0e15",  // KeyW
    u8"\u0e22",  // KeyE
    u8"\u0e2d",  // KeyR
    u8"\u0e23",  // KeyT
    u8"\u0e48",  // KeyY
    u8"\u0e14",  // KeyU
    u8"\u0e21",  // KeyI
    u8"\u0e27",  // KeyO
    u8"\u0e41",  // KeyP
    u8"\u0e43",  // BracketLeft
    u8"\u0e0c",  // BracketRight
    u8"\u0e3a",  // Backslash
    u8"\u0e49",  // KeyA
    u8"\u0e17",  // KeyS
    u8"\u0e07",  // KeyD
    u8"\u0e01",  // KeyF
    u8"\u0e31",  // KeyG
    u8"\u0e35",  // KeyH
    u8"\u0e32",  // KeyJ
    u8"\u0e19",  // KeyK
    u8"\u0e40",  // KeyL
    u8"\u0e44",  // Semicolon
    u8"\u0e02",  // Quote
    u8"\u0e1a",  // KeyZ
    u8"\u0e1b",  // KeyX
    u8"\u0e25",  // KeyC
    u8"\u0e2b",  // KeyV
    u8"\u0e34",  // KeyB
    u8"\u0e04",  // KeyN
    u8"\u0e2a",  // KeyM
    u8"\u0e30",  // Comma
    u8"\u0e08",  // Period
    u8"\u0e1e",  // Slash
    u8"\u0020",  // Space
};
const char** kKeyMap[8] = {
    kNormal,   kShift,         kAltGr,         kShiftAltGr,
    kCapslock, kShiftCapslock, kAltgrCapslock, kShiftAltGrCapslock};

}  // namespace th_pattajoti
