/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.dir;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.dir.DirectoryStreamScoped;
import org.cryptomator.cryptofs.dir.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DirectoryStreamScoped
class BrokenDirectoryFilter {
    private static final Logger LOG = LoggerFactory.getLogger(BrokenDirectoryFilter.class);
    private final CryptoPathMapper cryptoPathMapper;

    @Inject
    public BrokenDirectoryFilter(CryptoPathMapper cryptoPathMapper) {
        this.cryptoPathMapper = cryptoPathMapper;
    }

    public Stream<Node> process(Node node) {
        Path dirFile = node.ciphertextPath.resolve("dir.c9r");
        if (Files.isRegularFile(dirFile, new LinkOption[0])) {
            Path dirPath;
            try {
                dirPath = this.cryptoPathMapper.resolveDirectory((Path)dirFile).path;
            }
            catch (IOException e) {
                LOG.warn("Broken directory file: " + dirFile, (Throwable)e);
                return Stream.empty();
            }
            if (!Files.isDirectory(dirPath, new LinkOption[0])) {
                LOG.warn("Broken directory file {}. Directory {} does not exist.", (Object)dirFile, (Object)dirPath);
                return Stream.empty();
            }
        }
        return Stream.of(node);
    }
}

