/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import java.nio.ByteBuffer;

public interface ByteSource {
    public static ByteSource from(ByteBuffer buffer) {
        return new ByteBufferByteSource(buffer);
    }

    public static UndefinedNoisePrefixedByteSourceWithoutBuffer undefinedNoise(long numBytes) {
        return buffer -> new UndefinedNoisePrefixedByteSource(numBytes, buffer);
    }

    public boolean hasRemaining();

    public long remaining();

    public void copyTo(ByteBuffer var1);

    public static class ByteBufferByteSource
    implements ByteSource {
        private final ByteBuffer source;

        private ByteBufferByteSource(ByteBuffer source) {
            this.source = source;
        }

        @Override
        public boolean hasRemaining() {
            return this.source.hasRemaining();
        }

        @Override
        public long remaining() {
            return this.source.remaining();
        }

        @Override
        public void copyTo(ByteBuffer target) {
            if (this.source.remaining() > target.remaining()) {
                int originalLimit = this.source.limit();
                this.source.limit(this.source.position() + target.remaining());
                target.put(this.source);
                this.source.limit(originalLimit);
            } else {
                target.put(this.source);
            }
        }
    }

    public static interface UndefinedNoisePrefixedByteSourceWithoutBuffer {
        public ByteSource followedBy(ByteBuffer var1);
    }

    public static class UndefinedNoisePrefixedByteSource
    implements ByteSource {
        private long prefixLen;
        private final ByteBuffer source;

        private UndefinedNoisePrefixedByteSource(long prefixLen, ByteBuffer source) {
            this.prefixLen = prefixLen;
            this.source = source;
        }

        @Override
        public boolean hasRemaining() {
            return this.prefixLen > 0L || this.source.hasRemaining();
        }

        @Override
        public long remaining() {
            return this.prefixLen + (long)this.source.remaining();
        }

        @Override
        public void copyTo(ByteBuffer target) {
            if (this.prefixLen > 0L) {
                this.skip(target);
            }
            if (target.hasRemaining()) {
                this.copySourceTo(target);
            }
        }

        private void skip(ByteBuffer target) {
            int n = (int)Math.min(this.prefixLen, (long)target.remaining());
            target.position(target.position() + n);
            this.prefixLen -= (long)n;
        }

        private void copySourceTo(ByteBuffer target) {
            int originalLimit = this.source.limit();
            int limit = Math.min(this.source.limit(), this.source.position() + target.remaining());
            this.source.limit(limit);
            target.put(this.source);
            this.source.limit(originalLimit);
        }
    }
}

