/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import com.nulabinc.zxcvbn.matchers.Dictionary;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.OmnibusMatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Matching {
    private static final Map<String, Map<String, Integer>> BASE_RANKED_DICTIONARIES = new HashMap<String, Map<String, Integer>>();
    protected final Map<String, Map<String, Integer>> rankedDictionaries;

    public Matching() {
        this(null);
    }

    public Matching(List<String> orderedList) {
        this(BASE_RANKED_DICTIONARIES, orderedList);
    }

    protected Matching(Map<String, Map<String, Integer>> rankedDictionaries, List<String> orderedList) {
        this.rankedDictionaries = rankedDictionaries != null ? new HashMap<String, Map<String, Integer>>(rankedDictionaries) : new HashMap<String, Map<String, Integer>>();
        Map<Object, Object> rankedUserInputs = orderedList != null && !orderedList.isEmpty() ? Matching.buildRankedDict(orderedList) : Collections.emptyMap();
        this.rankedDictionaries.put("user_inputs", rankedUserInputs);
    }

    public List<Match> omnimatch(CharSequence password) {
        return new OmnibusMatcher(this.rankedDictionaries).execute(password);
    }

    protected static Map<String, Integer> buildRankedDict(List<String> orderedList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int i = 1;
        for (String word : orderedList) {
            result.put(word, i);
            ++i;
        }
        return result;
    }

    static {
        for (Map.Entry<String, String[]> frequencyListRef : Dictionary.FREQUENCY_LISTS.entrySet()) {
            String name = frequencyListRef.getKey();
            String[] ls = frequencyListRef.getValue();
            BASE_RANKED_DICTIONARIES.put(name, Matching.buildRankedDict(Arrays.asList(ls)));
        }
    }
}

