/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.cryptomator.frontend.fuse.OpenFile;
import org.cryptomator.frontend.fuse.PerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PerAdapter
public class OpenFileFactory
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(OpenFileFactory.class);
    private final ConcurrentMap<Long, OpenFile> openFiles = new ConcurrentHashMap<Long, OpenFile>();
    private final AtomicLong fileHandleGen = new AtomicLong(1L);

    @Inject
    public OpenFileFactory() {
    }

    public long open(Path path, OpenOption ... options) throws IOException {
        return this.open(path, Sets.newHashSet((Object[])options), new FileAttribute[0]);
    }

    public long open(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        long fileHandle = this.fileHandleGen.getAndIncrement();
        OpenFile file = OpenFile.create(path, options, attrs);
        this.openFiles.put(fileHandle, file);
        LOG.trace("Opening {} {}", (Object)fileHandle, (Object)file);
        return fileHandle;
    }

    public OpenFile get(Long fileHandle) {
        return (OpenFile)this.openFiles.get(fileHandle);
    }

    public void close(long fileHandle) throws ClosedChannelException, IOException {
        OpenFile file = (OpenFile)this.openFiles.remove(fileHandle);
        if (file == null) {
            throw new ClosedChannelException();
        }
        LOG.trace("Releasing {} {}", (Object)fileHandle, (Object)file);
        file.close();
    }

    public int getOpenFileCount() {
        return this.openFiles.size();
    }

    @Override
    public synchronized void close() throws IOException {
        IOException exception = new IOException("At least one open file could not be closed.");
        Iterator it = this.openFiles.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            OpenFile openFile = (OpenFile)entry.getValue();
            LOG.warn("Closing unclosed file {}", (Object)openFile);
            try {
                openFile.close();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
            it.remove();
        }
        if (exception.getSuppressed().length > 0) {
            throw exception;
        }
    }
}

