/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.FileStore;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import javax.inject.Inject;
import javax.inject.Named;
import jnr.ffi.Pointer;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import org.cryptomator.frontend.fuse.FileAttributesUtil;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.frontend.fuse.FuseNioAdapter;
import org.cryptomator.frontend.fuse.OpenFileFactory;
import org.cryptomator.frontend.fuse.PerAdapter;
import org.cryptomator.frontend.fuse.ReadOnlyDirectoryHandler;
import org.cryptomator.frontend.fuse.ReadOnlyFileHandler;
import org.cryptomator.frontend.fuse.ReadOnlyLinkHandler;
import org.cryptomator.frontend.fuse.locks.AlreadyLockedException;
import org.cryptomator.frontend.fuse.locks.DataLock;
import org.cryptomator.frontend.fuse.locks.LockManager;
import org.cryptomator.frontend.fuse.locks.PathLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.FuseFillDir;
import ru.serce.jnrfuse.FuseStubFS;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.FuseFileInfo;
import ru.serce.jnrfuse.struct.Statvfs;

@PerAdapter
public class ReadOnlyAdapter
extends FuseStubFS
implements FuseNioAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyAdapter.class);
    private static final int BLOCKSIZE = 4096;
    protected final Path root;
    private final int maxFileNameLength;
    protected final FileStore fileStore;
    protected final LockManager lockManager;
    protected final FileNameTranscoder fileNameTranscoder;
    private final ReadOnlyDirectoryHandler dirHandler;
    private final ReadOnlyFileHandler fileHandler;
    private final ReadOnlyLinkHandler linkHandler;
    private final FileAttributesUtil attrUtil;
    private final BooleanSupplier hasOpenFiles;
    private final CountDownLatch initSignaler;

    @Inject
    public ReadOnlyAdapter(@Named(value="root") Path root, @Named(value="maxFileNameLength") int maxFileNameLength, FileNameTranscoder fileNameTranscoder, FileStore fileStore, LockManager lockManager, ReadOnlyDirectoryHandler dirHandler, ReadOnlyFileHandler fileHandler, ReadOnlyLinkHandler linkHandler, FileAttributesUtil attrUtil, OpenFileFactory fileFactory) {
        this.root = root;
        this.maxFileNameLength = maxFileNameLength;
        this.fileNameTranscoder = fileNameTranscoder;
        this.fileStore = fileStore;
        this.lockManager = lockManager;
        this.dirHandler = dirHandler;
        this.fileHandler = fileHandler;
        this.linkHandler = linkHandler;
        this.attrUtil = attrUtil;
        this.hasOpenFiles = () -> fileFactory.getOpenFileCount() != 0;
        this.initSignaler = new CountDownLatch(1);
    }

    protected Path resolvePath(String absolutePath) {
        String relativePath = CharMatcher.is((char)'/').trimLeadingFrom((CharSequence)absolutePath);
        return this.root.resolve(relativePath);
    }

    public int statfs(String path, Statvfs stbuf) {
        try {
            long total = this.fileStore.getTotalSpace();
            long avail = this.fileStore.getUsableSpace();
            long tBlocks = total / 4096L;
            long aBlocks = avail / 4096L;
            stbuf.f_bsize.set((Number)4096);
            stbuf.f_frsize.set((Number)4096);
            stbuf.f_blocks.set((Number)tBlocks);
            stbuf.f_bavail.set((Number)aBlocks);
            stbuf.f_bfree.set((Number)aBlocks);
            stbuf.f_namemax.set((Number)this.maxFileNameLength);
            LOG.trace("statfs {} ({} / {})", new Object[]{path, avail, total});
            return 0;
        }
        catch (IOException | RuntimeException e) {
            LOG.error("statfs " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    public int access(String path, int mask) {
        try {
            Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
            Set<AccessMode> accessModes = this.attrUtil.accessModeMaskToSet(mask);
            return this.checkAccess(node, accessModes);
        }
        catch (RuntimeException e) {
            LOG.error("checkAccess failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    protected int checkAccess(Path path, Set<AccessMode> requiredAccessModes) {
        return this.checkAccess(path, requiredAccessModes, EnumSet.of(AccessMode.WRITE));
    }

    protected int checkAccess(Path path, Set<AccessMode> requiredAccessModes, Set<AccessMode> deniedAccessModes) {
        try {
            if (!Collections.disjoint(requiredAccessModes, deniedAccessModes)) {
                throw new AccessDeniedException(path.toString());
            }
            path.getFileSystem().provider().checkAccess(path, (AccessMode[])Iterables.toArray(requiredAccessModes, AccessMode.class));
            return 0;
        }
        catch (NoSuchFileException e) {
            return -ErrorCodes.ENOENT();
        }
        catch (AccessDeniedException e) {
            return -ErrorCodes.EACCES();
        }
        catch (IOException e) {
            LOG.error("checkAccess failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int readlink(String path, Pointer buf, long size) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forReading();){
            DataLock dataLock = pathLock.lockDataForReading();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                int n = this.linkHandler.readlink(node, buf, size);
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException | NotLinkException e) {
            LOG.trace("readlink {} failed, node not found or not a symlink", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("readlink failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getattr(String path, FileStat stat) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forReading();
             DataLock dataLock = pathLock.lockDataForReading();){
            Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
            BasicFileAttributes attrs = this.fileStore.supportsFileAttributeView(PosixFileAttributeView.class) ? Files.readAttributes(node, PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS) : Files.readAttributes(node, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            LOG.trace("getattr {} (lastModifiedTime: {}, lastAccessTime: {}, creationTime: {}, isRegularFile: {}, isDirectory: {}, isSymbolicLink: {}, isOther: {}, size: {}, fileKey: {})", new Object[]{path, attrs.lastModifiedTime(), attrs.lastAccessTime(), attrs.creationTime(), attrs.isRegularFile(), attrs.isDirectory(), attrs.isSymbolicLink(), attrs.isOther(), attrs.size(), attrs.fileKey()});
            if (attrs.isDirectory()) {
                int n = this.dirHandler.getattr(node, attrs, stat);
                return n;
            }
            if (attrs.isRegularFile()) {
                int n = this.fileHandler.getattr(node, attrs, stat);
                return n;
            }
            if (!attrs.isSymbolicLink()) throw new NoSuchFileException("Not a supported node type: " + path);
            int n = this.linkHandler.getattr(node, attrs, stat);
            return n;
        }
        catch (NoSuchFileException e) {
            LOG.trace("getattr {} failed, node not found", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (FileSystemException e) {
            return this.getErrorCodeForGenericFileSystemException(e, "getattr " + path);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("getattr failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int readdir(String path, Pointer buf, FuseFillDir filler, @off_t long offset, FuseFileInfo fi) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forReading();){
            DataLock dataLock = pathLock.lockDataForReading();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                LOG.trace("readdir {}", (Object)path);
                int n = this.dirHandler.readdir(node, buf, filler, offset, fi);
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NotDirectoryException e) {
            LOG.error("readdir {} failed, node is not a directory.", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("readdir failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int open(String path, FuseFileInfo fi) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forReading();){
            DataLock dataLock = pathLock.lockDataForReading();
            try {
                Path node = this.resolvePath(this.fileNameTranscoder.fuseToNio(path));
                LOG.trace("open {} ({})", (Object)path, (Object)fi.fh.get());
                this.fileHandler.open(node, fi);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException e) {
            LOG.warn("open {} failed, file not found.", (Object)path);
            return -ErrorCodes.ENOENT();
        }
        catch (AccessDeniedException e) {
            LOG.warn("Attempted to open file with unsupported flags.", (Throwable)e);
            return -ErrorCodes.EROFS();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("open " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int read(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forReading();){
            DataLock dataLock = pathLock.lockDataForReading();
            try {
                LOG.trace("read {} bytes from file {} starting at {}...", new Object[]{size, path, offset});
                int read = this.fileHandler.read(buf, size, offset, fi);
                LOG.trace("read {} bytes from file {}", (Object)read, (Object)path);
                int n = read;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (ClosedChannelException e) {
            LOG.warn("read {} failed, invalid file handle {}", (Object)path, (Object)fi.fh.get());
            return -ErrorCodes.EBADF();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("read " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int release(String path, FuseFileInfo fi) {
        try (PathLock pathLock = this.lockManager.createPathLock(path).forReading();){
            DataLock dataLock = pathLock.lockDataForReading();
            try {
                LOG.trace("release {} ({})", (Object)path, (Object)fi.fh.get());
                this.fileHandler.release(fi);
                int n = 0;
                if (dataLock != null) {
                    dataLock.close();
                }
                return n;
            }
            catch (Throwable throwable) {
                if (dataLock != null) {
                    try {
                        dataLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (ClosedChannelException e) {
            LOG.warn("release {} failed, invalid file handle {}", (Object)path, (Object)fi.fh.get());
            return -ErrorCodes.EBADF();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("release " + path + " failed.", (Throwable)e);
            return -ErrorCodes.EIO();
        }
    }

    public Pointer init(Pointer p) {
        this.initSignaler.countDown();
        return p;
    }

    public void destroy(Pointer initResult) {
        try {
            this.close();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("destroy failed.", (Throwable)e);
        }
    }

    @Override
    public boolean isMounted() {
        return this.mounted.get();
    }

    @Override
    public boolean isInUse() {
        PathLock pLock = this.lockManager.createPathLock("/").tryForWriting();
        try {
            boolean bl = this.hasOpenFiles.getAsBoolean();
            if (pLock != null) {
                pLock.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (pLock != null) {
                    try {
                        pLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AlreadyLockedException e) {
                return true;
            }
        }
    }

    @Override
    public void awaitInitCall(long timeoutMillis) throws InterruptedException, TimeoutException {
        if (!this.initSignaler.await(timeoutMillis, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("fuse init() not called after " + timeoutMillis + " milliseconds.");
        }
    }

    @Override
    public void setUnmounted() {
        if (this.mounted.compareAndSet(true, false)) {
            LOG.debug("Marked file system adapter as unmounted.");
        } else {
            LOG.trace("File system adapter already unmounted.");
        }
    }

    @Override
    public void close() throws IOException {
        this.fileHandler.close();
    }

    protected int getErrorCodeForGenericFileSystemException(FileSystemException e, String opDesc) {
        String reason = Strings.nullToEmpty((String)e.getReason());
        if (reason.contains("path too long") || reason.contains("name too long")) {
            LOG.warn("{} {} failed, name too long.", (Object)opDesc);
            return -ErrorCodes.ENAMETOOLONG();
        }
        LOG.error(opDesc + " failed.", (Throwable)e);
        return -ErrorCodes.EIO();
    }
}

