/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java.structure.filesecurity;

import com.dokany.java.structure.filesecurity.Byteable;
import com.dokany.java.structure.filesecurity.SidIdentifierAuthority;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityIdentifier
implements Byteable {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityIdentifier.class);
    private final byte revision = 1;
    private SidIdentifierAuthority sidAuth;
    private List<Integer> subAuthorities;

    public SecurityIdentifier(SidIdentifierAuthority sidAuth, List<Integer> subAuthorities) {
        this.sidAuth = sidAuth;
        this.subAuthorities = new ArrayList<Integer>(0);
        if (subAuthorities != null) {
            if (subAuthorities.size() <= 15) {
                this.subAuthorities.addAll(subAuthorities);
            } else {
                LOG.warn("Number of subauthorities exceeds the limit of 15. Only taking the first 15 ones.");
                int i = 0;
                for (Integer subAuth : subAuthorities) {
                    this.subAuthorities.add(subAuth);
                    if (i >= 15) break;
                    ++i;
                }
            }
        }
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buf = ByteBuffer.allocate(this.sizeOfByteArray());
        buf.put((byte)1);
        buf.put((byte)this.subAuthorities.size());
        buf.put(this.sidAuth.toByteArray());
        for (Integer subAuth : this.subAuthorities) {
            buf.putInt(Integer.reverseBytes(subAuth));
        }
        return buf.array();
    }

    @Override
    public int sizeOfByteArray() {
        return 8 + 4 * this.subAuthorities.size();
    }

    public static SecurityIdentifier fromString(String stringSid) {
        String[] sidTokenized = stringSid.split("-");
        ArrayList<Integer> subAuths = new ArrayList<Integer>(sidTokenized.length - 3);
        SidIdentifierAuthority idAuth = SidIdentifierAuthority.fromInt(Integer.parseUnsignedInt(sidTokenized[2]));
        for (int i = 3; i < sidTokenized.length; ++i) {
            subAuths.add(Integer.parseUnsignedInt(sidTokenized[i]));
        }
        return new SecurityIdentifier(idAuth, subAuths);
    }
}

