/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.launcher;

import java.awt.Desktop;
import java.awt.desktop.OpenFilesEvent;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.cryptomator.ui.launcher.AppLaunchEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class FileOpenRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FileOpenRequestHandler.class);
    private final BlockingQueue<AppLaunchEvent> launchEventQueue;

    @Inject
    public FileOpenRequestHandler(@Named(value="launchEventQueue") BlockingQueue<AppLaunchEvent> launchEventQueue) {
        this.launchEventQueue = launchEventQueue;
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_OPEN_FILE)) {
            Desktop.getDesktop().setOpenFileHandler(this::openFiles);
        }
    }

    private void openFiles(OpenFilesEvent evt) {
        List<Path> pathsToOpen = evt.getFiles().stream().map(File::toPath).toList();
        AppLaunchEvent launchEvent = new AppLaunchEvent(AppLaunchEvent.EventType.OPEN_FILE, pathsToOpen);
        this.tryToEnqueueFileOpenRequest(launchEvent);
    }

    public void handleLaunchArgs(List<String> args) {
        this.handleLaunchArgs(FileSystems.getDefault(), args);
    }

    void handleLaunchArgs(FileSystem fs, List<String> args) {
        List<Path> pathsToOpen = args.stream().map(str -> {
            try {
                return fs.getPath((String)str, new String[0]);
            }
            catch (InvalidPathException e) {
                LOG.trace("Argument not a valid path: {}", str);
                return null;
            }
        }).filter(Objects::nonNull).toList();
        if (!pathsToOpen.isEmpty()) {
            AppLaunchEvent launchEvent = new AppLaunchEvent(AppLaunchEvent.EventType.OPEN_FILE, pathsToOpen);
            this.tryToEnqueueFileOpenRequest(launchEvent);
        }
    }

    private void tryToEnqueueFileOpenRequest(AppLaunchEvent launchEvent) {
        if (!this.launchEventQueue.offer(launchEvent)) {
            LOG.warn("Could not enqueue application launch event.", (Object)launchEvent);
        }
    }
}

