/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.logging.LoggerModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DebugMode {
    private static final Logger LOG = LoggerFactory.getLogger(DebugMode.class);
    private final Settings settings;
    private final LoggerContext context;

    @Inject
    public DebugMode(Settings settings, LoggerContext context) {
        this.settings = settings;
        this.context = context;
    }

    public void initialize() {
        this.setLogLevels(this.settings.debugMode().get());
        this.settings.debugMode().addListener(this::logLevelChanged);
    }

    private void logLevelChanged(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        this.setLogLevels(newValue);
    }

    private void setLogLevels(boolean debugMode) {
        if (debugMode) {
            this.setLogLevels(LoggerModule.DEBUG_LOG_LEVELS);
            LOG.debug("Debug mode enabled");
        } else {
            LOG.debug("Debug mode disabled");
            this.setLogLevels(LoggerModule.DEFAULT_LOG_LEVELS);
        }
    }

    private void setLogLevels(Map<String, Level> logLevels) {
        for (Map.Entry<String, Level> loglevel : logLevels.entrySet()) {
            ch.qos.logback.classic.Logger logger = this.context.getLogger(loglevel.getKey());
            logger.setLevel(loglevel.getValue());
        }
    }
}

