/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;

record Result(DiagnosticResult diagnosis, ObjectProperty<FixState> fixState) {
    public static Result create(DiagnosticResult diagnosis) {
        FixState initialState = diagnosis.getSeverity() == DiagnosticResult.Severity.WARN ? FixState.FIXABLE : FixState.NOT_FIXABLE;
        return new Result(diagnosis, (ObjectProperty<FixState>)new SimpleObjectProperty((Object)initialState));
    }

    public Observable[] observables() {
        return new Observable[]{this.fixState};
    }

    public String getDescription() {
        return this.diagnosis.toString();
    }

    public FixState getState() {
        return (FixState)((Object)this.fixState.get());
    }

    public void setState(FixState state) {
        this.fixState.set((Object)state);
    }

    static enum FixState {
        NOT_FIXABLE,
        FIXABLE,
        FIXING,
        FIXED,
        FIX_FAILED;

    }
}

