/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import com.tobiasdiez.easybind.EasyBind;
import javafx.animation.Animation;
import javafx.beans.binding.Binding;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.ui.common.Animations;
import org.cryptomator.ui.common.AutoAnimator;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.controls.FontAwesome5Icon;
import org.cryptomator.ui.controls.FontAwesome5IconView;
import org.cryptomator.ui.fxapp.FxApplication;
import org.cryptomator.ui.mainwindow.MainWindowScoped;

@MainWindowScoped
public class VaultDetailController
implements FxController {
    private final ReadOnlyObjectProperty<Vault> vault;
    private final FxApplication application;
    private final Binding<FontAwesome5Icon> glyph;
    private final BooleanBinding anyVaultSelected;
    private AutoAnimator spinAnimation;
    public FontAwesome5IconView vaultStateView;

    @Inject
    VaultDetailController(ObjectProperty<Vault> vault, FxApplication application) {
        this.vault = vault;
        this.application = application;
        this.glyph = EasyBind.select(vault).selectObject(Vault::stateProperty).map(this::getGlyphForVaultState);
        this.anyVaultSelected = vault.isNotNull();
    }

    public void initialize() {
        this.spinAnimation = AutoAnimator.animate((Animation)Animations.createDiscrete360Rotation((Node)this.vaultStateView)).onCondition((ObservableValue<Boolean>)EasyBind.select(this.vault).selectObject(Vault::stateProperty).map(VaultState.Value.PROCESSING::equals)).afterStop(() -> this.vaultStateView.setRotate(0.0)).build();
    }

    private FontAwesome5Icon getGlyphForVaultState(VaultState.Value state) {
        if (state != null) {
            return switch (state) {
                default -> throw new IncompatibleClassChangeError();
                case VaultState.Value.LOCKED -> FontAwesome5Icon.LOCK;
                case VaultState.Value.PROCESSING -> FontAwesome5Icon.SPINNER;
                case VaultState.Value.UNLOCKED -> FontAwesome5Icon.LOCK_OPEN;
                case VaultState.Value.NEEDS_MIGRATION, VaultState.Value.MISSING, VaultState.Value.ERROR -> FontAwesome5Icon.EXCLAMATION_TRIANGLE;
            };
        }
        return FontAwesome5Icon.EXCLAMATION_TRIANGLE;
    }

    @FXML
    public void revealStorageLocation() {
        this.application.getHostServices().showDocument(((Vault)this.vault.get()).getPath().toUri().toString());
    }

    public ReadOnlyObjectProperty<Vault> vaultProperty() {
        return this.vault;
    }

    public Vault getVault() {
        return (Vault)this.vault.get();
    }

    public Binding<FontAwesome5Icon> glyphProperty() {
        return this.glyph;
    }

    public FontAwesome5Icon getGlyph() {
        return (FontAwesome5Icon)((Object)this.glyph.getValue());
    }

    public BooleanBinding anyVaultSelectedProperty() {
        return this.anyVaultSelected;
    }

    public boolean isAnyVaultSelected() {
        return this.anyVaultSelected.get();
    }
}

