/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.vaultoptions;

import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.Environment;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.settings.VolumeImpl;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.WindowsDriveLetters;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.vaultoptions.VaultOptionsScoped;
import org.cryptomator.ui.vaultoptions.VaultOptionsWindow;

@VaultOptionsScoped
public class MountOptionsController
implements FxController {
    private final Stage window;
    private final Vault vault;
    private final BooleanProperty osIsWindows = new SimpleBooleanProperty(SystemUtils.IS_OS_WINDOWS);
    private final BooleanBinding webDavAndWindows;
    private final WindowsDriveLetters windowsDriveLetters;
    private final ResourceBundle resourceBundle;
    public CheckBox readOnlyCheckbox;
    public CheckBox customMountFlagsCheckbox;
    public TextField mountFlags;
    public ToggleGroup mountPoint;
    public RadioButton mountPointAuto;
    public RadioButton mountPointWinDriveLetter;
    public RadioButton mountPointCustomDir;
    public ChoiceBox<String> driveLetterSelection;
    private final BooleanBinding restrictToStableFuseOnWindows;

    @Inject
    MountOptionsController(@VaultOptionsWindow Stage window, @VaultOptionsWindow Vault vault, Settings settings, WindowsDriveLetters windowsDriveLetters, ResourceBundle resourceBundle, Environment environment) {
        this.window = window;
        this.vault = vault;
        this.webDavAndWindows = settings.preferredVolumeImpl().isEqualTo((Object)VolumeImpl.WEBDAV).and((ObservableBooleanValue)this.osIsWindows);
        this.windowsDriveLetters = windowsDriveLetters;
        this.resourceBundle = resourceBundle;
        BooleanBinding isFuseOnWindows = settings.preferredVolumeImpl().isEqualTo((Object)VolumeImpl.FUSE).and((ObservableBooleanValue)this.osIsWindows);
        this.restrictToStableFuseOnWindows = isFuseOnWindows.and((ObservableBooleanValue)new SimpleBooleanProperty(!environment.useExperimentalFuse()));
    }

    @FXML
    public void initialize() {
        this.readOnlyCheckbox.selectedProperty().bindBidirectional((Property)this.vault.getVaultSettings().usesReadOnlyMode());
        if (this.getRestrictToStableFuseOnWindows().booleanValue()) {
            this.readOnlyCheckbox.setSelected(false);
        }
        this.readOnlyCheckbox.disableProperty().bind((ObservableValue)this.customMountFlagsCheckbox.selectedProperty().or((ObservableBooleanValue)this.restrictToStableFuseOnWindows));
        this.mountFlags.disableProperty().bind((ObservableValue)this.customMountFlagsCheckbox.selectedProperty().not());
        this.customMountFlagsCheckbox.setSelected(this.vault.isHavingCustomMountFlags());
        if (this.vault.isHavingCustomMountFlags()) {
            this.mountFlags.textProperty().bindBidirectional((Property)this.vault.getVaultSettings().mountFlags());
            this.readOnlyCheckbox.setSelected(false);
        } else {
            this.mountFlags.textProperty().bind((ObservableValue)this.vault.defaultMountFlagsProperty());
        }
        this.mountPoint.selectedToggleProperty().addListener(this::toggleMountPoint);
        this.driveLetterSelection.getItems().addAll(this.windowsDriveLetters.getAllDriveLetters());
        this.driveLetterSelection.setConverter((StringConverter)new WinDriveLetterLabelConverter(this.windowsDriveLetters, this.resourceBundle));
        this.driveLetterSelection.setValue((Object)((String)this.vault.getVaultSettings().winDriveLetter().get()));
        if (this.vault.getVaultSettings().useCustomMountPath().get() && this.vault.getVaultSettings().getCustomMountPath().isPresent() && !this.getRestrictToStableFuseOnWindows().booleanValue()) {
            this.mountPoint.selectToggle((Toggle)this.mountPointCustomDir);
        } else if (!Strings.isNullOrEmpty((String)((String)this.vault.getVaultSettings().winDriveLetter().get()))) {
            this.mountPoint.selectToggle((Toggle)this.mountPointWinDriveLetter);
        } else {
            this.mountPoint.selectToggle((Toggle)this.mountPointAuto);
        }
        this.vault.getVaultSettings().useCustomMountPath().bind((ObservableValue)this.mountPoint.selectedToggleProperty().isEqualTo((Object)this.mountPointCustomDir));
        this.vault.getVaultSettings().winDriveLetter().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.mountPoint.selectedToggleProperty().isEqualTo((Object)this.mountPointWinDriveLetter)).then((ObservableObjectValue)this.driveLetterSelection.getSelectionModel().selectedItemProperty()).otherwise((Object)null));
    }

    @FXML
    public void toggleUseCustomMountFlags() {
        if (this.customMountFlagsCheckbox.isSelected()) {
            this.readOnlyCheckbox.setSelected(false);
            this.mountFlags.textProperty().unbind();
            this.vault.setCustomMountFlags(this.vault.defaultMountFlagsProperty().get());
            this.mountFlags.textProperty().bindBidirectional((Property)this.vault.getVaultSettings().mountFlags());
        } else {
            this.mountFlags.textProperty().unbindBidirectional((Property)this.vault.getVaultSettings().mountFlags());
            this.vault.setCustomMountFlags(null);
            this.mountFlags.textProperty().bind((ObservableValue)this.vault.defaultMountFlagsProperty());
        }
    }

    @FXML
    public void chooseCustomMountPoint() {
        this.chooseCustomMountPointOrReset((Toggle)this.mountPointCustomDir);
    }

    private void chooseCustomMountPointOrReset(Toggle previousMountToggle) {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.resourceBundle.getString("vaultOptions.mount.mountPoint.directoryPickerTitle"));
        try {
            String initialDir = this.vault.getVaultSettings().getCustomMountPath().orElse(System.getProperty("user.home"));
            directoryChooser.setInitialDirectory(Path.of(initialDir, new String[0]).toFile());
        }
        catch (InvalidPathException initialDir) {
            // empty catch block
        }
        File file = directoryChooser.showDialog((Window)this.window);
        if (file != null) {
            this.vault.getVaultSettings().customMountPath().set((Object)file.getAbsolutePath());
        } else {
            this.mountPoint.selectToggle(previousMountToggle);
        }
    }

    private void toggleMountPoint(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
        if (this.mountPointCustomDir.equals(newValue) && Strings.isNullOrEmpty((String)((String)this.vault.getVaultSettings().customMountPath().get()))) {
            this.chooseCustomMountPointOrReset(oldValue);
        }
    }

    public BooleanProperty osIsWindowsProperty() {
        return this.osIsWindows;
    }

    public boolean getOsIsWindows() {
        return this.osIsWindows.get();
    }

    public BooleanBinding webDavAndWindowsProperty() {
        return this.webDavAndWindows;
    }

    public boolean isWebDavAndWindows() {
        return this.webDavAndWindows.get();
    }

    public StringProperty customMountPathProperty() {
        return this.vault.getVaultSettings().customMountPath();
    }

    public String getCustomMountPath() {
        return (String)this.vault.getVaultSettings().customMountPath().get();
    }

    public Boolean getRestrictToStableFuseOnWindows() {
        return this.restrictToStableFuseOnWindows.get();
    }

    private static class WinDriveLetterLabelConverter
    extends StringConverter<String> {
        private final Set<String> occupiedDriveLetters;
        private final ResourceBundle resourceBundle;

        WinDriveLetterLabelConverter(WindowsDriveLetters windowsDriveLetters, ResourceBundle resourceBundle) {
            this.occupiedDriveLetters = windowsDriveLetters.getOccupiedDriveLetters();
            this.resourceBundle = resourceBundle;
        }

        public String toString(String driveLetter) {
            if (Strings.isNullOrEmpty((String)driveLetter)) {
                return "";
            }
            if (this.occupiedDriveLetters.contains(driveLetter)) {
                return driveLetter + ": (" + this.resourceBundle.getString("vaultOptions.mount.winDriveLetterOccupied") + ")";
            }
            return driveLetter + ":";
        }

        public String fromString(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

