We're proud to announce the new feature release of darktable, 3.4.0!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-3.4.0](https://github.com/darktable-org/darktable/releases/tag/release-3.4.0).

As always, please don't use the autogenerated tarball provided by
github, but only our tar.xz. the checksums are:

```
$ sha256sum darktable-3.4.0.tar.xz
??? darktable-3.4.0.tar.xz
$ sha256sum darktable-3.4.0.dmg
??? darktable-3.4.0.dmg
$ sha256sum darktable-3.4.0.exe
??? darktable-3.4.0.exe
```

When updating from the currently stable 3.2.x series, please bear in
mind that your edits will be preserved during this process, but the new
library and configuration will not be usable with 3.2.x any more, so
you are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

- Almost 2146 commits to darktable+rawspeed since 3.2
- 700 pull requests handled
- 116 issues closed

## The Big Ones

- The user manual is made available at the same time as the
  release. Note that this user manual is also the last version as a
  new project has taken over the lead on this. The goal is to have
  an up-to-date user manual by using a simpler format
  to write text for contributors.

  Current manual (multilingual):

  https://darktable.gitlab.io/doc/

  New manual (English only):

  https://darktable-org.github.io/dtdocs/

- The tethering view has been reworked and is now more stable.

- The histogram is back on the tethering view (it was disabled in 3.2
  due to lack of time)

- A new module grouping feature has been introduced. This makes the "more modules" module
  (at the bottom right of the darkroom) obsolete and this module has therefore been removed.

  The module grouping feature allows users to create their own groups
  of modules. A number of pre-defined module groups are included as presets
  (default, minimal, scene-referred, display-referred,
  all modules) as well as a new default module group tab layout (technical / grading / effects),
  which beter organizes the modules according to their purpose.

- Module masking is now enhanced for use with scene-referred workflows. A new masking implementation
  has been added, with fully unbounded blending modes, which allows parametric masking
  either in linear RGB or in JzCzHz color spaces. A boost factor slider has been
  introduced in the masking GUI so that users may set thresholding parameters above 100%
  to mask pixels in HDR images.

  JzCzHz is derived from JzAzBz, which is a perceptual color space developed
  for HDR and published in 2017, with better properties than CIE Lab from 1976,
  allowing near-perfect hue linearity, for a robust hue/saturation masking.
  A JzCzHz hue mask will produce the same output whether it is used
  before input color profile, after output color profile, or anywhere in-between,
  providing an important consistency improvement over HSL masking.

- A new color calibration module has been added as a full-featured hub for color correction.
  It was first intended as a scene-referred (unbounded) rewrite of the old channel mixer,
  allowing corrections of the color space, both for creative and corrective purposes.

  Because channel mixing is how white balancing and chromatic adaptation
  are implemented, color calibration also introduces robust chromatic adaptation transforms,
  Bradford (from ICC v4) and CAT16 (from CIECAM 2016), improving the color rendition
  of the white-balanced final image. The module provides a library of all standard
  CIE illuminants and two machine-learning illuminant detection algorithms, using
  different assumptions, for when no neutral colors can be sampled from the image,
  along with the traditional color-picker for manual sampling of neutral colors.

  Color calibration internally implements gamut-mapping and gamut-clipping,
  which attempts to preserve the hue and luminance of pixels while avoiding imaginary and
  out-of-gamut colors at the beginning of the pipeline, to improve the robustness of
  color-grading modules inside the pipeline. This is made necessary because
  white balancing will only push input out-of-gamut colors farther away,
  and will noticeably help dealing with artifical colored lights (LED, stage lighting, etc.).

  A new workflow setting "chromatic adaptation defaults", in processing preferences,
  allows users to choose to keep using the white balance module
  to perform the chromatic adaptation for new edits ("legacy" worflow, the default)
  or to use the new color calibration instead ("modern" workflow).
  The modern workflow still uses the usual white balance module, although
  with different default settings, because input color profiles and
  demosaicing need at least a rough white balancing early in the pipe.

- Map view has evolved. Images close to each other are now grouped and a count of
  grouped images is displayed on the bottom-left corner. This provides better performance
  when many images need to be shown on the map. Mouse-scrolling over a group's thumb scrolls through
  the images of the group. Groups containing selected images are highlighted with a white border.
  The image count is displayed as a white number if all images of the group are exactly at the
  same place, and in yellow otherwise.

  Movement of images within the map has also been improved. <kbd>Click</kbd> to drag the visible image,
  <kbd>Shift-Click</kbd> to drag the full group. A new "locations" module allows you to define location
  areas (using elliptical or rectangular shapes). These locations are saved as collections visible under "
  geotagging" in the collect module.

## New Features And Changes

- Some parts of the GUI have been reworked in this version to complete
  the overhaul done in previous 3.2 release to ensure seamless
  integration (color, spacing). A good example is the combo-boxes.

- A focus-peaking button has been added in the lighttable and darkroom views which
  complements the existing keyboard shortcut. Focus-peaking helps to visualize the
  depth of field in an image by materializing the sharp edges.

- Better visual feedback is provided when changing module order with drag&drop.

- The wavelet algorithm has improved performance.

- A new tooltip has been added to items in the darkroom history stack module showing
  a list of the individual parameter changes at each step. This can
  especially help to track down unintended adjustments in modules with
  many tabs, such as filmic rgb or the parametric blending
  settings. This feature was based on the under-the-hood introspection
  enhancements delivered in 3.2.

- Processing modules now have a new tooltip, accessible by hovering over their header, containing
  a summary of what they do, how they work, in which color space they operate,
  if they expect linear, non-linear, display-referred, or scene-referred
  input and what kind of output they produce. This will help users to
  build consistent pipelines when reordering modules, by exposing the
  assumptions upon which each module is built, and provides an in-app
  documentation summary accessible offline.

- Processing modules have been updated with alias names and keyword lists which are used in the module group
  search. As a result, a module search can be performed using the exact names,
  synonyms (e.g. "dehaze" for "haze removal") or features. For example searching for "saturation"
  will return all modules that can perform saturation adjustments.

- Importing pictures from memory cards no longer uses the gPhoto API. This
  should now be more stable on Windows.

- Many changes have been made to modules to allow for narrower panels.

- The bilateral filter (used in local contrast, for example) has been enhanced for better performance.

- The reset button in the history module can now be used to delete the history stack.

- <kbd>Ctrl+Clicking</kbd> on the 'compress history stack' will truncate the history without compressing it.

- The export module has new options to specify the maximum output pixel dimensions using a
  scale factor or print size (cm or inch) and DPI.

- The Filmic RGB module has new graph views to help first time users.
  These views include a default base curve view in linear and logarithmic scales,
  consistent with the base curve module, and
  a zone-system view which shows the dynamic range mapping between scene
  and display grey scales. All the views have optional legends, which can be
  toggled on for new users, and off for experienced users seeking more
  GUI real-estate.

- Changing the pixel workflow preference (none, display-referred,
  scene-referred) no longer requires a restart.

- The pixel-pipe cache can be fine-tuned for better performance.

- The white balance  module can now show colored sliders with two available
  modes: 'illuminant color' or 'effect emulation'.

- More compact combo-box displays have been added to some modules.

- In the collect module, the collection properties drop-down is now grouped
  making it easier to find the property you wish to filter on.

- Read support for 16-bit (half) float TIFFs has been added.

- The channel mixer has been deprecated (now replaced with the new color calibration module)

- The global color picker has been reworked and now comes with an enhanced
  GUI. The colors can now be displayed in LCh or HSL.

- Any user-amended preferences (those which differ from their default values) are now
  indicated with a small bullet.

- A new preference has been added to allow you to hide built-in presets.

- All modules with a list (styles, image information etc.) can be
  resized with a <kbd>Ctrl+Scroll</kbd> action.

- The history copy has been changed to include only safe
  modules. Modules like "raw white/black point" and "scale pixels" are
  no longer copied, for example. To copy such modules, use the
  "copy parts..." button. Note that the unsafe modules
  are not selected by default in the resulting dialog.

- A new exposure independent guided filter has been introduced in the
  tone equalizer module. This solves the algorithmic drawback of the
  regular guided filter (edge-aware surface blurring), that tends to
  over-smooth low-lights and under-smooth highlights. These filters
  are used by the tone equalizer to apply contrast compression globally
  on the image while not reducing the percieved acutance for local details.

- Greyscale support has been added for the AVIF format.

- The "screen DPI overwrite" and "speed/quality trade-off for
  drawing images" preferences have been combined into a single new performance mode for
  slow computers. In this mode the thumbs are computed with a lower DPI
  and use a faster drawing algorithm.

- All values in the saved preferences are checked to detect possible
  data corruptions. Preferences having a min or max are validated to
  ensure that they are in the appropriate range. Any preferences detected with
  possible data corruption are automatically reset to their default values.

- Support for AVIF >= 0.8.2 (no support for older versions).

- In order to guard against overwriting styles when exporting them,
  a dialog is shown to allow the user to confirm or abort the action.

- Output channel sliders for parametric masking are now hidden by default.

- The over-exposure warning display has been improved. As of darktable 3.2.1,
  it showed pixels for which any RGB channel value was below 0.1% or above 98%, assuming they
  would clip in the final export, which is wrong. This mode triggered a lot of
  false-positives that needlessly alarmed users who took them very seriously, but also
  showed over-saturation and over-exposure issues altogether. This comes with 4 possible modes:

  "any RGB channel" is the same as the previous "over exposure" warning.

  "luminance only" shows by default pixels darker than -12.67 EV (sRGB black point
  in 8 bits integers encoding) or brighter than 99%

  "saturation only" shows any pixel which is too saturated for its current luminance,
  meaning it is out of gamut.

  "full gamut" shows a combination of the 3 previous modes for an overall control check.

  These modes allow the user to take appropriate measures: exposure adjustments to fix luminance
  clipping or saturation adjustments to fix gamut clipping.

- A new preset has been added to the denoise (profiled) module to remove only chrominance
  noise using wavelets mode.

- Many modules have been reworked to get better performance on CPU by
  reordering and improving the OpenMP code. The modules are Liquify,
  Shadows and Highlights, Filmic RGB reconstruction, RAW Denoise, Borders, High Pass.

- The histogram has been improved for performance espcecially the log view.

## Bug fixes

- Fix orientation in the clipping module after having selected the freehand aspect ratio.

- Fix compilation issue with AVIF format support.

- Fix multiple small memory leaks.

- Fix daylight saving time in `$(EXIF_HOUR)` variable.

- Fix timestamp display on Windows (use UTF-8 format for timestamps).

- Fix many issues on the zoomable lighttable view introduced in 3.2
  with the lighttable rewrite.

- Fix possible flickering while displaying thumbnails on the lighttable.

- Fix liquify module interaction with nodes, line and curves when
  zooming and/or down-sampling is activated.

- Fix some issues with lighttable display (thumbnails) when using
  HiDPI monitor.

- Fix styles undo/redo in the darkroom.

## Notes

- The code base has been significantly simplified and refactored,
  which will make future code maintenance easier.

- Many more tests have been added to track regressions in image filter
  outputs and ensure backwards compatibility of edits. The testsuite
  counts now 77 tests and covers all the modules currently supported.

## Lua

- API changed to 6.1.0

- Button labels can now be ellipsized

- Stack widgets can now shrink and grow as panel width changes.

- A Lua Scripts Installer module now runs at startup offering to
  install the lua scripts unless they are already installed or the
  module has been disabled by the user.  The module uses the git
  executable to install the scripts so it must be present on the
  user\'s system in order for this to work.

- darktble uses Lua 5.3.  Lua 5.4 has been released and is now the
  default Lua for some distributions.  Please install the Lua 5.3
  library package if your distribution is using Lua 5.4 as the
  default.  If you compile darktable, then you may also set
  `DONT_USE_INTERNAL_LUA` to OFF in the DefineOptions.cmake file
  to use the internal Lua.

## Changed Dependencies

- Due to the current GMIC version windows users may have to rename two libraries
  in the darktable bin folder to get lut3d module working:`libopencv_code4xx` and `libopencv_videoio4xx`
  should be renamed to `libopencv_code440` and `libopencv_videoio440` respectively.

## RawSpeed changes


## Camera support, compared to 3.2.1

### Base Support

- Canon EOS REBEL T7i
- Nikon Z 5 (14bit-compressed, 12bit-compressed)
- Olympus E-M10 Mark IV
- Panasonic DC-GX7MK3 (4:3)
- Panasonic DC-S5 (3:2)
- Sony ILCE-7C
- Sony ZV-1

### White Balance Presets

- Canon EOS 200D
- Canon EOS Kiss X9
- Canon EOS Rebel SL2
- Canon EOS M5
- Canon EOS M6
- Nikon 1 V2
- Nikon Z 50
- Sony ILCE-6600

### Noise Profiles

- Panasonic DC-G90
- Panasonic DC-G91
- Panasonic DC-G95
- Panasonic DC-G99
- Ricoh GR II
- Sony NEX-5T

## Translations

- Afrikaans
- Czech
- German
- European Spanish
- Finnish
- French
- Hebrew
- Hungarian
- Italian
- Polish
- Brazilian Portuguese
- Russian
- Slovak
- Slovenian
