/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.MySQLUtils;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.utils.CommonUtils;

public class MySQLExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<MySQLCatalog, DBSSchema> {
    private static final Log log = Log.getLog(MySQLExecutionContext.class);
    private String activeDatabaseName;

    MySQLExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @NotNull
    public MySQLDataSource getDataSource() {
        return (MySQLDataSource)super.getDataSource();
    }

    @NotNull
    public MySQLExecutionContext getContextDefaults() {
        return this;
    }

    public String getActiveDatabaseName() {
        return this.activeDatabaseName;
    }

    public MySQLCatalog getDefaultCatalog() {
        return CommonUtils.isEmpty((String)this.activeDatabaseName) ? null : this.getDataSource().getCatalog(this.activeDatabaseName);
    }

    public DBSSchema getDefaultSchema() {
        return null;
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, MySQLCatalog catalog, DBSSchema schema) throws DBCException {
        if (this.activeDatabaseName != null && this.activeDatabaseName.equals(catalog.getName())) {
            return;
        }
        MySQLCatalog oldActiveDatabase = this.getDefaultCatalog();
        if (!this.setCurrentDatabase(monitor, catalog)) {
            return;
        }
        this.activeDatabaseName = catalog.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldActiveDatabase, (DBSObject)catalog);
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, DBSSchema schema) throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query active database");){
                DBPConnectionBootstrap bootstrap;
                if (useBootstrapSettings && !CommonUtils.isEmpty((String)(bootstrap = this.getBootstrapSettings()).getDefaultCatalogName())) {
                    this.setCurrentDatabaseName(monitor, bootstrap.getDefaultCatalogName());
                }
                this.activeDatabaseName = MySQLUtils.determineCurrentDatabase(session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)this);
        }
        return true;
    }

    boolean setCurrentDatabase(DBRProgressMonitor monitor, MySQLCatalog object) throws DBCException {
        if (object == null) {
            log.debug((Object)"Null current database");
            return false;
        }
        String databaseName = object.getName();
        return this.setCurrentDatabaseName(monitor, databaseName);
    }

    private boolean setCurrentDatabaseName(DBRProgressMonitor monitor, String databaseName) throws DBCException {
        block21: {
            Throwable throwable = null;
            Object var4_5 = null;
            JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active catalog");
            try {
                try {
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("use " + DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)databaseName));){
                        dbStat.execute();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
                }
                this.activeDatabaseName = databaseName;
                if (session == null) break block21;
            }
            catch (Throwable throwable4) {
                try {
                    if (session != null) {
                        session.close();
                    }
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            session.close();
        }
        return true;
    }
}

