/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolHandler;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.utils.CommonUtils;

public abstract class MySQLNativeToolHandler<SETTINGS extends AbstractNativeToolSettings<BASE_OBJECT>, BASE_OBJECT extends DBSObject, PROCESS_ARG>
extends AbstractNativeToolHandler<SETTINGS, BASE_OBJECT, PROCESS_ARG> {
    protected void setupProcessParameters(SETTINGS settings, PROCESS_ARG arg, ProcessBuilder process) {
        String userPassword = settings.getToolUserPassword();
        if (CommonUtils.isEmpty((String)userPassword)) {
            userPassword = settings.getDataSourceContainer().getActualConnectionConfiguration().getUserPassword();
        }
        if (!CommonUtils.isEmpty((String)userPassword)) {
            process.environment().put("MYSQL_PWD", userPassword);
        }
    }

    protected List<String> getMySQLToolCommandLine(AbstractNativeToolHandler<SETTINGS, BASE_OBJECT, PROCESS_ARG> handler, SETTINGS settings, PROCESS_ARG arg) throws IOException {
        String toolUserName;
        ArrayList<String> cmd = new ArrayList<String>();
        handler.fillProcessParameters(settings, arg, cmd);
        DBPConnectionConfiguration connectionInfo = settings.getDataSourceContainer().getActualConnectionConfiguration();
        cmd.add("--host=" + connectionInfo.getHostName());
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            cmd.add("--port=" + connectionInfo.getHostPort());
        }
        if (CommonUtils.isEmpty((String)(toolUserName = settings.getToolUserName()))) {
            toolUserName = settings.getDataSourceContainer().getActualConnectionConfiguration().getUserName();
        }
        if (!CommonUtils.isEmpty((String)toolUserName)) {
            cmd.add("-u");
            cmd.add(toolUserName);
        }
        return cmd;
    }
}

