/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageErrorLogs
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.errorLogs";
    private Button logsDebugEnabled;
    private TextWithOpenFile logsDebugLocation;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group groupLogs = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_debug_logs, (int)2, (int)770, (int)0);
        this.logsDebugEnabled = UIUtils.createCheckbox((Composite)groupLogs, (String)CoreMessages.pref_page_ui_general_label_enable_debug_logs, (String)CoreMessages.pref_page_ui_general_label_enable_debug_logs_tip, (boolean)false, (int)2);
        UIUtils.createControlLabel((Composite)groupLogs, (String)CoreMessages.pref_page_ui_general_label_log_file_location);
        this.logsDebugLocation = new TextWithOpenFile((Composite)groupLogs, CoreMessages.pref_page_ui_general_label_open_file_text, new String[]{"*.log", "*.txt"});
        ContentAssistUtils.installContentProposal((Control)this.logsDebugLocation.getTextControl(), (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"workspace"), GeneralUtils.variablePattern((String)"home")}));
        this.logsDebugLocation.setLayoutData((Object)new GridData(768));
        Label tipLabel = UIUtils.createLabel((Composite)groupLogs, (String)CoreMessages.pref_page_ui_general_label_options_take_effect_after_restart);
        tipLabel.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.logsDebugEnabled.setSelection(store.getBoolean("logs.debug.enabled"));
        this.logsDebugLocation.setText(store.getString("logs.debug.location"));
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("logs.debug.enabled", this.logsDebugEnabled.getSelection());
        store.setValue("logs.debug.location", this.logsDebugLocation.getText());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }
}

