/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.widgets.Display;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class TaskProcessorUI
implements DBRRunnableContext,
DBTTaskExecutionListener {
    private static final Log log = Log.getLog(TaskProcessorUI.class);
    @NotNull
    private DBTTask task;
    @NotNull
    private DBRRunnableContext staticContext;
    private long startTime;
    private boolean started;

    public TaskProcessorUI(@NotNull DBRRunnableContext staticContext, @NotNull DBTTask task) {
        this.staticContext = staticContext;
        this.task = task;
    }

    protected void runTask() throws DBException {
        throw new DBException("Empty task execute implementation");
    }

    protected boolean isShowFinalMessage() {
        return true;
    }

    @NotNull
    public DBTTask getTask() {
        return this.task;
    }

    public void executeTask() throws DBException {
        this.runTask();
    }

    public void taskStarted(@NotNull Object task) {
        this.started = true;
        this.startTime = System.currentTimeMillis();
    }

    public void taskFinished(@NotNull Object task, @Nullable Throwable error) {
        this.started = false;
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        UIUtils.asyncExec(() -> {
            Display.getCurrent().beep();
            boolean hasErrors = error != null;
            DBPPlatformUI platformUI = DBWorkbench.getPlatformUI();
            String completeMessage = String.valueOf(this.task.getType().getName()) + " task completed (" + RuntimeUtils.formatExecutionTime((long)elapsedTime) + ")";
            if (elapsedTime > platformUI.getLongOperationTimeout() * 1000L) {
                platformUI.notifyAgent(completeMessage, !hasErrors ? 1 : 4);
            }
            if (this.isShowFinalMessage() && !hasErrors) {
                DBeaverNotifications.showNotification((String)"task", (String)this.task.getName(), (String)completeMessage, (DBPMessageType)DBPMessageType.INFORMATION, null);
            } else if (error != null) {
                DBWorkbench.getPlatformUI().showError("Task error", "Task execution failed", error);
            }
        });
    }

    public void subTaskFinished(@Nullable Throwable error) {
    }

    public void run(boolean fork, boolean cancelable, DBRRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.staticContext.run(fork, cancelable, runnable);
    }
}

