/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools;

import java.io.File;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLExportSettings;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLExportWizard;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLWizardPageSettings;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

class MySQLExportWizardPageSettings
extends MySQLWizardPageSettings<MySQLExportWizard> {
    private Text outputFolderText;
    private Text outputFileText;
    private Combo methodCombo;
    private Button noCreateStatementsCheck;
    private Button addDropStatementsCheck;
    private Button disableKeysCheck;
    private Button extendedInsertsCheck;
    private Button dumpEventsCheck;
    private Button commentsCheck;
    private Button removeDefiner;
    private Button binaryInHex;
    private Button noData;

    MySQLExportWizardPageSettings(MySQLExportWizard wizard) {
        super(wizard, MySQLUIMessages.tools_db_export_wizard_page_settings_page_name);
        this.setTitle(MySQLUIMessages.tools_db_export_wizard_page_settings_page_name);
        this.setDescription(MySQLUIMessages.tools_db_export_wizard_page_settings_page_description);
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && ((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).getOutputFolder() != null;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        SelectionAdapter changeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MySQLExportWizardPageSettings.this.updateState();
            }
        };
        Group methodGroup = UIUtils.createControlGroup((Composite)composite, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_group_exe_method, (int)1, (int)768, (int)0);
        this.methodCombo = new Combo((Composite)methodGroup, 12);
        this.methodCombo.setLayoutData((Object)new GridData(768));
        this.methodCombo.add(MySQLUIMessages.tools_db_export_wizard_page_settings_combo_item_online_backup);
        this.methodCombo.add(MySQLUIMessages.tools_db_export_wizard_page_settings_combo_item_lock_tables);
        this.methodCombo.add(MySQLUIMessages.tools_db_export_wizard_page_settings_combo_item_normal);
        this.methodCombo.select(((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).getMethod().ordinal());
        this.methodCombo.addSelectionListener((SelectionListener)changeListener);
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_group_settings, (int)3, (int)768, (int)0);
        this.noCreateStatementsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_checkbox_no_create, (boolean)((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).isNoCreateStatements());
        this.noCreateStatementsCheck.addSelectionListener((SelectionListener)changeListener);
        this.addDropStatementsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_checkbox_add_drop, (boolean)((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).isAddDropStatements());
        this.addDropStatementsCheck.addSelectionListener((SelectionListener)changeListener);
        this.disableKeysCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_checkbox_disable_keys, (boolean)((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).isDisableKeys());
        this.disableKeysCheck.addSelectionListener((SelectionListener)changeListener);
        this.extendedInsertsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_checkbox_ext_inserts, (boolean)((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).isExtendedInserts());
        this.extendedInsertsCheck.addSelectionListener((SelectionListener)changeListener);
        this.dumpEventsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_checkbox_dump_events, (boolean)((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).isDumpEvents());
        this.dumpEventsCheck.addSelectionListener((SelectionListener)changeListener);
        this.commentsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_checkbox_addnl_comments, (boolean)((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).isComments());
        this.commentsCheck.addSelectionListener((SelectionListener)changeListener);
        this.removeDefiner = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_checkbox_remove_definer, (boolean)((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).isRemoveDefiner());
        this.removeDefiner.addSelectionListener((SelectionListener)changeListener);
        this.binaryInHex = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_checkbox_binary_hex, (boolean)((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).isBinariesInHex());
        this.binaryInHex.addSelectionListener((SelectionListener)changeListener);
        this.noData = UIUtils.createCheckbox((Composite)settingsGroup, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_checkbox_no_data, (boolean)((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).isNoData());
        this.noData.addSelectionListener((SelectionListener)changeListener);
        Group outputGroup = UIUtils.createControlGroup((Composite)composite, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_group_output, (int)2, (int)768, (int)0);
        this.outputFolderText = DialogUtils.createOutputFolderChooser((Composite)outputGroup, (String)MySQLUIMessages.tools_db_export_wizard_page_settings_label_out_text, e -> this.updateState());
        this.outputFileText = UIUtils.createLabelText((Composite)outputGroup, (String)"File name pattern", (String)((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).getOutputFilePattern());
        UIUtils.setContentProposalToolTip((Control)this.outputFileText, (String)"Output file name pattern", (String[])new String[]{"host", "database", "table", "date", "timestamp"});
        ContentAssistUtils.installContentProposal((Control)this.outputFileText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"host"), GeneralUtils.variablePattern((String)"database"), GeneralUtils.variablePattern((String)"table"), GeneralUtils.variablePattern((String)"date"), GeneralUtils.variablePattern((String)"timestamp")}));
        this.createExtraArgsInput((Composite)outputGroup);
        if (((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).getOutputFolder() != null) {
            this.outputFolderText.setText(((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).getOutputFolder().getAbsolutePath());
        }
        this.outputFileText.addModifyListener(e -> ((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).setOutputFilePattern(this.outputFileText.getText()));
        Composite extraGroup = UIUtils.createComposite((Composite)composite, (int)2);
        this.createSecurityGroup(extraGroup);
        ((MySQLExportWizard)this.wizard).createTaskSaveGroup(extraGroup);
        this.setControl((Control)composite);
    }

    public void saveState() {
        super.saveState();
        MySQLExportSettings settings = (MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings();
        String fileName = this.outputFolderText.getText();
        ((MySQLExportSettings)((MySQLExportWizard)this.wizard).getSettings()).setOutputFolder(CommonUtils.isEmpty((String)fileName) ? null : new File(fileName));
        settings.setOutputFilePattern(this.outputFileText.getText());
        switch (this.methodCombo.getSelectionIndex()) {
            case 0: {
                settings.setMethod(MySQLExportSettings.DumpMethod.ONLINE);
                break;
            }
            case 1: {
                settings.setMethod(MySQLExportSettings.DumpMethod.LOCK_ALL_TABLES);
                break;
            }
            default: {
                settings.setMethod(MySQLExportSettings.DumpMethod.NORMAL);
            }
        }
        settings.setNoCreateStatements(this.noCreateStatementsCheck.getSelection());
        settings.setAddDropStatements(this.addDropStatementsCheck.getSelection());
        settings.setDisableKeys(this.disableKeysCheck.getSelection());
        settings.setExtendedInserts(this.extendedInsertsCheck.getSelection());
        settings.setDumpEvents(this.dumpEventsCheck.getSelection());
        settings.setComments(this.commentsCheck.getSelection());
        settings.setRemoveDefiner(this.removeDefiner.getSelection());
        settings.setBinariesInHex(this.binaryInHex.getSelection());
        settings.setNoData(this.noData.getSelection());
    }

    protected void updateState() {
        this.saveState();
        this.getContainer().updateButtons();
    }
}

