/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.notifications;

import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeManager;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.Log;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class E4ThemeColor {
    private static final Log log = Log.getLog(E4ThemeColor.class);
    private static boolean loggedError = false;

    public static RGB getRGBFromCssString(String cssValue) {
        try {
            if (cssValue.startsWith("rgb(")) {
                String[] rgbValues;
                String rest = cssValue.substring(4, cssValue.length());
                int idx = rest.indexOf("rgb(");
                if (idx != -1) {
                    rest = rest.substring(idx + 4, rest.length());
                }
                if ((idx = rest.indexOf(")")) != -1) {
                    rest = rest.substring(0, idx);
                }
                if ((rgbValues = rest.split(",")).length == 3) {
                    return new RGB(Integer.parseInt(rgbValues[0].trim()), Integer.parseInt(rgbValues[1].trim()), Integer.parseInt(rgbValues[2].trim()));
                }
            } else if (cssValue.startsWith("#")) {
                String rest = cssValue.substring(1, cssValue.length());
                int idx = rest.indexOf("#");
                if (idx != -1) {
                    rest = rest.substring(idx + 1, rest.length());
                }
                if (rest.length() > 5) {
                    return new RGB(Integer.parseInt(rest.substring(0, 2), 16), Integer.parseInt(rest.substring(2, 4), 16), Integer.parseInt(rest.substring(4, 6), 16));
                }
            }
            throw new IllegalArgumentException("RGB: " + cssValue);
        }
        catch (IllegalArgumentException e) {
            E4ThemeColor.logOnce(e);
            return null;
        }
    }

    public static String getCssValueFromTheme(Display display, String value) {
        CSSValue cssValue;
        CSSStyleDeclaration shellStyle;
        IThemeEngine themeEngine;
        IThemeManager iThemeManager;
        BundleContext context = FrameworkUtil.getBundle(E4ThemeColor.class).getBundleContext();
        ServiceReference reference = context.getServiceReference(IThemeManager.class);
        if (reference != null && (iThemeManager = (IThemeManager)context.getService(reference)) != null && (themeEngine = iThemeManager.getEngineForDisplay(display)) != null && (shellStyle = E4ThemeColor.getStyleDeclaration(themeEngine, display)) != null && (cssValue = shellStyle.getPropertyCSSValue(value)) != null) {
            return cssValue.getCssText();
        }
        return null;
    }

    private static CSSStyleDeclaration getStyleDeclaration(IThemeEngine themeEngine, Display display) {
        Shell shell = display.getActiveShell();
        CSSStyleDeclaration shellStyle = null;
        if (shell != null) {
            shellStyle = themeEngine.getStyle((Object)shell);
        } else {
            Shell[] shellArray = display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell input = shellArray[n2];
                shellStyle = themeEngine.getStyle((Object)input);
                if (shellStyle != null) break;
                ++n2;
            }
        }
        return shellStyle;
    }

    private static void logOnce(Exception e) {
        if (!loggedError) {
            log.error((Object)e);
            loggedError = true;
        }
    }
}

