/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNodeHandler;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class EntityHyperlink
implements IHyperlink {
    private IWorkbenchSite site;
    private IRegion region;
    private DBSObjectReference reference;

    public EntityHyperlink(IWorkbenchSite site, DBSObjectReference reference, IRegion region) {
        this.site = site;
        this.reference = reference;
        this.region = region;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return DBUtils.getObjectFullName((DBPNamedObject)this.reference, (DBPEvaluationContext)DBPEvaluationContext.UI);
    }

    public void open() {
        new ObjectFinder().schedule();
    }

    private class ObjectFinder
    extends AbstractJob {
        private DBNDatabaseNode node;

        protected ObjectFinder() {
            super("Find object node by reference");
        }

        public IStatus run(DBRProgressMonitor monitor) {
            monitor.beginTask("Resolve object " + EntityHyperlink.this.reference.getName(), 1);
            try {
                try {
                    DBSObject object = EntityHyperlink.this.reference.resolveObject(monitor);
                    if (object instanceof DBSAlias) {
                        object = ((DBSAlias)object).getTargetObject(monitor);
                    }
                    this.node = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)object, (boolean)true);
                    if (this.node != null) {
                        UIUtils.asyncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                NavigatorUtils.executeNodeAction(DBXTreeNodeHandler.Action.open, ObjectFinder.this.node, (IServiceLocator)EntityHyperlink.this.site);
                            }
                        });
                    }
                }
                catch (DBException e) {
                    IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

