/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.utils.WinRegistry11;
import org.jkiss.dbeaver.utils.WinRegistry8;

public abstract class WindowsRegistry {
    public static int HKEY_CURRENT_USER = -2147483647;
    public static int HKEY_LOCAL_MACHINE = -2147483646;
    public static int REG_SUCCESS = 0;
    public static int REG_NOTFOUND = 2;
    public static int REG_ACCESSDENIED = 5;
    private static WindowsRegistry INSTANCE;

    public abstract String readString(long var1, String var3, String var4) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    public abstract Map<String, String> readStringValues(long var1, String var3) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    public abstract List<String> readStringSubKeys(long var1, String var3) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    public abstract void createKey(long var1, String var3) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    public abstract void writeStringValue(long var1, String var3, String var4, String var5) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    public abstract void deleteKey(long var1, String var3) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    public abstract void deleteValue(long var1, String var3, String var4) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    protected byte[] toCstr(String str) {
        byte[] result = new byte[str.length() + 1];
        int i = 0;
        while (i < str.length()) {
            result[i] = (byte)str.charAt(i);
            ++i;
        }
        result[str.length()] = 0;
        return result;
    }

    public static synchronized WindowsRegistry getInstance() {
        if (INSTANCE == null) {
            boolean isJava8 = System.getProperty("java.version").startsWith("1.8");
            INSTANCE = isJava8 ? new WinRegistry8() : new WinRegistry11();
        }
        return INSTANCE;
    }
}

