/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConnection;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.ext.exasol.ui.ExasolConnectionDialog;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;

public class ExasolConnectionManager
extends SQLObjectEditor<ExasolConnection, ExasolDataSource>
implements DBEObjectRenamer<ExasolConnection> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<ExasolDataSource, ExasolConnection> getObjectsCache(ExasolConnection object) {
        ExasolDataSource source = object.getDataSource();
        return source.getConnectionCache();
    }

    protected ExasolConnection createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final Object container, Object copyFrom, Map<String, Object> options) {
        return (ExasolConnection)new UITask<ExasolConnection>(){

            protected ExasolConnection runTask() {
                ExasolConnectionDialog dialog = new ExasolConnectionDialog(UIUtils.getActiveWorkbenchShell(), (ExasolDataSource)((Object)container));
                if (dialog.open() != 0) {
                    return null;
                }
                ExasolConnection con = new ExasolConnection((ExasolDataSource)((Object)container), dialog.getName(), dialog.getUrl(), dialog.getComment(), dialog.getUrl(), dialog.getPassword());
                return con;
            }
        }.execute();
    }

    private SQLDatabasePersistAction getCommentCommand(ExasolConnection con) {
        return new SQLDatabasePersistAction("Comment on Connection", String.format("COMMENT ON CONNECTION %s is '%s'", DBUtils.getQuotedIdentifier((DBSObject)con), ExasolUtils.quoteString(con.getDescription())));
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        ExasolConnection con = (ExasolConnection)command.getObject();
        StringBuilder script = new StringBuilder(String.format("CREATE CONNECTION %s TO ", DBUtils.getQuotedIdentifier((DBSObject)con)));
        script.append(" '" + ExasolUtils.quoteString(con.getConnectionString()) + "' ");
        if (!(con.getUserName().isEmpty() | con.getPassword().isEmpty())) {
            script.append(String.format("USER '%s' IDENTIFIED BY '%s'", ExasolUtils.quoteString(con.getUserName()), ExasolUtils.quoteString(con.getPassword())));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Connection", script.toString()));
        if (!con.getDescription().isEmpty()) {
            actions.add((DBEPersistAction)this.getCommentCommand(con));
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        ExasolConnection obj = (ExasolConnection)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename Connection", "RENAME CONNECTION " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        ExasolConnection con = (ExasolConnection)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop Connection", "DROP CONNECTION " + DBUtils.getQuotedIdentifier((DBSObject)con)));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        ExasolConnection con = (ExasolConnection)command.getObject();
        Map com = command.getProperties();
        if (com.containsKey("description")) {
            actionList.add((DBEPersistAction)this.getCommentCommand(con));
        }
        if (com.containsKey("url") | com.containsKey("userName") | com.containsKey("password")) {
            int result;
            if ((com.containsKey("url") | com.containsKey("userName")) & !con.getUserName().isEmpty() & con.getPassword().isEmpty() && (result = ((Integer)new UITask<Integer>(){

                protected Integer runTask() {
                    ConfirmationDialog dialog = new ConfirmationDialog(UIUtils.getActiveWorkbenchShell(), ExasolMessages.dialog_connection_alter_title, null, ExasolMessages.dialog_connection_alter_message, 5, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, ExasolMessages.dialog_general_continue, false);
                    return dialog.open();
                }
            }.execute()).intValue()) != 2) {
                throw new IllegalStateException("User abort");
            }
            StringBuilder script = new StringBuilder(String.format("ALTER CONNECTION %s ", DBUtils.getQuotedIdentifier((DBSObject)con)));
            script.append(" '" + ExasolUtils.quoteString(con.getConnectionString()) + "' ");
            if (!(con.getUserName().isEmpty() | con.getPassword().isEmpty())) {
                script.append(String.format(" USER '%s' IDENTIFIED BY '%s'", ExasolUtils.quoteString(con.getUserName()), ExasolUtils.quoteString(con.getPassword())));
            }
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("alter Connection", script.toString()));
        }
    }

    public void renameObject(DBECommandContext commandContext, ExasolConnection object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
    }
}

