/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.search.metadata;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.dbeaver.ui.search.AbstractSearchPage;
import org.jkiss.dbeaver.ui.search.internal.UISearchMessages;
import org.jkiss.dbeaver.ui.search.metadata.SearchMetadataParams;
import org.jkiss.dbeaver.ui.search.metadata.SearchMetadataQuery;
import org.jkiss.utils.CommonUtils;

public class SearchMetadataPage
extends AbstractSearchPage {
    private static final String PROP_MASK = "search.metadata.mask";
    private static final String PROP_CASE_SENSITIVE = "search.metadata.case-sensitive";
    private static final String PROP_MAX_RESULT = "search.metadata.max-results";
    private static final String PROP_MATCH_INDEX = "search.metadata.match-index";
    private static final String PROP_HISTORY = "search.metadata.history";
    private static final String PROP_OBJECT_TYPE = "search.metadata.object-type";
    private static final String PROP_SOURCES = "search.metadata.object-source";
    private Table typesTable;
    private Combo searchText;
    private DatabaseNavigatorTree dataSourceTree;
    private String nameMask;
    private boolean caseSensitive;
    private int maxResults;
    private int matchTypeIndex;
    private Set<DBSObjectType> checkedTypes = new HashSet<DBSObjectType>();
    private Set<String> searchHistory = new LinkedHashSet<String>();
    private Set<String> savedTypeNames = new HashSet<String>();
    private List<DBNNode> sourceNodes = new ArrayList<DBNNode>();
    private DBPProject currentProject = NavigatorUtils.getSelectedProject();

    public SearchMetadataPage() {
        super("Database objects search");
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.initializeDialogUnits((Control)parent);
        Composite searchGroup = new Composite(parent, 0);
        searchGroup.setLayoutData((Object)new GridData(1808));
        searchGroup.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)searchGroup);
        UIUtils.createControlLabel((Composite)searchGroup, (String)UISearchMessages.dialog_search_objects_label_object_name);
        this.searchText = new Combo(searchGroup, 4);
        this.searchText.setLayoutData((Object)new GridData(768));
        if (this.nameMask != null) {
            this.searchText.setText(this.nameMask);
        }
        for (String history : this.searchHistory) {
            this.searchText.add(history);
        }
        this.searchText.addModifyListener(e -> {
            this.nameMask = this.searchText.getText();
            this.updateEnablement();
        });
        SashForm optionsGroup = new SashForm(searchGroup, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        optionsGroup.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        optionsGroup.setLayoutData((Object)gd);
        Group sourceGroup = UIUtils.createControlGroup((Composite)optionsGroup, (String)UISearchMessages.dialog_search_objects_group_objects_source, (int)1, (int)1808, (int)0);
        gd = new GridData(1808);
        sourceGroup.setLayoutData((Object)gd);
        DBPPlatform platform = DBWorkbench.getPlatform();
        DBNProject projectNode = platform.getNavigatorModel().getRoot().getProjectNode(this.currentProject);
        DBNProjectDatabases rootNode = projectNode == null ? platform.getNavigatorModel().getRoot() : projectNode.getDatabases();
        this.dataSourceTree = new DatabaseNavigatorTree((Composite)sourceGroup, (DBNNode)rootNode, 4);
        gd = new GridData(1808);
        gd.heightHint = 300;
        this.dataSourceTree.setLayoutData((Object)gd);
        this.dataSourceTree.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof TreeNodeSpecial) {
                    return true;
                }
                if (element instanceof DBNNode) {
                    if (element instanceof DBNDatabaseFolder) {
                        DBNDatabaseFolder folder = (DBNDatabaseFolder)element;
                        Class folderItemsClass = folder.getChildrenClass();
                        return folderItemsClass != null && DBSObjectContainer.class.isAssignableFrom(folderItemsClass);
                    }
                    if (element instanceof DBNLocalFolder || element instanceof DBNProjectDatabases || element instanceof DBNDataSource || element instanceof DBSWrapper && ((DBSWrapper)element).getObject() instanceof DBSObjectContainer) {
                        return true;
                    }
                }
                return false;
            }
        });
        this.dataSourceTree.getViewer().addSelectionChangedListener(event -> {
            Object object;
            this.fillObjectTypes();
            this.updateEnablement();
            IStructuredSelection structSel = (IStructuredSelection)event.getSelection();
            Object object2 = object = structSel.isEmpty() ? null : structSel.getFirstElement();
            if (object instanceof DBNNode) {
                DBNNode node = (DBNNode)object;
                while (node != null) {
                    if (node instanceof DBNDataSource) {
                        DBNDataSource dsNode = (DBNDataSource)node;
                        dsNode.initializeNode(null, status -> {
                            if (status.isOK()) {
                                UIUtils.asyncExec(() -> {
                                    if (!this.dataSourceTree.isDisposed()) {
                                        this.fillObjectTypes();
                                    }
                                });
                            }
                        });
                        break;
                    }
                    node = node.getParentNode();
                }
            }
        });
        Group settingsGroup = UIUtils.createControlGroup((Composite)optionsGroup, (String)"Settings", (int)2, (int)1808, (int)0);
        gd = new GridData(1808);
        gd.heightHint = 300;
        settingsGroup.setLayoutData((Object)gd);
        UIUtils.createControlLabel((Composite)settingsGroup, (String)UISearchMessages.dialog_search_objects_label_name_match);
        final Combo matchCombo = new Combo((Composite)settingsGroup, 12);
        matchCombo.add(UISearchMessages.dialog_search_objects_combo_starts_with, 0);
        matchCombo.add(UISearchMessages.dialog_search_objects_combo_contains, 1);
        matchCombo.add(UISearchMessages.dialog_search_objects_combo_like, 2);
        matchCombo.select(0);
        matchCombo.setLayoutData((Object)new GridData(768));
        if (this.matchTypeIndex >= 0) {
            matchCombo.select(this.matchTypeIndex);
        }
        matchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchMetadataPage.this.matchTypeIndex = matchCombo.getSelectionIndex();
            }
        });
        matchCombo.setLayoutData((Object)new GridData(32));
        if (this.maxResults <= 0) {
            this.maxResults = 100;
        }
        Spinner maxResultsSpinner = UIUtils.createLabelSpinner((Composite)settingsGroup, (String)UISearchMessages.dialog_search_objects_spinner_max_results, (int)this.maxResults, (int)1, (int)10000);
        maxResultsSpinner.setLayoutData((Object)new GridData(768));
        maxResultsSpinner.addModifyListener(e -> {
            int n = this.maxResults = maxResultsSpinner.getSelection();
        });
        maxResultsSpinner.setLayoutData((Object)new GridData(32));
        final Button caseCheckbox = UIUtils.createLabelCheckbox((Composite)settingsGroup, (String)UISearchMessages.dialog_search_objects_case_sensitive, (boolean)this.caseSensitive);
        caseCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchMetadataPage.this.caseSensitive = caseCheckbox.getSelection();
            }
        });
        caseCheckbox.setLayoutData((Object)new GridData(768));
        Label otLabel = UIUtils.createControlLabel((Composite)settingsGroup, (String)UISearchMessages.dialog_search_objects_group_object_types);
        otLabel.setLayoutData((Object)new GridData(2));
        this.typesTable = new Table((Composite)settingsGroup, 66336);
        this.typesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] tableItemArray = SearchMetadataPage.this.typesTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    DBSObjectType objectType = (DBSObjectType)item.getData();
                    if (item.getChecked()) {
                        SearchMetadataPage.this.checkedTypes.add(objectType);
                    } else {
                        SearchMetadataPage.this.checkedTypes.remove(objectType);
                    }
                    ++n2;
                }
                SearchMetadataPage.this.updateEnablement();
            }
        });
        this.typesTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] selection = SearchMetadataPage.this.typesTable.getSelection();
                if (selection.length > 0) {
                    TableItem tableItem;
                    tableItem.setChecked(!(tableItem = selection[0]).getChecked());
                }
            }
        });
        this.typesTable.setLayoutData((Object)new GridData(1808));
        UIUtils.createTableColumn((Table)this.typesTable, (int)16384, (String)UISearchMessages.dialog_search_objects_column_type);
        UIUtils.createTableColumn((Table)this.typesTable, (int)16384, (String)UISearchMessages.dialog_search_objects_column_description);
        UIUtils.asyncExec(this::loadState);
    }

    private void loadState() {
        try {
            this.container.getRunnableContext().run(true, true, monitor -> {
                monitor.beginTask("Load database nodes", 1);
                try {
                    monitor.subTask("Load tree state");
                    this.sourceNodes = this.loadTreeState((DBRProgressMonitor)new DefaultProgressMonitor(monitor), this.currentProject, DBWorkbench.getPlatform().getPreferenceStore().getString(PROP_SOURCES));
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Data sources load", "Error loading settings", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        if (!this.sourceNodes.isEmpty()) {
            this.dataSourceTree.getViewer().setSelection((ISelection)new StructuredSelection(this.sourceNodes));
            DBNDataSource node = DBNDataSource.getDataSourceNode((DBNNode)this.sourceNodes.get(0));
            if (node != null) {
                this.dataSourceTree.getViewer().reveal((Object)node);
            }
        }
        this.updateEnablement();
    }

    private DBNNode getSelectedNode() {
        IStructuredSelection selection = (IStructuredSelection)this.dataSourceTree.getViewer().getSelection();
        if (!selection.isEmpty()) {
            return (DBNNode)selection.getFirstElement();
        }
        return null;
    }

    private DBPDataSource getSelectedDataSource() {
        DBSObject object;
        DBNNode node = this.getSelectedNode();
        if (node instanceof DBSWrapper && (object = ((DBSWrapper)node).getObject()) != null && object.getDataSource() != null) {
            return object.getDataSource();
        }
        return null;
    }

    private DBSStructureAssistant getSelectedStructureAssistant() {
        return (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)this.getSelectedDataSource());
    }

    private void fillObjectTypes() {
        int n;
        int n2;
        DBSObjectType[] dBSObjectTypeArray;
        DBSStructureAssistant assistant = this.getSelectedStructureAssistant();
        this.typesTable.removeAll();
        if (assistant != null) {
            dBSObjectTypeArray = assistant.getSupportedObjectTypes();
            n2 = dBSObjectTypeArray.length;
            n = 0;
            while (n < n2) {
                DBSObjectType objectType = dBSObjectTypeArray[n];
                TableItem item = new TableItem(this.typesTable, 0);
                item.setText(objectType.getTypeName());
                if (objectType.getImage() != null) {
                    item.setImage(0, DBeaverIcons.getImage((DBPImage)objectType.getImage()));
                }
                if (!CommonUtils.isEmpty((String)objectType.getDescription())) {
                    item.setText(1, objectType.getDescription());
                }
                item.setData((Object)objectType);
                if (this.checkedTypes.contains(objectType)) {
                    item.setChecked(true);
                } else if (this.savedTypeNames.contains(objectType.getTypeName())) {
                    item.setChecked(true);
                    this.checkedTypes.add(objectType);
                    this.savedTypeNames.remove(objectType.getTypeName());
                }
                ++n;
            }
        }
        dBSObjectTypeArray = this.typesTable.getColumns();
        n2 = dBSObjectTypeArray.length;
        n = 0;
        while (n < n2) {
            DBSObjectType column = dBSObjectTypeArray[n];
            column.pack();
            ++n;
        }
        this.updateEnablement();
    }

    @Override
    public SearchMetadataQuery createQuery() throws DBException {
        DBNNode selectedNode = this.getSelectedNode();
        DBSObjectContainer parentObject = null;
        if (selectedNode instanceof DBSWrapper && ((DBSWrapper)selectedNode).getObject() instanceof DBSObjectContainer) {
            parentObject = (DBSObjectContainer)((DBSWrapper)selectedNode).getObject();
        }
        DBPDataSource dataSource = this.getSelectedDataSource();
        DBSStructureAssistant assistant = this.getSelectedStructureAssistant();
        if (dataSource == null || assistant == null) {
            throw new IllegalStateException("No active datasource");
        }
        ArrayList<DBSObjectType> objectTypes = new ArrayList<DBSObjectType>();
        TableItem[] tableItemArray = this.typesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                objectTypes.add((DBSObjectType)item.getData());
            }
            ++n2;
        }
        String objectNameMask = this.nameMask;
        if (!this.searchHistory.contains(objectNameMask)) {
            this.searchHistory.add(objectNameMask);
            this.searchText.add(objectNameMask);
        }
        if (this.matchTypeIndex == 0) {
            if (!objectNameMask.endsWith("%")) {
                objectNameMask = String.valueOf(objectNameMask) + "%";
            }
        } else if (this.matchTypeIndex == 1) {
            if (!objectNameMask.startsWith("%")) {
                objectNameMask = "%" + objectNameMask;
            }
            if (!objectNameMask.endsWith("%")) {
                objectNameMask = String.valueOf(objectNameMask) + "%";
            }
        }
        SearchMetadataParams params = new SearchMetadataParams();
        params.setParentObject((DBSObject)parentObject);
        params.setObjectTypes(objectTypes);
        params.setObjectNameMask(objectNameMask);
        params.setCaseSensitive(this.caseSensitive);
        params.setMaxResults(this.maxResults);
        return SearchMetadataQuery.createQuery(dataSource, params);
    }

    @Override
    public void loadState(DBPPreferenceStore store) {
        String history;
        this.nameMask = store.getString(PROP_MASK);
        this.caseSensitive = store.getBoolean(PROP_CASE_SENSITIVE);
        this.maxResults = store.getInt(PROP_MAX_RESULT);
        this.matchTypeIndex = store.getInt(PROP_MATCH_INDEX);
        int i = 0;
        while (!CommonUtils.isEmpty((String)(history = store.getString("search.metadata.history." + i)))) {
            this.searchHistory.add(history);
            ++i;
        }
        String type = store.getString(PROP_OBJECT_TYPE);
        if (!CommonUtils.isEmpty((String)type)) {
            StringTokenizer st = new StringTokenizer(type, "|");
            while (st.hasMoreTokens()) {
                this.savedTypeNames.add(st.nextToken());
            }
        }
    }

    @Override
    public void saveState(DBPPreferenceStore store) {
        store.setValue(PROP_MASK, this.nameMask);
        store.setValue(PROP_CASE_SENSITIVE, this.caseSensitive);
        store.setValue(PROP_MAX_RESULT, this.maxResults);
        store.setValue(PROP_MATCH_INDEX, this.matchTypeIndex);
        SearchMetadataPage.saveTreeState(store, PROP_SOURCES, this.dataSourceTree);
        int historyIndex = 0;
        for (String history : this.searchHistory) {
            if (historyIndex >= 20) break;
            store.setValue("search.metadata.history." + historyIndex, history);
            ++historyIndex;
        }
        StringBuilder typesString = new StringBuilder();
        for (DBSObjectType type : this.checkedTypes) {
            if (typesString.length() > 0) {
                typesString.append("|");
            }
            typesString.append(type.getTypeName());
        }
        store.setValue(PROP_OBJECT_TYPE, typesString.toString());
    }

    @Override
    protected void updateEnablement() {
        boolean enabled = false;
        if (this.getSelectedDataSource() != null) {
            boolean bl = enabled = !this.checkedTypes.isEmpty();
        }
        if (CommonUtils.isEmpty((String)this.nameMask)) {
            enabled = false;
        }
        this.container.setPerformActionEnabled(enabled);
    }

    protected static void saveTreeState(DBPPreferenceStore store, String propName, DatabaseNavigatorTree tree) {
        Object[] nodes;
        StringBuilder sourcesString = new StringBuilder();
        Object[] objectArray = nodes = ((IStructuredSelection)tree.getViewer().getSelection()).toArray();
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            DBNNode node = (DBNNode)obj;
            if (sourcesString.length() > 0) {
                sourcesString.append("|");
            }
            sourcesString.append(node.getNodeItemPath());
            ++n2;
        }
        store.setValue(propName, sourcesString.toString());
    }
}

