/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.DiagramCollectSettings;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSFolder;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.utils.CommonUtils;

public class DiagramObjectCollector {
    private static final Log log = Log.getLog(DiagramObjectCollector.class);
    private final ERDDiagram diagram;
    private final List<ERDEntity> erdEntities = new ArrayList<ERDEntity>();
    private boolean showViews;
    private boolean showPartitions;

    public DiagramObjectCollector(ERDDiagram diagram) {
        this.diagram = diagram;
    }

    public static Collection<DBSEntity> collectTables(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots, DiagramCollectSettings settings, boolean forceShowViews) throws DBException {
        LinkedHashSet<DBSEntity> tables = new LinkedHashSet<DBSEntity>();
        DiagramObjectCollector.collectTables(monitor, roots, tables, settings, forceShowViews);
        return tables;
    }

    public void setShowViews(boolean showViews) {
        this.showViews = showViews;
    }

    /*
     * WARNING - void declaration
     */
    private static void collectTables(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots, Set<DBSEntity> tables, DiagramCollectSettings settings, boolean forceShowViews) throws DBException {
        boolean showPartitions = settings.isShowPartitions();
        boolean showViews = settings.isShowViews();
        for (DBSObject dBSObject : roots) {
            void var7_8;
            if (monitor.isCanceled()) break;
            DBSObject dBSObject2 = DBUtils.getPublicObject((DBSObject)dBSObject);
            if (dBSObject2 instanceof DBSAlias) {
                DBSObject dBSObject3 = ((DBSAlias)dBSObject2).getTargetObject(monitor);
            }
            if (var7_8 instanceof DBSFolder) {
                DiagramObjectCollector.collectTables(monitor, ((DBSFolder)var7_8).getChildrenObjects(monitor), tables, settings, false);
            } else if (var7_8 instanceof DBSEntity) {
                if (var7_8 instanceof DBSTablePartition && !showPartitions || DBUtils.isView((DBSEntity)((DBSEntity)var7_8)) && !showViews && !forceShowViews) continue;
                tables.add((DBSEntity)var7_8);
            }
            if (!(var7_8 instanceof DBSObjectContainer)) continue;
            DiagramObjectCollector.collectTables(monitor, (DBSObjectContainer)var7_8, tables, showViews, showPartitions);
        }
    }

    private static void collectTables(DBRProgressMonitor monitor, DBSObjectContainer container, Set<DBSEntity> tables, boolean showViews, boolean showPartitions) throws DBException {
        if (monitor.isCanceled()) {
            return;
        }
        container.cacheStructure(monitor, 7);
        Collection children = container.getChildren(monitor);
        if (!CommonUtils.isEmpty((Collection)children)) {
            Class childType = container.getPrimaryChildType(monitor);
            DBSObjectFilter objectFilter = container.getDataSource().getContainer().getObjectFilter(childType, (DBSObject)container, true);
            for (DBSObject entity : children) {
                if (monitor.isCanceled()) break;
                if (objectFilter != null && !objectFilter.matches(entity.getName())) continue;
                if (entity instanceof DBSEntity) {
                    if (entity instanceof DBSTablePartition && !showPartitions || DBUtils.isView((DBSEntity)((DBSEntity)entity)) && !showViews) continue;
                    tables.add((DBSEntity)entity);
                    continue;
                }
                if (!(entity instanceof DBSObjectContainer)) continue;
                DiagramObjectCollector.collectTables(monitor, (DBSObjectContainer)entity, tables, showViews, showPartitions);
            }
        }
    }

    public void generateDiagramObjects(DBRProgressMonitor monitor, Collection<? extends DBSObject> roots, DiagramCollectSettings settings) throws DBException {
        Collection<DBSEntity> tables = DiagramObjectCollector.collectTables(monitor, roots, settings, this.showViews);
        for (DBSEntity table : tables) {
            if (DBUtils.isHiddenObject((Object)table)) continue;
            this.addDiagramEntity(monitor, table);
        }
        for (ERDEntity erdEntity : this.erdEntities) {
            erdEntity.addModelRelations(monitor, this.diagram, true, false);
        }
    }

    private void addDiagramEntity(DBRProgressMonitor monitor, DBSEntity table) {
        if (this.diagram.containsTable(table) && !this.diagram.getContentProvider().allowEntityDuplicates()) {
            return;
        }
        ERDEntity erdEntity = ERDUtils.makeEntityFromObject(monitor, this.diagram, this.erdEntities, table, null);
        if (erdEntity != null) {
            this.erdEntities.add(erdEntity);
        }
    }

    private boolean aliasExist(String alias) {
        for (ERDEntity entity : this.erdEntities) {
            if (!CommonUtils.equalObjects((Object)entity.getAlias(), (Object)alias)) continue;
            return true;
        }
        return false;
    }

    public List<ERDEntity> getDiagramEntities() {
        return this.erdEntities;
    }

    public static List<ERDEntity> generateEntityList(DBRProgressMonitor monitor, ERDDiagram diagram, Collection<DBPNamedObject> objects, DiagramCollectSettings settings, boolean forceShowViews) {
        ArrayList<DBSObject> roots = new ArrayList<DBSObject>();
        for (DBPNamedObject object : objects) {
            if (!(object instanceof DBSObject)) continue;
            roots.add((DBSObject)object);
        }
        if (roots.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ERDEntity> entities = new ArrayList<ERDEntity>();
        monitor.beginTask("Collect diagram objects", 1);
        DiagramObjectCollector collector = new DiagramObjectCollector(diagram);
        collector.setShowViews(forceShowViews);
        try {
            DBExecUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)((DBSObject)roots.get(0)).getDataSource(), monitor1 -> {
                try {
                    collector.generateDiagramObjects((DBRProgressMonitor)monitor1, (Collection<? extends DBSObject>)roots, settings);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        entities.addAll(collector.getDiagramEntities());
        monitor.done();
        return entities;
    }
}

