/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDAttributeVisibility;
import org.jkiss.dbeaver.erd.model.ERDContainer;
import org.jkiss.dbeaver.erd.model.ERDContentProvider;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.model.ERDUtils;
import org.jkiss.dbeaver.model.DBPObjectWithLazyDescription;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.utils.CommonUtils;

public class ERDContentProviderDefault
implements ERDContentProvider {
    private static final Log log = Log.getLog(ERDContentProviderDefault.class);

    @Override
    public boolean allowEntityDuplicates() {
        return false;
    }

    @Override
    public void fillEntityFromObject(@NotNull DBRProgressMonitor monitor, @NotNull ERDDiagram diagram, List<ERDEntity> otherEntities, @NotNull ERDEntity erdEntity) {
        ERDAttributeVisibility attributeVisibility = ERDAttributeVisibility.ALL;
        this.fillEntityFromObject(monitor, erdEntity, attributeVisibility);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fillEntityFromObject(@NotNull DBRProgressMonitor monitor, ERDEntity erdEntity, ERDAttributeVisibility attributeVisibility) {
        DBSEntity entity = (DBSEntity)erdEntity.getObject();
        if (entity instanceof DBPObjectWithLazyDescription) {
            try {
                ((DBPObjectWithLazyDescription)entity).getDescription(monitor);
            }
            catch (DBException dBException) {
                log.warn((Object)"Unable to load lazy description when filling ERDEntity from object");
            }
        }
        if (attributeVisibility == ERDAttributeVisibility.NONE) return;
        HashSet<? extends DBSEntityAttribute> keyColumns = new HashSet<DBSEntityAttribute>();
        try {
            for (DBSEntityAssociation assoc : DBVUtils.getAllAssociations((DBRProgressMonitor)monitor, (DBSEntity)entity)) {
                if (!(assoc instanceof DBSEntityReferrer)) continue;
                keyColumns.addAll(DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)assoc)));
            }
            for (DBSEntityConstraint constraint : DBVUtils.getAllConstraints((DBRProgressMonitor)monitor, (DBSEntity)entity)) {
                if (!(constraint instanceof DBSEntityReferrer)) continue;
                keyColumns.addAll(DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)constraint)));
            }
        }
        catch (DBException e) {
            log.warn((Object)e);
        }
        Collection<? extends DBSEntityAttribute> idColumns = null;
        try {
            idColumns = ERDUtils.getBestTableIdentifier(monitor, entity);
            keyColumns.addAll(idColumns);
        }
        catch (DBException e) {
            log.error((Object)"Error reading table identifier", (Throwable)e);
        }
        try {
            List attributes = entity.getAttributes(monitor);
            DBSEntityAttribute firstAttr = CommonUtils.isEmpty((Collection)attributes) ? null : (DBSEntityAttribute)attributes.iterator().next();
            DBSObjectFilter columnFilter = firstAttr == null ? null : entity.getDataSource().getContainer().getObjectFilter(firstAttr.getClass(), (DBSObject)entity, false);
            if (CommonUtils.isEmpty((Collection)attributes)) return;
            block14: for (DBSEntityAttribute attribute : attributes) {
                boolean isInIdentifier;
                boolean bl = isInIdentifier = idColumns != null && idColumns.contains(attribute);
                if (!keyColumns.contains(attribute) && !this.isAttributeVisible(erdEntity, attribute) || columnFilter != null && !columnFilter.matches(attribute.getName())) continue;
                switch (attributeVisibility) {
                    case PRIMARY: {
                        if (isInIdentifier) break;
                        continue block14;
                    }
                    case KEYS: {
                        if (!keyColumns.contains(attribute)) continue block14;
                    }
                }
                boolean inPrimaryKey = idColumns != null && idColumns.contains(attribute);
                ERDEntityAttribute c1 = new ERDEntityAttribute(attribute, inPrimaryKey);
                erdEntity.addAttribute(c1, false);
            }
            return;
        }
        catch (DBException e) {
            log.debug((Object)("Can't load table '" + entity.getName() + "'attributes"), (Throwable)e);
        }
    }

    protected boolean isAttributeVisible(ERDEntity erdEntity, DBSEntityAttribute attribute) {
        if (attribute instanceof DBSEntityAssociation) {
            return false;
        }
        return !DBUtils.isHiddenObject((Object)attribute) && !DBUtils.isInheritedObject((Object)attribute);
    }

    @Override
    public ERDAssociation createAutoAssociation(ERDContainer diagram, @NotNull DBSEntityAssociation association, @NotNull ERDEntity sourceEntity, @NotNull ERDEntity targetEntity, boolean reflect) {
        return new ERDAssociation(association, sourceEntity, targetEntity, reflect);
    }
}

