/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.view;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PatternFilter;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskCategory;
import org.jkiss.dbeaver.model.task.DBTTaskManager;
import org.jkiss.dbeaver.model.task.DBTTaskReference;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.tasks.ui.view.DatabaseTaskTransfer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseTasksTree {
    private static final Log log = Log.getLog(DatabaseTasksTree.class);
    private TreeViewer taskViewer;
    private ViewerColumnController taskColumnController;
    private final List<DBTTask> allTasks = new ArrayList<DBTTask>();
    private boolean groupByProject = false;
    private boolean groupByType = false;
    private boolean groupByCategory = false;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    private final Color colorError;
    private final Color colorErrorForeground;

    public DatabaseTasksTree(Composite composite, boolean selector) {
        ColorRegistry colorRegistry = UIUtils.getActiveWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        this.colorError = colorRegistry.get("org.jkiss.dbeaver.txn.color.reverted.background");
        this.colorErrorForeground = UIUtils.getContrastColor((Color)this.colorError);
        this.taskViewer = DialogUtils.createFilteredTree((Composite)composite, (int)(0x10002 | (selector ? 2080 : 0)), (PatternFilter)new NamedObjectPatternFilter(), (String)TaskUIMessages.db_tasks_tree_text_tasks_type);
        Tree taskTree = this.taskViewer.getTree();
        taskTree.setHeaderVisible(true);
        taskTree.setLayoutData((Object)new GridData(1808));
        this.taskColumnController = new ViewerColumnController(TaskUIMessages.db_tasks_tree_column_controller_tasks, (ColumnViewer)this.taskViewer);
        this.taskColumnController.addColumn(TaskUIMessages.db_tasks_tree_column_controller_add_name, TaskUIMessages.db_tasks_tree_column_controller_add_descr_name, 16384, true, true, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBPProject) {
                    return ((DBPProject)element).getName();
                }
                if (element instanceof DBTTask) {
                    return ((DBTTask)element).getName();
                }
                return element.toString();
            }

            @Override
            protected DBPImage getCellImage(Object element) {
                if (element instanceof DBPProject) {
                    return DBIcon.PROJECT;
                }
                if (element instanceof DBTTask) {
                    return ((DBTTask)element).getType().getIcon();
                }
                if (element instanceof TaskCategoryNode) {
                    return ((TaskCategoryNode)element).category.getIcon();
                }
                if (element instanceof TaskTypeNode) {
                    return ((TaskTypeNode)element).type.getIcon();
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof DBTTask) {
                    String description = ((DBTTask)element).getDescription();
                    if (CommonUtils.isEmpty((String)description)) {
                        description = ((DBTTask)element).getName();
                    }
                    return description;
                }
                return null;
            }
        });
        this.taskColumnController.addColumn(TaskUIMessages.db_tasks_tree_column_controller_add_name_created, TaskUIMessages.db_tasks_tree_column_controller_add_descr_create_time, 16384, false, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    return dateFormat.format(((DBTTask)element).getCreateTime());
                }
                return null;
            }
        });
        this.taskColumnController.addColumn(TaskUIMessages.db_tasks_tree_column_controller_add_name_last_run, TaskUIMessages.db_tasks_tree_column_controller_add_descr_start_time, 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    DBTTaskRun lastRun = ((DBTTask)element).getLastRun();
                    if (lastRun == null) {
                        return "N/A";
                    }
                    return dateFormat.format(lastRun.getStartTime());
                }
                return null;
            }
        });
        this.taskColumnController.addColumn(TaskUIMessages.db_tasks_tree_column_controller_add_name_last_duration, TaskUIMessages.db_tasks_tree_column_controller_add_descr_run_duration, 16384, false, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    DBTTaskRun lastRun = ((DBTTask)element).getLastRun();
                    if (lastRun == null) {
                        return "N/A";
                    }
                    return RuntimeUtils.formatExecutionTime((long)lastRun.getRunDuration());
                }
                return null;
            }
        });
        this.taskColumnController.addColumn(TaskUIMessages.db_tasks_tree_column_controller_add_name_last_result, TaskUIMessages.db_tasks_tree_column_controller_add_descr_last_result, 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    DBTTaskRun lastRun = ((DBTTask)element).getLastRun();
                    if (lastRun == null) {
                        return "N/A";
                    }
                    if (lastRun.isRunSuccess()) {
                        return TaskUIMessages.db_tasks_tree_column_cell_text_success;
                    }
                    return CommonUtils.notEmpty((String)lastRun.getErrorMessage());
                }
                return null;
            }
        });
        final DBTScheduler scheduler = TaskRegistry.getInstance().getActiveSchedulerInstance();
        if (scheduler != null) {
            this.taskColumnController.addColumn(TaskUIMessages.db_tasks_tree_column_controller_add_name_next_run, TaskUIMessages.db_tasks_tree_column_controller_add_descr_next_run, 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

                @Override
                protected String getCellText(Object element) {
                    if (element instanceof DBTTask) {
                        DBTTaskScheduleInfo scheduledTask = scheduler.getScheduledTaskInfo((DBTTask)element);
                        if (scheduledTask == null) {
                            return "";
                        }
                        return scheduledTask.getNextRunInfo();
                    }
                    return null;
                }
            });
        }
        this.taskColumnController.addColumn(TaskUIMessages.db_tasks_tree_column_controller_add_name_description, TaskUIMessages.db_tasks_tree_column_controller_add_descr_task_description, 16384, false, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    return CommonUtils.notEmpty((String)((DBTTask)element).getDescription());
                }
                return null;
            }
        });
        this.taskColumnController.addColumn(TaskUIMessages.db_tasks_tree_column_controller_add_name_type, TaskUIMessages.db_tasks_tree_column_controller_add_descr_task_type, 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    return ((DBTTask)element).getType().getName();
                }
                return null;
            }
        });
        this.taskColumnController.addColumn(TaskUIMessages.db_tasks_tree_column_controller_add_name_category, TaskUIMessages.db_tasks_tree_column_controller_add_descr_category, 16384, false, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    return ((DBTTask)element).getType().getCategory().getName();
                }
                return null;
            }
        });
        this.taskColumnController.addColumn(TaskUIMessages.db_tasks_tree_column_controller_add_name_project, TaskUIMessages.db_tasks_tree_column_controller_add_descr_project, 16384, true, false, (CellLabelProvider)new TaskLabelProvider(this){

            @Override
            protected String getCellText(Object element) {
                if (element instanceof DBTTask) {
                    return ((DBTTask)element).getProject().getName();
                }
                return null;
            }
        });
        this.taskColumnController.createColumns(true);
        this.taskViewer.setContentProvider((IContentProvider)new TreeListContentProvider());
    }

    public TreeViewer getViewer() {
        return this.taskViewer;
    }

    DateFormat getDateFormat() {
        return this.dateFormat;
    }

    Color getColorError() {
        return this.colorError;
    }

    ViewerColumnController getColumnController() {
        return this.taskColumnController;
    }

    @Nullable
    public DBTTask getSelectedTask() {
        ISelection selection = this.taskViewer.getSelection();
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        return element instanceof DBTTask ? (DBTTask)element : null;
    }

    public boolean isGroupByProject() {
        return this.groupByProject;
    }

    public void setGroupByProject(boolean groupByProject) {
        this.groupByProject = groupByProject;
        this.saveViewConfig();
    }

    public boolean isGroupByType() {
        return this.groupByType;
    }

    public void setGroupByType(boolean groupByType) {
        this.groupByType = groupByType;
        this.saveViewConfig();
    }

    public boolean isGroupByCategory() {
        return this.groupByCategory;
    }

    public void setGroupByCategory(boolean groupByCategory) {
        this.groupByCategory = groupByCategory;
        this.saveViewConfig();
    }

    public void loadViewConfig() {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        this.groupByProject = preferenceStore.getBoolean("dbeaver.tasks.view.groupByProject");
        this.groupByCategory = preferenceStore.getBoolean("dbeaver.tasks.view.groupByCategory");
        this.groupByType = preferenceStore.getBoolean("dbeaver.tasks.view.groupByType");
    }

    public void saveViewConfig() {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        preferenceStore.setValue("dbeaver.tasks.view.groupByProject", this.groupByProject);
        preferenceStore.setValue("dbeaver.tasks.view.groupByCategory", this.groupByCategory);
        preferenceStore.setValue("dbeaver.tasks.view.groupByType", this.groupByType);
        try {
            preferenceStore.save();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    public void refresh() {
        this.refreshTasks();
        this.regroupTasks(false);
        if (this.refreshScheduledTasks()) {
            this.taskViewer.refresh(true);
        }
    }

    public void loadTasks() {
        this.refreshTasks();
        this.refreshScheduledTasks();
        this.regroupTasks(true);
    }

    public void regroupTasks(boolean expandAll) {
        this.taskViewer.getTree().setRedraw(false);
        try {
            ArrayList<Object> rootObjects = new ArrayList<Object>();
            if (this.groupByProject) {
                rootObjects.addAll(this.getTaskProjects(this.allTasks));
            } else if (this.groupByCategory) {
                for (DBTTaskCategory category : DatabaseTasksTree.getTaskCategories(null, null, this.allTasks)) {
                    rootObjects.add(new TaskCategoryNode(null, null, category));
                }
            } else if (this.groupByType) {
                for (DBTTaskType type : DatabaseTasksTree.getTaskTypes(null, null, this.allTasks)) {
                    rootObjects.add(new TaskTypeNode(null, null, type));
                }
            } else {
                rootObjects.addAll(this.allTasks);
            }
            this.taskViewer.setInput(rootObjects);
            if (expandAll) {
                this.taskViewer.expandAll();
            }
            this.taskColumnController.repackColumns();
        }
        finally {
            this.taskViewer.getTree().setRedraw(true);
        }
    }

    private List<DBPProject> getTaskProjects(List<DBTTask> tasks) {
        LinkedHashSet projects = new LinkedHashSet();
        tasks.forEach(task -> {
            boolean bl = projects.add(task.getProject());
        });
        return new ArrayList<DBPProject>(projects);
    }

    private static List<DBTTaskCategory> getTaskCategories(DBPProject project, DBTTaskCategory parentCategory, List<DBTTask> tasks) {
        LinkedHashSet categories = new LinkedHashSet();
        tasks.forEach(task -> {
            if (project == null || project == task.getProject()) {
                DBTTaskCategory category = task.getType().getCategory();
                while (category != null) {
                    if (parentCategory == category.getParent()) {
                        categories.add(category);
                    }
                    category = category.getParent();
                }
            }
        });
        return new ArrayList<DBTTaskCategory>(categories);
    }

    private static List<DBTTaskType> getTaskTypes(DBPProject project, DBTTaskCategory category, List<DBTTask> tasks) {
        LinkedHashSet types = new LinkedHashSet();
        tasks.forEach(task -> {
            if (!(project != null && project != task.getProject() || category != null && category != task.getType().getCategory())) {
                types.add(task.getType());
            }
        });
        ArrayList<DBTTaskType> sortedTypes = new ArrayList<DBTTaskType>(types);
        sortedTypes.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        return sortedTypes;
    }

    private void refreshTasks() {
        this.allTasks.clear();
        for (DBPProject project : DBWorkbench.getPlatform().getWorkspace().getProjects()) {
            DBTTaskManager taskManager = project.getTaskManager();
            DBTTask[] tasks = taskManager.getAllTasks();
            if (tasks.length == 0) continue;
            Collections.addAll(this.allTasks, tasks);
        }
        this.allTasks.sort(this::comparTasksTime);
    }

    private int comparTasksTime(DBTTask o1, DBTTask o2) {
        DBTTaskRun lr1 = o1.getLastRun();
        DBTTaskRun lr2 = o2.getLastRun();
        if (lr1 == null) {
            if (lr2 == null) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
            return 1;
        }
        if (lr2 == null) {
            return -1;
        }
        return lr2.getStartTime().compareTo(lr1.getStartTime());
    }

    private boolean refreshScheduledTasks() {
        DBTScheduler scheduler = TaskRegistry.getInstance().getActiveSchedulerInstance();
        if (scheduler != null) {
            try {
                UIUtils.runInProgressService(monitor -> {
                    try {
                        scheduler.refreshScheduledTasks(monitor);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Scheduled tasks", "Error reading scheduled tasks", (Throwable)e);
                return false;
            }
            catch (InterruptedException interruptedException) {}
            return true;
        }
        return false;
    }

    public List<DBTTask> getCheckedTasks() {
        ArrayList<DBTTask> tasks = new ArrayList<DBTTask>();
        TreeItem[] treeItemArray = this.taskViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.addCheckedItem(item, tasks);
            ++n2;
        }
        return tasks;
    }

    private void addCheckedItem(TreeItem item, List<DBTTask> tasks) {
        if (item.getChecked() && item.getData() instanceof DBTTask) {
            tasks.add((DBTTask)item.getData());
        }
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.addCheckedItem(child, tasks);
            ++n2;
        }
    }

    public static void addDragSourceSupport(final Viewer viewer, final IFilter draggableChecker) {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance(), DatabaseTaskTransfer.getInstance()};
        int operations = 7;
        DragSource source = new DragSource(viewer.getControl(), operations);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){
            private IStructuredSelection selection;

            public void dragStart(DragSourceEvent event) {
                this.selection = (IStructuredSelection)viewer.getSelection();
            }

            public void dragSetData(DragSourceEvent event) {
                if (!this.selection.isEmpty()) {
                    ArrayList<DBTTask> tasks = new ArrayList<DBTTask>();
                    StringBuilder buf = new StringBuilder();
                    Object[] objectArray = this.selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object nextSelected = objectArray[n2];
                        if (draggableChecker == null || draggableChecker.select(nextSelected)) {
                            DBTTask task = null;
                            if (nextSelected instanceof DBTTask) {
                                task = (DBTTask)nextSelected;
                            } else if (nextSelected instanceof DBTTaskReference) {
                                task = ((DBTTaskReference)nextSelected).getTask();
                            }
                            if (task != null) {
                                tasks.add(task);
                                String taskName = task.getName();
                                if (buf.length() > 0) {
                                    buf.append(", ");
                                }
                                buf.append(taskName);
                            }
                        }
                        ++n2;
                    }
                    if (DatabaseTaskTransfer.getInstance().isSupportedType(event.dataType)) {
                        event.data = new DatabaseTaskTransfer.Data(viewer.getControl(), tasks);
                    } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                        event.data = buf.toString();
                    }
                } else if (DatabaseTaskTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = new DatabaseTaskTransfer.Data(viewer.getControl(), Collections.emptyList());
                } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = "";
                }
            }
        });
    }

    public class NamedObjectPatternFilter
    extends PatternFilter {
        NamedObjectPatternFilter() {
            this.setIncludeLeadingWildcard(true);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            if (element instanceof DBTTask) {
                return this.wordMatches(((DBTTask)element).getName());
            }
            if (element instanceof DBTTaskRun) {
                return this.wordMatches(element.toString());
            }
            return true;
        }
    }

    private static class TaskCategoryNode {
        final DBPProject project;
        final TaskCategoryNode parent;
        final DBTTaskCategory category;

        TaskCategoryNode(DBPProject project, TaskCategoryNode parent, DBTTaskCategory category) {
            this.project = project;
            this.parent = parent;
            this.category = category;
        }

        public String toString() {
            return this.category.getName();
        }

        public int hashCode() {
            return (this.project == null ? 0 : this.project.hashCode()) + (this.parent == null ? 0 : this.parent.hashCode()) + (this.category == null ? 0 : this.category.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskCategoryNode)) {
                return false;
            }
            TaskCategoryNode cmp = (TaskCategoryNode)obj;
            return this.project == cmp.project && CommonUtils.equalObjects((Object)this.parent, (Object)cmp.parent) && this.category == cmp.category;
        }
    }

    private abstract class TaskLabelProvider
    extends ColumnLabelProvider {
        private TaskLabelProvider() {
        }

        public final void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof DBTTask) {
                DBTTaskRun lastRun = ((DBTTask)element).getLastRun();
                if (lastRun != null && !lastRun.isRunSuccess()) {
                    cell.setBackground(DatabaseTasksTree.this.colorError);
                    cell.setForeground(DatabaseTasksTree.this.colorErrorForeground);
                } else {
                    cell.setBackground(null);
                    cell.setForeground(null);
                }
            }
            cell.setText(CommonUtils.notEmpty((String)this.getCellText(element)));
            DBPImage cellImage = this.getCellImage(element);
            if (cellImage != null) {
                cell.setImage(DBeaverIcons.getImage((DBPImage)cellImage));
            }
        }

        protected DBPImage getCellImage(Object element) {
            return null;
        }

        protected abstract String getCellText(Object var1);

        public String getText(Object element) {
            return this.getCellText(element);
        }
    }

    private static class TaskTypeNode {
        final DBPProject project;
        final TaskCategoryNode parent;
        final DBTTaskType type;

        TaskTypeNode(DBPProject project, TaskCategoryNode parent, DBTTaskType type) {
            this.project = project;
            this.parent = parent;
            this.type = type;
        }

        public String toString() {
            return this.type.getName();
        }

        public int hashCode() {
            return (this.project == null ? 0 : this.project.hashCode()) + (this.parent == null ? 0 : this.parent.hashCode()) + (this.type == null ? 0 : this.type.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskTypeNode)) {
                return false;
            }
            TaskTypeNode cmp = (TaskTypeNode)obj;
            return this.project == cmp.project && CommonUtils.equalObjects((Object)this.parent, (Object)cmp.parent) && this.type == cmp.type;
        }
    }

    private class TreeListContentProvider
    implements ITreeContentProvider {
        private TreeListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<Object> children;
            block14: {
                block15: {
                    block13: {
                        children = new ArrayList<Object>();
                        if (!(parentElement instanceof DBPProject)) break block13;
                        DBPProject project = (DBPProject)parentElement;
                        if (DatabaseTasksTree.this.groupByCategory) {
                            for (DBTTaskCategory category : DatabaseTasksTree.getTaskCategories(project, null, DatabaseTasksTree.this.allTasks)) {
                                children.add(new TaskCategoryNode(project, null, category));
                            }
                        } else if (DatabaseTasksTree.this.groupByType) {
                            for (DBTTaskType type : DatabaseTasksTree.getTaskTypes(project, null, DatabaseTasksTree.this.allTasks)) {
                                children.add(new TaskTypeNode(project, null, type));
                            }
                        } else {
                            for (DBTTask task : DatabaseTasksTree.this.allTasks) {
                                if (task.getProject() != parentElement) continue;
                                children.add(task);
                            }
                        }
                        break block14;
                    }
                    if (!(parentElement instanceof TaskCategoryNode)) break block15;
                    TaskCategoryNode parentCat = (TaskCategoryNode)parentElement;
                    for (DBTTaskCategory childCat : DatabaseTasksTree.getTaskCategories(parentCat.project, parentCat.category, DatabaseTasksTree.this.allTasks)) {
                        children.add(new TaskCategoryNode(parentCat.project, parentCat, childCat));
                    }
                    if (DatabaseTasksTree.this.groupByType) {
                        for (DBTTaskType type : DatabaseTasksTree.getTaskTypes(parentCat.project, parentCat.category, DatabaseTasksTree.this.allTasks)) {
                            children.add(new TaskTypeNode(parentCat.project, parentCat, type));
                        }
                    } else {
                        for (DBTTask task : DatabaseTasksTree.this.allTasks) {
                            if (parentCat.project != null && task.getProject() != parentCat.project || task.getType().getCategory() != parentCat.category) continue;
                            children.add(task);
                        }
                    }
                    break block14;
                }
                if (!(parentElement instanceof TaskTypeNode)) break block14;
                TaskTypeNode parentType = (TaskTypeNode)parentElement;
                for (DBTTask task : DatabaseTasksTree.this.allTasks) {
                    if (parentType.project != null && task.getProject() != parentType.project || task.getType() != parentType.type) continue;
                    children.add(task);
                }
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof TaskTypeNode) {
                if (((TaskTypeNode)element).parent != null) {
                    return ((TaskTypeNode)element).parent;
                }
                return ((TaskTypeNode)element).project;
            }
            if (element instanceof TaskCategoryNode) {
                if (((TaskCategoryNode)element).parent != null) {
                    return ((TaskCategoryNode)element).parent;
                }
                return ((TaskCategoryNode)element).project;
            }
            return null;
        }

        public boolean hasChildren(Object parentElement) {
            return !(parentElement instanceof DBTTask);
        }
    }
}

