/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.ExasolSysTablePrefix;
import org.jkiss.dbeaver.ext.exasol.editors.ExasolObjectType;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolExecutionContext;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolScript;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolView;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public class ExasolStructureAssistant
extends JDBCStructureAssistant<ExasolExecutionContext> {
    private static final Log LOG = Log.getLog(ExasolStructureAssistant.class);
    private static final DBSObjectType[] SUPP_OBJ_TYPES = new DBSObjectType[]{ExasolObjectType.TABLE, ExasolObjectType.VIEW, ExasolObjectType.COLUMN, ExasolObjectType.SCHEMA, ExasolObjectType.SCRIPT, ExasolObjectType.FOREIGNKEY, ExasolObjectType.PRIMARYKEY};
    private static final DBSObjectType[] HYPER_LINKS_TYPES = new DBSObjectType[]{ExasolObjectType.TABLE, ExasolObjectType.COLUMN, ExasolObjectType.VIEW, ExasolObjectType.SCHEMA, ExasolObjectType.SCRIPT, ExasolObjectType.FOREIGNKEY, ExasolObjectType.PRIMARYKEY};
    private static final DBSObjectType[] AUTOC_OBJ_TYPES = new DBSObjectType[]{ExasolObjectType.TABLE, ExasolObjectType.VIEW, ExasolObjectType.COLUMN, ExasolObjectType.SCHEMA, ExasolObjectType.SCRIPT};
    private String sqlConstraintsAll = "/*snapshot execution*/ SELECT CONSTRAINT_SCHEMA,CONSTRAINT_TABLE, CONSTRAINT_TYPE, CONSTRAINT_NAME FROM SYS.";
    private String sqlConstraintsSchema;
    private String sqlProceduresAll = "/*snapshot execution*/ SELECT SCRIPT_SCHEMA, SCRIPT_NAME FROM SYS.";
    private String sqlProcedureSchema;
    private static final String SQL_TABLES_ALL = "/*snapshot execution*/ SELECT table_schem,table_name as column_table,table_type from \"$ODBCJDBC\".ALL_TABLES WHERE TABLE_NAME like '%s' AND TABLE_TYPE = '%s'";
    private static final String SQL_TABLES_SCHEMA = "/*snapshot execution*/ SELECT table_schem,table_name as column_table,table_type from \"$ODBCJDBC\".ALL_TABLES WHERE TABLE_SCHEM = '%s' AND TABLE_NAME LIKE '%s' AND TABLE_TYPE = '%s'";
    private static final String SQL_COLS_SCHEMA = "/*snapshot execution*/ SELECT TABLE_SCHEM,TABLE_NAME as column_table,COLUMN_NAME from \"$ODBCJDBC\".ALL_COLUMNS WHERE TABLE_SCHEM like '%s' and COLUMN_NAME LIKE '%s'";
    private ExasolDataSource dataSource;

    public ExasolStructureAssistant(ExasolDataSource dataSource) {
        this.dataSource = dataSource;
        this.sqlConstraintsAll = String.valueOf(this.sqlConstraintsAll) + dataSource.getTablePrefix(ExasolSysTablePrefix.ALL) + "_CONSTRAINTS WHERE CONSTRAINT_TYPE <> 'NOT NULL' " + " AND CONSTRAINT_NAME like '%s' AND CONSTRAINT_TYPE = '%s'";
        this.sqlConstraintsSchema = String.valueOf(this.sqlConstraintsAll) + " AND CONSTRAINT_SCHEMA = '%s'";
        this.sqlProceduresAll = String.valueOf(this.sqlProceduresAll) + dataSource.getTablePrefix(ExasolSysTablePrefix.ALL) + "_SCRIPTS WHERE SCRIPT_NAME like '%s'";
        this.sqlProcedureSchema = String.valueOf(this.sqlProceduresAll) + " AND SCRIPT_SCHEMA = '%s'";
    }

    public DBSObjectType[] getSupportedObjectTypes() {
        return SUPP_OBJ_TYPES;
    }

    public DBSObjectType[] getSearchObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    public DBSObjectType[] getHyperlinkObjectTypes() {
        return HYPER_LINKS_TYPES;
    }

    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return AUTOC_OBJ_TYPES;
    }

    @NotNull
    protected void findObjectsByMask(ExasolExecutionContext executionContext, JDBCSession session, DBSObjectType objectType, DBSObject parentObject, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults, List<DBSObjectReference> references) throws DBException, SQLException {
        ExasolSchema schema;
        LOG.debug((Object)("Search Mask:" + objectNameMask + " Object Type:" + objectType.getTypeName()));
        ExasolSchema exasolSchema = schema = parentObject instanceof ExasolSchema ? (ExasolSchema)parentObject : null;
        if (schema == null && !globalSearch) {
            schema = executionContext.getContextDefaults().getDefaultSchema();
        }
        if (objectType == ExasolObjectType.TABLE) {
            this.findTableObjectByName(session, schema, objectNameMask, maxResults, references, "TABLE");
        } else if (objectType == ExasolObjectType.VIEW) {
            this.findTableObjectByName(session, schema, objectNameMask, maxResults, references, "VIEW");
        } else if (objectType == ExasolObjectType.FOREIGNKEY) {
            this.findConstraintsByMask(session, schema, objectNameMask, maxResults, references, "FOREIGN KEY");
        } else if (objectType == ExasolObjectType.PRIMARYKEY) {
            this.findConstraintsByMask(session, schema, objectNameMask, maxResults, references, "PRIMARY KEY");
        } else if (objectType == ExasolObjectType.SCRIPT) {
            this.findProceduresByMask(session, schema, objectNameMask, maxResults, references);
        } else if (objectType == ExasolObjectType.COLUMN) {
            this.findTableColumnsByMask(session, schema, objectNameMask, maxResults, references);
        }
    }

    private void findTableColumnsByMask(JDBCSession session, final ExasolSchema schema, String objectNameMask, int maxResults, List<DBSObjectReference> references) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCStatement dbstat = session.createStatement();){
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (JDBCResultSet dbResult = dbstat.executeQuery(String.format(SQL_COLS_SCHEMA, schema == null ? "%" : ExasolUtils.quoteString(schema.getName()), ExasolUtils.quoteString(objectNameMask)));){
                int num = maxResults;
                while (dbResult.next() && num-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    final String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEM");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_TABLE");
                    String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
                    references.add((DBSObjectReference)new AbstractObjectReference(columnName, this.dataSource.getSchema(monitor, schemaName), null, ExasolTableBase.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            ExasolSchema tableSchema;
                            ExasolSchema exasolSchema = tableSchema = schema != null ? schema : ExasolStructureAssistant.this.dataSource.getSchema(monitor, schemaName);
                            if (tableSchema == null) {
                                throw new DBException("Table schema '" + schemaName + "' not found");
                            }
                            ExasolTable table = (ExasolTable)tableSchema.getTableCache().getObject(monitor, tableSchema, tableName);
                            if (table == null) {
                                ExasolView view = (ExasolView)tableSchema.getViewCache().getObject(monitor, tableSchema, tableName);
                                if (view == null) {
                                    throw new DBException("nor Table or view with name '" + tableName + "'  found in schema '" + schemaName + "'");
                                }
                                return view;
                            }
                            return table;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findProceduresByMask(JDBCSession session, final ExasolSchema schema, String objectNameMask, int maxResults, List<DBSObjectReference> references) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = "";
        sql = schema == null ? String.format(this.sqlProceduresAll, ExasolUtils.quoteString(objectNameMask)) : String.format(this.sqlProcedureSchema, ExasolUtils.quoteString(schema.getName()), ExasolUtils.quoteString(objectNameMask));
        Throwable throwable = null;
        Object var9_10 = null;
        try (JDBCStatement dbstat = session.createStatement();){
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (JDBCResultSet dbResult = dbstat.executeQuery(sql);){
                int num = maxResults;
                while (dbResult.next() && num-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    final String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCRIPT_SCHEMA");
                    final String scriptName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCRIPT_NAME");
                    references.add((DBSObjectReference)new AbstractObjectReference(scriptName, this.dataSource.getSchema(monitor, schemaName), null, ExasolScript.class, RelationalObjectType.TYPE_PROCEDURE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            ExasolSchema tableSchema;
                            ExasolSchema exasolSchema = tableSchema = schema != null ? schema : ExasolStructureAssistant.this.dataSource.getSchema(monitor, schemaName);
                            if (tableSchema == null) {
                                throw new DBException("Table schema '" + schemaName + "' not found");
                            }
                            ExasolScript script = (ExasolScript)tableSchema.scriptCache.getObject(monitor, (DBSObject)tableSchema, scriptName);
                            if (script == null) {
                                throw new DBException("Script '" + script + "'  not found in schema '" + schemaName + "'");
                            }
                            return script;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findConstraintsByMask(JDBCSession session, final ExasolSchema schema, String objectNameMask, int maxResults, List<DBSObjectReference> references, String constType) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = "";
        sql = schema == null ? String.format(this.sqlConstraintsAll, ExasolUtils.quoteString(objectNameMask), constType) : String.format(this.sqlConstraintsSchema, ExasolUtils.quoteString(schema.getName()), constType, ExasolUtils.quoteString(objectNameMask));
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCStatement dbstat = session.createStatement();){
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbstat.executeQuery(sql);){
                int num = maxResults;
                while (dbResult.next() && num-- > 0) {
                    Class classType;
                    if (monitor.isCanceled()) {
                        break;
                    }
                    final String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_SCHEMA");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_TABLE");
                    final String constName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONSTRAINT_NAME");
                    if (constType.equals("PRIMARY KEY")) {
                        classType = ExasolTableUniqueKey.class;
                    } else if (constType.equals("FOREIGN KEY")) {
                        classType = ExasolTableForeignKey.class;
                    } else {
                        throw new DBException("Unkown constraint type" + constType);
                    }
                    references.add((DBSObjectReference)new AbstractObjectReference(constName, this.dataSource.getSchema(monitor, schemaName), null, classType, RelationalObjectType.TYPE_CONSTRAINT){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            ExasolSchema tableSchema;
                            ExasolSchema exasolSchema = tableSchema = schema != null ? schema : ExasolStructureAssistant.this.dataSource.getSchema(monitor, schemaName);
                            if (tableSchema == null) {
                                throw new DBException("Table schema '" + schemaName + "' not found");
                            }
                            ExasolTable table = tableSchema.getTable(monitor, tableName);
                            if (table == null) {
                                throw new DBException("Table '" + tableName + "' not found in schema  '" + schemaName + "' not found");
                            }
                            if (classType.equals(ExasolTableForeignKey.class)) {
                                ExasolTableForeignKey foreignKey = (ExasolTableForeignKey)table.getAssociation(monitor, constName);
                                if (foreignKey == null) {
                                    throw new DBException("Foreign Key  '" + constName + "' for Table '" + tableName + "' not found in schema '" + schemaName + "'");
                                }
                                return foreignKey;
                            }
                            ExasolTableUniqueKey primaryKey = table.getConstraint(monitor, constName);
                            if (primaryKey == null) {
                                throw new DBException("Primary Key '" + constName + "' for Table '" + tableName + "' not found in schema '" + schemaName + "'");
                            }
                            return primaryKey;
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void findTableObjectByName(JDBCSession session, final ExasolSchema schema, String objectNameMask, int maxResults, List<DBSObjectReference> references, final String type) throws SQLException, DBException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String sql = "";
        sql = schema == null ? String.format(SQL_TABLES_ALL, ExasolUtils.quoteString(objectNameMask), type) : String.format(SQL_TABLES_SCHEMA, ExasolUtils.quoteString(schema.getName()), ExasolUtils.quoteString(objectNameMask), type);
        Throwable throwable = null;
        Object var10_11 = null;
        try (JDBCStatement dbstat = session.createStatement();){
            Throwable throwable2 = null;
            Object var13_16 = null;
            try (JDBCResultSet dbResult = dbstat.executeQuery(sql);){
                int num = maxResults;
                while (dbResult.next() && num-- > 0) {
                    if (monitor.isCanceled()) {
                        break;
                    }
                    final String schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_SCHEM");
                    final String tableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_TABLE");
                    references.add((DBSObjectReference)new AbstractObjectReference(tableName, this.dataSource.getSchema(monitor, schemaName), null, ExasolTableBase.class, RelationalObjectType.TYPE_TABLE_COLUMN){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            ExasolSchema tableSchema;
                            ExasolSchema exasolSchema = tableSchema = schema != null ? schema : ExasolStructureAssistant.this.dataSource.getSchema(monitor, schemaName);
                            if (tableSchema == null) {
                                throw new DBException("Table schema '" + schemaName + "' not found");
                            }
                            if (type == "VIEW") {
                                ExasolView view = (ExasolView)tableSchema.getViewCache().getObject(monitor, tableSchema, tableName);
                                if (view == null) {
                                    throw new DBException("View '" + tableName + "' not found in schema '" + schemaName + "'");
                                }
                                return view;
                            }
                            if (type == "TABLE") {
                                ExasolTable table = (ExasolTable)tableSchema.getTableCache().getObject(monitor, tableSchema, tableName);
                                if (table == null) {
                                    throw new DBException("Table '" + tableName + "' not found in schema '" + schemaName + "'");
                                }
                                return table;
                            }
                            throw new DBException("Object type " + type + " unknown");
                        }
                    });
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }
}

