/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.MenuCreator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.gis.IGeometryValueEditor;
import org.jkiss.dbeaver.ui.gis.internal.GISMessages;
import org.jkiss.dbeaver.ui.gis.panel.SetTilesAction;
import org.jkiss.dbeaver.ui.gis.registry.GeometryViewerRegistry;
import org.jkiss.dbeaver.ui.gis.registry.LeafletTilesDescriptor;

class SelectTilesAction
extends Action {
    private IGeometryValueEditor valueEditor;

    SelectTilesAction(IGeometryValueEditor valueEditor) {
        super(valueEditor.getValueSRID() == 0 ? GISMessages.panel_select_tiles_action_text_plain : GeometryViewerRegistry.getInstance().getDefaultLeafletTiles().getLabel(), 4);
        this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PICTURE));
        this.valueEditor = valueEditor;
    }

    public boolean isEnabled() {
        return this.valueEditor.getValueSRID() != 0;
    }

    public void run() {
    }

    public IMenuCreator getMenuCreator() {
        return new MenuCreator(control -> {
            MenuManager menuManager = new MenuManager();
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(manager -> {
                if (this.valueEditor.getValueSRID() != 0) {
                    for (LeafletTilesDescriptor ld : GeometryViewerRegistry.getInstance().getLeafletTiles()) {
                        menuManager.add((IAction)new SetTilesAction(this.valueEditor, ld));
                    }
                }
            });
            return menuManager;
        });
    }
}

