/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.locks.graph;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.jkiss.dbeaver.ext.ui.locks.graph.LockGraphEditPartFactory;
import org.jkiss.dbeaver.ext.ui.locks.manage.LockManagerViewer;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLock;
import org.jkiss.dbeaver.model.impl.admin.locks.LockGraph;
import org.jkiss.dbeaver.model.impl.admin.locks.LockGraphManager;

public class LockGraphicalView
extends ViewPart {
    private static final LockGraph EMPTY_GRAPH = new LockGraph(null);
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private final LockGraphManager graphManager;
    private final LockManagerViewer viewer;

    public LockGraphicalView(LockManagerViewer viewer) {
        this.viewer = viewer;
        this.graphManager = viewer.getGraphManager();
    }

    public void createPartControl(Composite parent) {
        this.setEditDomain(new DefaultEditDomain(null));
        this.setGraphicalViewer((GraphicalViewer)new ScrollingGraphicalViewer());
        this.getGraphicalViewer().createControl(parent);
        this.getGraphicalViewer().setRootEditPart((RootEditPart)new FreeformGraphicalRootEditPart());
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)new LockGraphEditPartFactory());
        this.getGraphicalViewer().setContextMenu((MenuManager)new ContextMenuProvider((EditPartViewer)this.graphicalViewer){

            public void buildContextMenu(IMenuManager menu) {
                menu.add((IAction)LockGraphicalView.this.viewer.getKillAction());
            }
        });
    }

    public void drawGraf(DBAServerLock selection) {
        LockGraph g;
        if (selection == null) {
            return;
        }
        LockGraph lockGraph = g = selection == null ? EMPTY_GRAPH : this.graphManager.getGraph(selection);
        if (g == null) {
            return;
        }
        this.getGraphicalViewer().setContents((Object)g);
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected void setEditDomain(DefaultEditDomain anEditDomain) {
        this.editDomain = anEditDomain;
    }

    public void setFocus() {
        this.getGraphicalViewer().getControl().setFocus();
    }

    protected void setGraphicalViewer(GraphicalViewer viewer) {
        this.getEditDomain().addViewer((EditPartViewer)viewer);
        this.graphicalViewer = viewer;
    }
}

