/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.binary;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.binary.BinaryClipboard;
import org.jkiss.dbeaver.ui.editors.binary.BinaryContent;
import org.jkiss.dbeaver.ui.editors.binary.BinaryTextFinder;
import org.jkiss.dbeaver.ui.editors.binary.DisplayedContent;
import org.jkiss.dbeaver.ui.editors.binary.HexManager;
import org.jkiss.dbeaver.ui.editors.binary.pref.HexPreferencesPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class HexEditControl
extends Composite {
    private static final Log log = Log.getLog(HexEditControl.class);
    public static final String CONTROL_ID = "org.jkiss.dbeaver.ui.hexEditor";
    public static final String DEFAULT_FONT_NAME = "Courier New";
    public static final FontData DEFAULT_FONT_DATA = new FontData("Courier New", 10, 0);
    static final Color COLOR_BLUE = Display.getCurrent().getSystemColor(9);
    static final Color COLOR_LIGHT_SHADOW = Display.getCurrent().getSystemColor(19);
    static final Color COLOR_NORMAL_SHADOW = Display.getCurrent().getSystemColor(18);
    static String headerRow;
    static final byte[] hexToNibble;
    static final int maxScreenResolution = 1920;
    static final int minCharSize = 5;
    static final int SET_TEXT = 0;
    static final int SHIFT_FORWARD = 1;
    static final int SHIFT_BACKWARD = 2;
    public final char[] byteToChar = new char[256];
    private boolean readOnly;
    private int charsForFileSizeAddress = 0;
    private String charset = null;
    private boolean delayedInQueue = false;
    private Runnable delayedWaiting = null;
    private boolean dragging = false;
    private int fontCharWidth = -1;
    private List<Integer> highlightRangesInScreen;
    private List<Long> mergeChangeRanges = null;
    private List<Integer> mergeHighlightRanges = null;
    private int mergeIndexChange = -2;
    private int mergeIndexHighlight = -2;
    private boolean mergeRangesIsBlue = false;
    private boolean mergeRangesIsHighlight = false;
    private int mergeRangesPosition = -1;
    private final int charsForAddress;
    private int bytesPerLine;
    private boolean caretStickToStart = false;
    private BinaryClipboard myClipboard;
    private BinaryContent content = null;
    private long endPosition = 0L;
    private BinaryTextFinder finder = null;
    private boolean isInserting = true;
    private KeyListener keyAdapter = new ControlKeyAdapter();
    private int lastFocusedTextArea;
    private long lastLocationPosition = -1L;
    private List<SelectionListener> longSelectionListeners;
    private long previousFindEnd = -1L;
    private boolean previousFindIgnoredCase = false;
    private String previousFindString = null;
    private boolean previousFindStringWasHex = false;
    private int previousLine;
    private long previousRedrawStart = -1L;
    private long startPosition = 0L;
    private long textAreasStart = -1L;
    private int upANibble = 0;
    private int numberOfLines = 16;
    private int numberOfLines_1 = this.numberOfLines - 1;
    private boolean stopSearching = false;
    private byte[] tmpRawBuffer = new byte[49152];
    private int verticalBarFactor = 0;
    private Font fontCurrent = null;
    private Font fontDefault = null;
    private GridData textGridData = null;
    private GridData previewGridData = null;
    private GC styledText1GC = null;
    private GC styledText2GC = null;
    private Text linesTextSeparator = null;
    private StyledText linesText = null;
    private StyledText hexHeaderText = null;
    private StyledText hexText = null;
    private Text previewTextSeparator = null;
    private StyledText previewText = null;
    private int defWidth = Integer.valueOf(HexPreferencesPage.getDefaultWidth());
    private Color colorText;
    private Color colorCaretLine = null;
    private Color colorHighlightText = null;

    static {
        byte[] byArray = new byte[55];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        byArray[8] = 8;
        byArray[9] = 9;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = 10;
        byArray[18] = 11;
        byArray[19] = 12;
        byArray[20] = 13;
        byArray[21] = 14;
        byArray[22] = 15;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = -1;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[48] = -1;
        byArray[49] = 10;
        byArray[50] = 11;
        byArray[51] = 12;
        byArray[52] = 13;
        byArray[53] = 14;
        byArray[54] = 15;
        hexToNibble = byArray;
        StringBuilder rowChars = new StringBuilder();
        int i = 0;
        while (i < 128) {
            rowChars.append(GeneralUtils.byteToHex[i & 0xFF]).append(' ');
            ++i;
        }
        headerRow = rowChars.toString().toUpperCase();
    }

    public HexEditControl(Composite parent, int style) {
        this(parent, style, 12, 16);
    }

    public HexEditControl(Composite parent, int style, int charsForAddress, int bytesPerLine) {
        super(parent, style | 0x200);
        this.loadSettings();
        this.readOnly = (style & 8) != 0;
        this.charsForAddress = charsForAddress;
        this.bytesPerLine = bytesPerLine;
        this.highlightRangesInScreen = new ArrayList<Integer>();
        this.myClipboard = new BinaryClipboard(parent.getDisplay());
        this.longSelectionListeners = new ArrayList<SelectionListener>();
        this.addDisposeListener(e -> {
            try {
                this.myClipboard.dispose();
            }
            catch (IOException iOException) {
                log.warn((Object)"Can't cleanup clipboard temporary data");
            }
        });
        this.initialize();
        this.lastFocusedTextArea = 1;
        this.previousLine = -1;
        UIUtils.addFocusTracker((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)CONTROL_ID, (Control)this);
    }

    private void loadSettings() {
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        this.colorCaretLine = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.hex.editor.color.caret");
        this.colorText = currentTheme.getColorRegistry().get("org.jkiss.dbeaver.hex.editor.color.text");
        this.colorHighlightText = UIUtils.getSharedColor((RGB)UIUtils.blend((RGB)this.colorText.getRGB(), (RGB)this.colorCaretLine.getRGB(), (int)50));
        this.fontDefault = currentTheme.getFontRegistry().get("org.jkiss.dbeaver.hex.editor.font.output");
    }

    public static long[] getLongSelection(SelectionEvent event) {
        return new long[]{(long)event.width << 32 | (long)event.x & 0xFFFFFFFFL, (long)event.height << 32 | (long)event.y & 0xFFFFFFFFL};
    }

    public static byte[] hexStringToByte(String hexString) {
        if ((hexString.length() & 1) == 1) {
            hexString = String.valueOf('0') + hexString;
        }
        byte[] tmp = new byte[hexString.length() / 2];
        int i = 0;
        while (i < tmp.length) {
            String hexByte = hexString.substring(i * 2, i * 2 + 2);
            tmp[i] = (byte)Integer.parseInt(hexByte, 16);
            ++i;
        }
        return tmp;
    }

    public BinaryTextFinder getFinder() {
        return this.finder;
    }

    private void composeByteToCharMap() {
        if (this.charset == null || this.previewText == null) {
            return;
        }
        CharsetDecoder decoder = Charset.forName(this.charset).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(".");
        ByteBuffer bb = ByteBuffer.allocate(1);
        CharBuffer cb = CharBuffer.allocate(1);
        int i = 0;
        while (i < 256) {
            if (i < 32 || i == 127) {
                this.byteToChar[i] = (char)(160 + i);
            } else {
                char decoded;
                bb.clear();
                bb.put((byte)i);
                bb.rewind();
                cb.clear();
                decoder.reset();
                decoder.decode(bb, cb, true);
                decoder.flush(cb);
                cb.rewind();
                this.byteToChar[i] = decoded = cb.get();
            }
            ++i;
        }
    }

    public void setCharset(String name) {
        if (CommonUtils.isEmpty((String)name)) {
            name = GeneralUtils.getDefaultFileEncoding();
        }
        this.charset = name;
        this.composeByteToCharMap();
    }

    public StyledText getHexText() {
        return this.hexText;
    }

    public StyledText getPreviewText() {
        return this.previewText;
    }

    public void redrawCaret(boolean focus) {
        this.drawUnfocusedCaret(false);
        this.setCaretsSize(focus ? !this.isInserting : this.isInserting);
        if (this.isInserting && this.upANibble != 0) {
            this.upANibble = 0;
            this.refreshCaretsPosition();
            if (focus) {
                this.setFocus();
            }
        } else {
            this.drawUnfocusedCaret(true);
        }
    }

    public void addLongSelectionListener(SelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (!this.longSelectionListeners.contains(listener)) {
            this.longSelectionListeners.add(listener);
        }
    }

    private void initialize() {
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 3;
        gridLayout1.marginHeight = 0;
        gridLayout1.verticalSpacing = 0;
        gridLayout1.horizontalSpacing = 0;
        gridLayout1.marginWidth = 0;
        this.setLayout((Layout)gridLayout1);
        FocusAdapter myFocusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                HexEditControl.this.drawUnfocusedCaret(false);
                HexEditControl.this.lastFocusedTextArea = 1;
                if (e.widget == HexEditControl.this.previewText) {
                    HexEditControl.this.lastFocusedTextArea = 2;
                }
                UIUtils.asyncExec(() -> HexEditControl.this.drawUnfocusedCaret(true));
            }
        };
        Composite linesColumn = new Composite((Composite)this, 0);
        GridLayout columnLayout = new GridLayout();
        columnLayout.marginHeight = 0;
        columnLayout.verticalSpacing = 1;
        columnLayout.horizontalSpacing = 0;
        columnLayout.marginWidth = 0;
        linesColumn.setLayout((Layout)columnLayout);
        GridData gridDataColumn = new GridData(1, 4, false, true);
        linesColumn.setLayoutData((Object)gridDataColumn);
        GridData gridDataTextSeparator = new GridData(4, 1, true, false);
        gridDataTextSeparator.widthHint = 10;
        this.linesTextSeparator = new Text(linesColumn, 2);
        this.linesTextSeparator.setEnabled(false);
        this.linesTextSeparator.setBackground(COLOR_LIGHT_SHADOW);
        this.linesTextSeparator.setLayoutData((Object)gridDataTextSeparator);
        this.linesText = new StyledText(linesColumn, 10);
        this.linesText.setEditable(false);
        this.linesText.setEnabled(false);
        this.fontCurrent = this.fontDefault;
        this.linesText.setFont(this.fontCurrent);
        GC styledTextGC = new GC((Drawable)this.linesText);
        this.fontCharWidth = styledTextGC.getFontMetrics().getAverageCharWidth();
        styledTextGC.dispose();
        GridData gridDataAddresses = new GridData(1, 4, false, true);
        gridDataAddresses.heightHint = this.numberOfLines * this.linesText.getLineHeight();
        this.linesText.setLayoutData((Object)gridDataAddresses);
        this.setAddressesGridDataWidthHint();
        this.linesText.setContent((StyledTextContent)new DisplayedContent(this.charsForAddress, this.numberOfLines));
        Composite hexColumn = new Composite((Composite)this, 0);
        GridLayout column1Layout = new GridLayout();
        column1Layout.marginHeight = 0;
        column1Layout.verticalSpacing = 1;
        column1Layout.horizontalSpacing = 0;
        column1Layout.marginWidth = 0;
        hexColumn.setLayout((Layout)column1Layout);
        GridData gridDataColumn1 = new GridData(1, 4, false, true);
        hexColumn.setLayoutData((Object)gridDataColumn1);
        Composite hexHeaderGroup = new Composite(hexColumn, 0);
        GridLayout column1HeaderLayout = new GridLayout();
        column1HeaderLayout.marginHeight = 0;
        column1HeaderLayout.marginWidth = 0;
        hexHeaderGroup.setLayout((Layout)column1HeaderLayout);
        GridData gridDataColumn1Header = new GridData(1, 1, false, false);
        hexHeaderGroup.setLayoutData((Object)gridDataColumn1Header);
        GridData gridData = new GridData();
        gridData.horizontalIndent = 1;
        this.hexHeaderText = new StyledText(hexHeaderGroup, 12);
        this.hexHeaderText.setEditable(false);
        this.hexHeaderText.setEnabled(false);
        this.hexHeaderText.setBackground(COLOR_LIGHT_SHADOW);
        this.hexHeaderText.setLayoutData((Object)gridData);
        this.hexHeaderText.setFont(this.fontCurrent);
        this.refreshHeader();
        this.hexText = new StyledText(hexColumn, 2);
        this.hexText.setFont(this.fontCurrent);
        if (this.readOnly) {
            this.hexText.setEditable(false);
        }
        this.styledText1GC = new GC((Drawable)this.hexText);
        int width = this.bytesPerLine * 3 * this.fontCharWidth;
        this.textGridData = new GridData();
        this.textGridData.horizontalIndent = 1;
        this.textGridData.verticalAlignment = 4;
        this.textGridData.widthHint = this.hexText.computeTrim((int)0, (int)0, (int)width, (int)0).width;
        this.textGridData.grabExcessVerticalSpace = true;
        this.hexText.setLayoutData((Object)this.textGridData);
        this.hexText.addKeyListener(this.keyAdapter);
        this.hexText.addFocusListener((FocusListener)myFocusAdapter);
        this.hexText.addMouseListener((MouseListener)new ControlMouseAdapter(true));
        this.hexText.addPaintListener((PaintListener)new ControlPaintAdapter(true));
        this.hexText.addTraverseListener((TraverseListener)new ControlTraverseAdapter());
        this.hexText.addVerifyKeyListener((VerifyKeyListener)new ControlVerifyKeyAdapter());
        this.hexText.setContent((StyledTextContent)new DisplayedContent(this.bytesPerLine * 3, this.numberOfLines));
        this.hexText.setDoubleClickEnabled(false);
        this.hexText.addSelectionListener((SelectionListener)new ControlSelectionAdapter(true));
        Caret defaultCaret = this.hexText.getCaret();
        Caret nonDefaultCaret = new Caret(defaultCaret.getParent(), defaultCaret.getStyle());
        nonDefaultCaret.setBounds(defaultCaret.getBounds());
        this.hexText.setCaret(nonDefaultCaret);
        UIUtils.addFocusTracker((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)CONTROL_ID, (Control)this.hexText);
        Composite previewColumn = new Composite((Composite)this, 0);
        GridLayout column2Layout = new GridLayout();
        column2Layout.marginHeight = 0;
        column2Layout.verticalSpacing = 1;
        column2Layout.horizontalSpacing = 0;
        column2Layout.marginWidth = 0;
        previewColumn.setLayout((Layout)column2Layout);
        GridData gridDataColumn2 = new GridData(4, 4, true, true);
        previewColumn.setLayoutData((Object)gridDataColumn2);
        GridData gridDataTextSeparator2 = new GridData();
        gridDataTextSeparator2.horizontalAlignment = 4;
        gridDataTextSeparator2.verticalAlignment = 4;
        gridDataTextSeparator2.grabExcessHorizontalSpace = true;
        this.previewTextSeparator = new Text(previewColumn, 2);
        this.previewTextSeparator.setEnabled(false);
        this.previewTextSeparator.setBackground(COLOR_LIGHT_SHADOW);
        this.previewTextSeparator.setLayoutData((Object)gridDataTextSeparator2);
        this.makeFirstRowSameHeight();
        this.previewText = new StyledText(previewColumn, 2);
        this.previewText.setFont(this.fontCurrent);
        if (this.readOnly) {
            this.previewText.setEditable(false);
        }
        int width2 = this.bytesPerLine * this.fontCharWidth + 1;
        this.previewGridData = new GridData();
        this.previewGridData.verticalAlignment = 4;
        this.previewGridData.widthHint = this.previewText.computeTrim((int)0, (int)0, (int)width2, (int)0).width;
        this.previewGridData.grabExcessVerticalSpace = true;
        this.previewText.setLayoutData((Object)this.previewGridData);
        this.previewText.addKeyListener(this.keyAdapter);
        this.previewText.addFocusListener((FocusListener)myFocusAdapter);
        this.previewText.addMouseListener((MouseListener)new ControlMouseAdapter(false));
        this.previewText.addPaintListener((PaintListener)new ControlPaintAdapter(false));
        this.previewText.addTraverseListener((TraverseListener)new ControlTraverseAdapter());
        this.previewText.addVerifyKeyListener((VerifyKeyListener)new ControlVerifyKeyAdapter());
        this.previewText.setContent((StyledTextContent)new DisplayedContent(this.bytesPerLine, this.numberOfLines));
        this.previewText.setDoubleClickEnabled(false);
        this.previewText.addSelectionListener((SelectionListener)new ControlSelectionAdapter(false));
        defaultCaret = this.previewText.getCaret();
        nonDefaultCaret = new Caret(defaultCaret.getParent(), defaultCaret.getStyle());
        nonDefaultCaret.setBounds(defaultCaret.getBounds());
        this.previewText.setCaret(nonDefaultCaret);
        this.styledText2GC = new GC((Drawable)this.previewText);
        this.setCharset(null);
        UIUtils.addFocusTracker((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (String)CONTROL_ID, (Control)this.previewText);
        super.setFont(this.fontCurrent);
        ScrollBar vertical = this.getVerticalBar();
        vertical.setSelection(0);
        vertical.setMinimum(0);
        vertical.setIncrement(1);
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                e.doit = false;
                long previousStart = HexEditControl.this.textAreasStart;
                HexEditControl.this.textAreasStart = ((long)HexEditControl.this.getVerticalBar().getSelection() << HexEditControl.this.verticalBarFactor) * (long)HexEditControl.this.bytesPerLine;
                if (previousStart == HexEditControl.this.textAreasStart) {
                    return;
                }
                Runnable delayed = () -> {
                    HexEditControl.this.redrawTextAreas(false);
                    HexEditControl.this.setFocus();
                    HexEditControl.this.runnableEnd();
                };
                HexEditControl.this.runnableAdd(delayed);
            }
        });
        this.updateScrollBar();
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                HexEditControl.this.setFocus();
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                HexEditControl.this.updateTextsMetrics();
            }
        });
        this.addDisposeListener(e -> {
            if (this.content != null) {
                this.content.dispose();
            }
        });
    }

    public boolean canRedo() {
        return this.content != null && this.content.canRedo();
    }

    public boolean canUndo() {
        return this.content != null && this.content.canUndo();
    }

    public void copy() {
        if (this.startPosition >= this.endPosition) {
            return;
        }
        this.myClipboard.setContents(this.content, this.startPosition, this.endPosition - this.startPosition);
    }

    StringBuilder cookAddresses(long address, int limit) {
        StringBuilder theText = new StringBuilder();
        int i = 0;
        while (i < limit) {
            boolean indenting = true;
            int j = (this.charsForAddress - 2) * 4;
            while (j > 0) {
                int nibble = (int)(address >>> j) & 0xF;
                if (nibble != 0) {
                    indenting = false;
                }
                if (indenting) {
                    if (j >= this.charsForFileSizeAddress * 4) {
                        theText.append(' ');
                    } else {
                        theText.append('0');
                    }
                } else {
                    theText.append(GeneralUtils.nibbleToHex[nibble]);
                }
                j -= 4;
            }
            theText.append(GeneralUtils.nibbleToHex[(int)address & 0xF]).append(':');
            i += this.bytesPerLine;
            address += (long)this.bytesPerLine;
        }
        return theText;
    }

    StringBuilder cookTexts(boolean isHexOutput, int length) {
        StringBuilder result;
        if (length > this.tmpRawBuffer.length) {
            length = this.tmpRawBuffer.length;
        }
        if (isHexOutput) {
            result = new StringBuilder(length * 3);
            int i = 0;
            while (i < length) {
                result.append(GeneralUtils.byteToHex[this.tmpRawBuffer[i] & 0xFF]).append(' ');
                ++i;
            }
        } else {
            result = new StringBuilder(length);
            int i = 0;
            while (i < length) {
                result.append(this.byteToChar[this.tmpRawBuffer[i] & 0xFF]);
                ++i;
            }
        }
        return result;
    }

    public void cut() {
        this.copy();
        this.deleteSelected();
    }

    public boolean deleteSelected() {
        if (!this.handleSelectedPreModify()) {
            return false;
        }
        this.upANibble = 0;
        this.ensureWholeScreenIsVisible();
        this.restoreStateAfterModify();
        return true;
    }

    void doModifyKeyPressed(KeyEvent event) {
        char aChar = event.character;
        if (aChar == '\u0000' || aChar == '\b' || aChar == '\u007f' || event.stateMask == 262144 || event.widget == this.hexText && ((event.stateMask & SWT.MODIFIER_MASK) != 0 || aChar < '0' || aChar > '9' && aChar < 'A' || aChar > 'F' && aChar < 'a' || aChar > 'f')) {
            return;
        }
        boolean origInserting = this.isInserting;
        if (this.getCaretPos() == this.content.length() && !this.isInserting) {
            this.isInserting = true;
        }
        try {
            this.handleSelectedPreModify();
            try {
                if (this.isInserting) {
                    if (event.widget == this.previewText) {
                        this.content.insert((byte)aChar, this.getCaretPos());
                    } else if (this.upANibble == 0) {
                        this.content.insert((byte)(hexToNibble[aChar - 48] << 4), this.getCaretPos());
                    } else {
                        this.content.overwrite(hexToNibble[aChar - 48], 4, 4, this.getCaretPos());
                    }
                } else {
                    if (event.widget == this.previewText) {
                        this.content.overwrite((byte)aChar, this.getCaretPos());
                    } else {
                        this.content.overwrite(hexToNibble[aChar - 48], this.upANibble * 4, 4, this.getCaretPos());
                    }
                    this.content.get(ByteBuffer.wrap(this.tmpRawBuffer, 0, 1), null, this.getCaretPos());
                    int offset = (int)(this.getCaretPos() - this.textAreasStart);
                    this.hexText.replaceTextRange(offset * 3, 2, GeneralUtils.byteToHex[this.tmpRawBuffer[0] & 0xFF]);
                    this.hexText.setStyleRange(new StyleRange(offset * 3, 2, this.colorHighlightText, null));
                    this.previewText.replaceTextRange(offset, 1, Character.toString(this.byteToChar[this.tmpRawBuffer[0] & 0xFF]));
                    this.previewText.setStyleRange(new StyleRange(offset, 1, this.colorHighlightText, null));
                }
            }
            catch (IOException e) {
                log.warn((Object)e);
            }
            this.startPosition = this.endPosition = this.incrementPosWithinLimits(this.getCaretPos(), event.widget == this.hexText);
            Runnable delayed = () -> {
                this.ensureCaretIsVisible();
                this.redrawTextAreas(false);
                if (this.isInserting) {
                    this.updateScrollBar();
                    this.redrawTextAreas(true);
                }
                this.refreshSelections();
                this.runnableEnd();
            };
            this.runnableAdd(delayed);
            this.notifyListeners(24, null);
            this.notifyLongSelectionListeners();
        }
        finally {
            this.isInserting = origInserting;
        }
    }

    private long doNavigateKeyPressed(boolean ctrlKey, int keyCode, long oldPos, boolean countNibbles) {
        if (!countNibbles) {
            this.upANibble = 0;
        }
        switch (keyCode) {
            case 0x1000001: {
                if (oldPos < (long)this.bytesPerLine) break;
                oldPos -= (long)this.bytesPerLine;
                break;
            }
            case 0x1000002: {
                if (oldPos <= this.content.length() - (long)this.bytesPerLine) {
                    oldPos += (long)this.bytesPerLine;
                }
                if (!countNibbles || oldPos != this.content.length()) break;
                this.upANibble = 0;
                break;
            }
            case 0x1000003: {
                if (countNibbles && (oldPos > 0L || oldPos == 0L && this.upANibble > 0)) {
                    if (this.upANibble == 0) {
                        --oldPos;
                    }
                    this.upANibble ^= 1;
                }
                if (countNibbles || oldPos <= 0L) break;
                --oldPos;
                break;
            }
            case 0x1000004: {
                oldPos = this.incrementPosWithinLimits(oldPos, countNibbles);
                break;
            }
            case 0x1000008: {
                if (ctrlKey) {
                    oldPos = this.content.length();
                } else if ((oldPos = oldPos - oldPos % (long)this.bytesPerLine + (long)this.bytesPerLine - 1L) >= this.content.length()) {
                    oldPos = this.content.length();
                }
                this.upANibble = 0;
                if (!countNibbles || oldPos >= this.content.length()) break;
                this.upANibble = 1;
                break;
            }
            case 0x1000007: {
                oldPos = ctrlKey ? 0L : (oldPos -= oldPos % (long)this.bytesPerLine);
                this.upANibble = 0;
                break;
            }
            case 0x1000005: {
                if (oldPos < (long)this.bytesPerLine || (oldPos -= (long)(this.bytesPerLine * this.numberOfLines_1)) >= 0L) break;
                oldPos = (oldPos + (long)(this.bytesPerLine * this.numberOfLines_1)) % (long)this.bytesPerLine;
                break;
            }
            case 0x1000006: {
                if (oldPos <= this.content.length() - (long)this.bytesPerLine && (oldPos += (long)(this.bytesPerLine * this.numberOfLines_1)) > this.content.length()) {
                    oldPos -= ((oldPos - 1L - this.content.length()) / (long)this.bytesPerLine + 1L) * (long)this.bytesPerLine;
                }
                if (!countNibbles || oldPos != this.content.length()) break;
                this.upANibble = 0;
            }
        }
        return oldPos;
    }

    void drawUnfocusedCaret(boolean visible) {
        GC unfocusedGC;
        Caret unfocusedCaret;
        if (this.hexText.isDisposed()) {
            return;
        }
        int chars = 0;
        int shift = 0;
        if (this.lastFocusedTextArea == 1) {
            unfocusedCaret = this.previewText.getCaret();
            unfocusedGC = this.styledText2GC;
        } else {
            unfocusedCaret = this.hexText.getCaret();
            unfocusedGC = this.styledText1GC;
            chars = 1;
            if (this.hexText.getCaretOffset() % 3 == 1) {
                shift = -1;
            }
        }
        if (unfocusedCaret.getVisible()) {
            Rectangle unfocused = unfocusedCaret.getBounds();
            unfocusedGC.setForeground(visible ? COLOR_NORMAL_SHADOW : this.colorCaretLine);
            unfocusedGC.drawRectangle(unfocused.x + shift * unfocused.width, unfocused.y, unfocused.width << chars, unfocused.height - 1);
        }
    }

    void ensureCaretIsVisible() {
        long caretPos = this.getCaretPos();
        long posInLine = caretPos % (long)this.bytesPerLine;
        if (this.textAreasStart > caretPos) {
            this.textAreasStart = caretPos - posInLine;
        } else if (this.textAreasStart + (long)(this.bytesPerLine * this.numberOfLines) < caretPos || this.textAreasStart + (long)(this.bytesPerLine * this.numberOfLines) == caretPos && caretPos != this.content.length()) {
            this.textAreasStart = caretPos - posInLine - (long)(this.bytesPerLine * this.numberOfLines_1);
            if (caretPos == this.content.length() && posInLine == 0L) {
                this.textAreasStart = caretPos - (long)(this.bytesPerLine * this.numberOfLines);
            }
            if (this.textAreasStart < 0L) {
                this.textAreasStart = 0L;
            }
        } else {
            return;
        }
        this.getVerticalBar().setSelection((int)(this.textAreasStart / (long)this.bytesPerLine >>> this.verticalBarFactor));
    }

    private void ensureWholeScreenIsVisible() {
        if (this.textAreasStart + (long)(this.bytesPerLine * this.numberOfLines) > this.content.length()) {
            this.textAreasStart = this.content.length() - (this.content.length() - 1L) % (long)this.bytesPerLine - 1L - (long)(this.bytesPerLine * this.numberOfLines_1);
        }
        if (this.textAreasStart < 0L) {
            this.textAreasStart = 0L;
        }
    }

    public boolean findAndSelect(String findString, boolean isHexString, boolean searchForward, boolean ignoreCase) throws IOException {
        return this.findAndSelectInternal(findString, isHexString, searchForward, ignoreCase, true);
    }

    private boolean findAndSelectInternal(String findString, boolean isHexString, boolean searchForward, boolean ignoreCase, boolean updateGui) throws IOException {
        if (findString == null) {
            return true;
        }
        this.initFinder(findString, isHexString, searchForward, ignoreCase);
        Object[] result = new Object[2];
        HexManager.blockUntilFinished(() -> {
            try {
                objectArray[0] = this.finder.getNextMatch();
            }
            catch (IOException e) {
                objectArray[1] = e;
            }
        });
        if (result[1] != null) {
            throw (IOException)result[1];
        }
        Object[] vector = (Object[])result[0];
        if (vector != null && vector.length > 1 && vector[0] != null && vector[1] != null) {
            this.startPosition = (Long)vector[0];
            this.caretStickToStart = false;
            if (updateGui) {
                this.setSelection(this.startPosition, this.startPosition + (long)((Integer)vector[1]).intValue());
            } else {
                this.select(this.startPosition, this.startPosition + (long)((Integer)vector[1]).intValue());
            }
            this.previousFindEnd = this.getCaretPos();
            return true;
        }
        return false;
    }

    public long getCaretPos() {
        if (this.caretStickToStart) {
            return this.startPosition;
        }
        return this.endPosition;
    }

    public byte getActualValue() {
        return this.getValue(this.getCaretPos());
    }

    public byte getValue(long pos) {
        try {
            this.content.get(ByteBuffer.wrap(this.tmpRawBuffer, 0, 1), null, pos);
        }
        catch (IOException e) {
            log.warn((Object)e);
        }
        return this.tmpRawBuffer[0];
    }

    public BinaryContent getContent() {
        return this.content;
    }

    private void getHighlightRangesInScreen(long start, int length) {
        this.highlightRangesInScreen.clear();
        if (this.lastLocationPosition >= start && this.lastLocationPosition < start + (long)length) {
            this.highlightRangesInScreen.add((int)(this.lastLocationPosition - this.textAreasStart));
            this.highlightRangesInScreen.add(1);
        }
    }

    public long[] getSelection() {
        return new long[]{this.startPosition, this.endPosition};
    }

    public boolean isSelected() {
        return this.startPosition != this.endPosition;
    }

    boolean handleSelectedPreModify() {
        if (this.startPosition == this.endPosition || !this.isInserting) {
            return false;
        }
        this.content.delete(this.startPosition, this.endPosition - this.startPosition);
        this.endPosition = this.startPosition;
        return true;
    }

    long incrementPosWithinLimits(long oldPos, boolean countNibbles) {
        if (oldPos < this.content.length()) {
            if (countNibbles) {
                if (this.upANibble > 0) {
                    ++oldPos;
                }
                this.upANibble ^= 1;
            } else {
                ++oldPos;
            }
        }
        return oldPos;
    }

    private void initFinder(String findString, boolean isHexString, boolean searchForward, boolean ignoreCase) {
        if (!searchForward) {
            this.caretStickToStart = true;
        }
        if (this.finder == null || !findString.equals(this.previousFindString) || isHexString != this.previousFindStringWasHex || ignoreCase != this.previousFindIgnoredCase) {
            this.previousFindString = findString;
            this.previousFindStringWasHex = isHexString;
            this.previousFindIgnoredCase = ignoreCase;
            if (isHexString) {
                this.finder = new BinaryTextFinder(HexEditControl.hexStringToByte(findString), this.content);
            } else {
                this.finder = new BinaryTextFinder(findString, this.content);
                if (ignoreCase) {
                    this.finder.setCaseSensitive(false);
                }
            }
            this.finder.setNewStart(this.getCaretPos());
        }
        if (this.previousFindEnd != this.getCaretPos()) {
            this.finder.setNewStart(this.getCaretPos());
        }
        this.finder.setDirectionForward(searchForward);
    }

    public boolean isOverwriteMode() {
        return !this.isInserting;
    }

    void makeFirstRowSameHeight() {
        ((GridData)this.linesTextSeparator.getLayoutData()).heightHint = this.hexHeaderText.computeSize((int)-1, (int)-1).y;
        ((GridData)this.previewTextSeparator.getLayoutData()).heightHint = this.hexHeaderText.computeSize((int)-1, (int)-1).y;
    }

    List<StyleRange> mergeRanges(List<Long> changeRanges, List<Integer> highlightRanges) {
        if (!this.mergerInit(changeRanges, highlightRanges)) {
            return null;
        }
        ArrayList<StyleRange> result = new ArrayList<StyleRange>();
        this.mergerNext();
        int start = this.mergeRangesPosition;
        boolean blue = this.mergeRangesIsBlue;
        boolean highlight = this.mergeRangesIsHighlight;
        while (this.mergerNext()) {
            if (blue || highlight) {
                result.add(new StyleRange(start, this.mergeRangesPosition - start, blue ? this.colorText : null, highlight ? this.colorHighlightText : null));
            }
            start = this.mergeRangesPosition;
            blue = this.mergeRangesIsBlue;
            highlight = this.mergeRangesIsHighlight;
        }
        return result;
    }

    boolean mergerCatchUps() {
        boolean withinRange = false;
        if (this.mergeChangeRanges != null && this.mergeChangeRanges.size() > this.mergeIndexChange) {
            withinRange = true;
            if (this.mergerPosition(true) < this.mergeRangesPosition) {
                ++this.mergeIndexChange;
            }
        }
        if (this.mergeHighlightRanges != null && this.mergeHighlightRanges.size() > this.mergeIndexHighlight) {
            withinRange = true;
            if (this.mergerPosition(false) < this.mergeRangesPosition) {
                ++this.mergeIndexHighlight;
            }
        }
        return withinRange;
    }

    boolean mergerInit(List<Long> changeRanges, List<Integer> highlightRanges) {
        if (!(changeRanges != null && changeRanges.size() >= 2 || highlightRanges != null && highlightRanges.size() >= 2)) {
            return false;
        }
        this.mergeChangeRanges = changeRanges;
        this.mergeHighlightRanges = highlightRanges;
        this.mergeRangesIsBlue = false;
        this.mergeRangesIsHighlight = false;
        this.mergeRangesPosition = -1;
        this.mergeIndexChange = 0;
        this.mergeIndexHighlight = 0;
        return true;
    }

    int mergerMinimumInChangesHighlights() {
        int result;
        int change = Integer.MAX_VALUE;
        if (this.mergeChangeRanges != null && this.mergeChangeRanges.size() > this.mergeIndexChange) {
            change = this.mergerPosition(true);
        }
        int highlight = Integer.MAX_VALUE;
        if (this.mergeHighlightRanges != null && this.mergeHighlightRanges.size() > this.mergeIndexHighlight) {
            highlight = this.mergerPosition(false);
        }
        if (change == (result = Math.min(change, highlight))) {
            boolean bl = this.mergeRangesIsBlue = (this.mergeIndexChange & 1) == 0;
        }
        if (highlight == result) {
            this.mergeRangesIsHighlight = (this.mergeIndexHighlight & 1) == 0;
        }
        return result;
    }

    boolean mergerNext() {
        ++this.mergeRangesPosition;
        if (!this.mergerCatchUps()) {
            return false;
        }
        this.mergeRangesPosition = this.mergerMinimumInChangesHighlights();
        return true;
    }

    int mergerPosition(boolean changesNotHighlights) {
        int result;
        if (changesNotHighlights) {
            result = (int)(this.mergeChangeRanges.get(this.mergeIndexChange & 0xFFFFFFFE) - this.textAreasStart);
            if ((this.mergeIndexChange & 1) == 1) {
                result = (int)Math.min((long)(this.bytesPerLine * this.numberOfLines), (long)result + this.mergeChangeRanges.get(this.mergeIndexChange));
            }
        } else {
            result = this.mergeHighlightRanges.get(this.mergeIndexHighlight & 0xFFFFFFFE);
            if ((this.mergeIndexHighlight & 1) == 1) {
                result += this.mergeHighlightRanges.get(this.mergeIndexHighlight).intValue();
            }
        }
        return result;
    }

    void notifyLongSelectionListeners() {
        if (this.longSelectionListeners.isEmpty()) {
            return;
        }
        Event basicEvent = new Event();
        basicEvent.widget = this;
        SelectionEvent anEvent = new SelectionEvent(basicEvent);
        anEvent.width = (int)(this.startPosition >>> 32);
        anEvent.x = (int)this.startPosition;
        anEvent.height = (int)(this.endPosition >>> 32);
        anEvent.y = (int)this.endPosition;
        for (SelectionListener aListener : this.longSelectionListeners) {
            aListener.widgetSelected(anEvent);
        }
    }

    public void paste() {
        if (!this.myClipboard.hasContents()) {
            return;
        }
        this.handleSelectedPreModify();
        long caretPos = this.getCaretPos();
        long total = this.myClipboard.getContents(this.content, caretPos, this.isInserting);
        this.startPosition = caretPos;
        this.endPosition = caretPos + total;
        this.caretStickToStart = false;
        this.redrawTextAreas(true);
        this.restoreStateAfterModify();
    }

    public void redo() {
        this.undo(false);
    }

    void redrawTextAreas(int mode, StringBuilder newText, StringBuilder resultHex, StringBuilder resultChar, List<StyleRange> viewRanges) {
        this.hexText.getCaret().setVisible(false);
        this.previewText.getCaret().setVisible(false);
        if (mode == 0) {
            this.linesText.getContent().setText(newText.toString());
            this.hexText.getContent().setText(resultHex.toString());
            this.previewText.getContent().setText(resultChar.toString());
            this.previousLine = -1;
        } else {
            boolean forward = mode == 1;
            this.linesText.setRedraw(false);
            this.hexText.setRedraw(false);
            this.previewText.setRedraw(false);
            ((DisplayedContent)this.linesText.getContent()).shiftLines(newText.toString(), forward);
            ((DisplayedContent)this.hexText.getContent()).shiftLines(resultHex.toString(), forward);
            ((DisplayedContent)this.previewText.getContent()).shiftLines(resultChar.toString(), forward);
            this.linesText.setRedraw(true);
            this.hexText.setRedraw(true);
            this.previewText.setRedraw(true);
            if (this.previousLine >= 0 && this.previousLine < this.numberOfLines) {
                this.previousLine += newText.length() / this.charsForAddress * (forward ? 1 : -1);
            }
            if (this.previousLine < -1 || this.previousLine >= this.numberOfLines) {
                this.previousLine = -1;
            }
        }
        if (viewRanges != null) {
            for (StyleRange styleRange : viewRanges) {
                this.previewText.setStyleRange(styleRange);
                styleRange = (StyleRange)styleRange.clone();
                styleRange.start *= 3;
                styleRange.length *= 3;
                this.hexText.setStyleRange(styleRange);
            }
        }
    }

    void redrawTextAreas(boolean fromScratch) {
        int actuallyRead;
        long lines;
        if (this.content == null || this.hexText.isDisposed()) {
            return;
        }
        long newLinesStart = this.textAreasStart;
        int linesShifted = this.numberOfLines;
        int mode = 0;
        if (!fromScratch && this.previousRedrawStart >= 0L && Math.abs(lines = (this.textAreasStart - this.previousRedrawStart) / (long)this.bytesPerLine) < (long)this.numberOfLines) {
            mode = lines > 0L ? 2 : 1;
            linesShifted = Math.abs((int)lines);
            if (linesShifted < 1) {
                this.refreshSelections();
                this.refreshCaretsPosition();
                return;
            }
            if (mode == 2) {
                newLinesStart = this.textAreasStart + (long)((this.numberOfLines - (int)lines) * this.bytesPerLine);
            }
        }
        this.previousRedrawStart = this.textAreasStart;
        StringBuilder newText = this.cookAddresses(newLinesStart, linesShifted * this.bytesPerLine);
        ArrayList<Long> changeRanges = new ArrayList<Long>();
        try {
            actuallyRead = this.content.get(ByteBuffer.wrap(this.tmpRawBuffer, 0, linesShifted * this.bytesPerLine), changeRanges, newLinesStart);
        }
        catch (IOException iOException) {
            actuallyRead = 0;
        }
        StringBuilder resultHex = this.cookTexts(true, actuallyRead);
        StringBuilder resultChar = this.cookTexts(false, actuallyRead);
        this.getHighlightRangesInScreen(newLinesStart, linesShifted * this.bytesPerLine);
        List<StyleRange> viewRanges = this.mergeRanges(changeRanges, this.highlightRangesInScreen);
        this.redrawTextAreas(mode, newText, resultHex, resultChar, viewRanges);
        this.refreshSelections();
        this.refreshCaretsPosition();
    }

    private void refreshCaretsPosition() {
        this.drawUnfocusedCaret(false);
        long caretLocation = this.getCaretPos() - this.textAreasStart;
        if (caretLocation >= 0L && caretLocation < (long)(this.bytesPerLine * this.numberOfLines) || this.getCaretPos() == this.content.length() && caretLocation == (long)(this.bytesPerLine * this.numberOfLines)) {
            int tmp = (int)caretLocation;
            if (tmp == this.bytesPerLine * this.numberOfLines) {
                this.hexText.setCaretOffset(tmp * 3 - 1);
                this.previewText.setCaretOffset(tmp);
            } else {
                this.hexText.setCaretOffset(tmp * 3 + this.upANibble);
                this.previewText.setCaretOffset(tmp);
            }
            int line = this.hexText.getLineAtOffset(this.hexText.getCaretOffset());
            if (line != this.previousLine) {
                if (this.previousLine >= 0 && this.previousLine < this.numberOfLines) {
                    this.hexText.setLineBackground(this.previousLine, 1, null);
                    this.previewText.setLineBackground(this.previousLine, 1, null);
                }
                this.hexText.setLineBackground(line, 1, this.colorCaretLine);
                this.previewText.setLineBackground(line, 1, this.colorCaretLine);
                this.previousLine = line;
            }
            this.hexText.getCaret().setVisible(true);
            this.previewText.getCaret().setVisible(true);
            UIUtils.asyncExec(() -> this.drawUnfocusedCaret(true));
        } else {
            this.hexText.getCaret().setVisible(false);
            this.previewText.getCaret().setVisible(false);
        }
    }

    void refreshHeader() {
        this.hexHeaderText.setText(headerRow.substring(0, Math.min(this.bytesPerLine * 3, headerRow.length())));
    }

    void refreshSelections() {
        if (this.startPosition >= this.endPosition || this.startPosition > this.textAreasStart + (long)(this.bytesPerLine * this.numberOfLines) || this.endPosition <= this.textAreasStart) {
            return;
        }
        long startLocation = this.startPosition - this.textAreasStart;
        if (startLocation < 0L) {
            startLocation = 0L;
        }
        int intStart = (int)startLocation;
        long endLocation = this.endPosition - this.textAreasStart;
        if (endLocation > (long)(this.bytesPerLine * this.numberOfLines)) {
            endLocation = this.bytesPerLine * this.numberOfLines;
        }
        int intEnd = (int)endLocation;
        if (this.caretStickToStart) {
            int tmp = intStart;
            intStart = intEnd;
            intEnd = tmp;
        }
        this.hexText.setSelection(intStart * 3, intEnd * 3);
        this.hexText.setTopIndex(0);
        this.previewText.setSelection(intStart, intEnd);
        this.previewText.setTopIndex(0);
    }

    public void replace(String replaceString, boolean isHexString) {
        this.handleSelectedPreModify();
        byte[] replaceData = replaceString.getBytes(Charset.defaultCharset());
        if (isHexString) {
            replaceData = HexEditControl.hexStringToByte(replaceString);
        }
        ByteBuffer newSelection = ByteBuffer.wrap(replaceData);
        if (this.isInserting) {
            this.content.insert(newSelection, this.startPosition);
        } else {
            newSelection.limit((int)Math.min((long)newSelection.limit(), this.content.length() - this.startPosition));
            this.content.overwrite(newSelection, this.startPosition);
        }
        this.endPosition = this.startPosition + (long)newSelection.limit() - (long)newSelection.position();
        this.caretStickToStart = false;
        this.redrawTextAreas(true);
        this.restoreStateAfterModify();
    }

    public int replaceAll(String findString, boolean isFindHexString, boolean searchForward, boolean ignoreCase, String replaceString, boolean isReplaceHexString) throws IOException {
        int result = 0;
        this.stopSearching = false;
        while (!this.stopSearching && this.findAndSelectInternal(findString, isFindHexString, searchForward, ignoreCase, false)) {
            ++result;
            this.replace(replaceString, isReplaceHexString);
        }
        if (result > 0) {
            this.setSelection(this.getSelection()[0], this.getSelection()[1]);
        }
        return result;
    }

    void restoreStateAfterModify() {
        this.ensureCaretIsVisible();
        this.redrawTextAreas(true);
        this.updateScrollBar();
        this.notifyListeners(24, null);
        this.notifyLongSelectionListeners();
    }

    void runnableAdd(Runnable delayed) {
        if (this.delayedInQueue) {
            this.delayedWaiting = delayed;
        } else {
            this.delayedInQueue = true;
            UIUtils.asyncExec((Runnable)delayed);
        }
    }

    void runnableEnd() {
        if (this.delayedWaiting != null) {
            UIUtils.asyncExec((Runnable)this.delayedWaiting);
            this.delayedWaiting = null;
        } else {
            this.delayedInQueue = false;
        }
    }

    public void selectAll() {
        this.select(0L, this.content.length());
        this.refreshSelections();
    }

    public void selectBlock(long start, long end) {
        this.select(start, end);
        this.refreshSelections();
        this.showMark(start);
    }

    void select(long start, long end) {
        this.upANibble = 0;
        this.startPosition = 0L;
        if (start > 0L) {
            this.startPosition = start;
            if (this.startPosition > this.content.length()) {
                this.startPosition = this.content.length();
            }
        }
        this.endPosition = this.startPosition;
        if (end > this.startPosition) {
            this.endPosition = end;
            if (this.endPosition > this.content.length()) {
                this.endPosition = this.content.length();
            }
        }
        this.notifyLongSelectionListeners();
    }

    void setAddressesGridDataWidthHint() {
        ((GridData)this.linesText.getLayoutData()).widthHint = this.charsForAddress * this.fontCharWidth;
    }

    void setCaretsSize(boolean insert) {
        this.isInserting = insert;
        int width = 0;
        int height = this.hexText.getCaret().getSize().y;
        if (!this.isInserting) {
            width = this.fontCharWidth;
        }
        this.hexText.getCaret().setSize(width, height);
        this.previewText.getCaret().setSize(width, height);
    }

    public void setContentProvider(BinaryContent aContent, boolean notify) {
        boolean firstContent;
        if (this.isDisposed()) {
            return;
        }
        boolean bl = firstContent = this.content == null;
        if (!firstContent) {
            this.content.dispose();
        }
        this.content = aContent;
        this.finder = null;
        if (this.content != null) {
            this.content.setActionsHistory();
            if (firstContent || this.endPosition > this.content.length() || this.textAreasStart >= this.content.length()) {
                this.endPosition = 0L;
                this.startPosition = 0L;
                this.textAreasStart = 0L;
                this.caretStickToStart = false;
            }
            this.charsForFileSizeAddress = Long.toHexString(this.content.length()).length();
        }
        this.updateScrollBar();
        this.redrawTextAreas(true);
        this.notifyLongSelectionListeners();
        if (notify) {
            this.notifyListeners(24, null);
        }
    }

    public void setContent(byte[] data, String charset) {
        this.setContent(data, charset, true);
    }

    public void setContent(byte[] data, String charset, boolean notify) {
        BinaryContent binaryContent = new BinaryContent();
        if (charset != null) {
            this.setCharset(charset);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        binaryContent.insert(byteBuffer, 0L);
        this.setContentProvider(binaryContent, notify);
    }

    public boolean setFocus() {
        this.redrawCaret(false);
        if (this.lastFocusedTextArea == 1) {
            return this.hexText.setFocus();
        }
        return this.previewText.setFocus();
    }

    public void setFont(Font font) {
        int newSize;
        if (font != null && ((newSize = UIUtils.getFontHeight((Font)font)) == 1 || newSize == 2)) {
            throw new IllegalArgumentException("Font size is " + newSize + ", too small");
        }
        this.fontCurrent = font;
        if (this.fontCurrent == null) {
            this.fontCurrent = this.fontDefault;
        }
        super.setFont(this.fontCurrent);
        this.hexHeaderText.setFont(this.fontCurrent);
        this.hexHeaderText.pack(true);
        GC gc = new GC((Drawable)this.hexHeaderText);
        this.fontCharWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        this.makeFirstRowSameHeight();
        this.linesText.setFont(this.fontCurrent);
        this.setAddressesGridDataWidthHint();
        this.linesText.pack(true);
        this.hexText.setFont(this.fontCurrent);
        this.hexText.pack(true);
        this.previewText.setFont(this.fontCurrent);
        this.previewText.pack(true);
        this.updateTextsMetrics();
        this.layout();
        this.setCaretsSize(this.isInserting);
    }

    public void setSelection(long start, long end) {
        this.select(start, end);
        this.ensureCaretIsVisible();
        this.redrawTextAreas(false);
    }

    void shiftStartAndEnd(long newPos) {
        if (this.caretStickToStart) {
            this.startPosition = Math.min(newPos, this.endPosition);
            this.endPosition = Math.max(newPos, this.endPosition);
        } else {
            this.endPosition = Math.max(newPos, this.startPosition);
            this.startPosition = Math.min(newPos, this.startPosition);
        }
        this.caretStickToStart = this.endPosition != newPos;
    }

    public void showMark(long position) {
        this.lastLocationPosition = position;
        if (position < 0L) {
            return;
        }
        position -= position % (long)this.bytesPerLine;
        this.textAreasStart = position;
        if (this.numberOfLines > 2) {
            this.textAreasStart = position - (long)(this.numberOfLines / 2 * this.bytesPerLine);
        }
        this.ensureWholeScreenIsVisible();
        this.redrawTextAreas(true);
        this.updateScrollBar();
    }

    public void stopSearching() {
        this.stopSearching = true;
        if (this.finder != null) {
            this.finder.stopSearching();
        }
    }

    long totalNumberOfLines() {
        long result = 1L;
        if (this.content != null && this.bytesPerLine > 0) {
            result = (this.content.length() - 1L) / (long)this.bytesPerLine + 1L;
        }
        return result;
    }

    public void undo() {
        this.undo(true);
    }

    void undo(boolean previousAction) {
        long[] selection;
        long[] lArray = selection = previousAction ? this.content.undo() : this.content.redo();
        if (selection == null) {
            return;
        }
        this.upANibble = 0;
        this.startPosition = selection[0];
        this.endPosition = selection[1];
        this.caretStickToStart = false;
        this.ensureWholeScreenIsVisible();
        this.restoreStateAfterModify();
    }

    void updateNumberOfLines() {
        int height = this.getClientArea().height - this.hexHeaderText.computeSize((int)-1, (int)-1, (boolean)false).y;
        this.numberOfLines = height / this.linesText.getLineHeight();
        if (this.numberOfLines < 1) {
            this.numberOfLines = 1;
        }
        this.numberOfLines_1 = this.numberOfLines - 1;
        ((DisplayedContent)this.linesText.getContent()).setDimensions(this.charsForAddress, this.numberOfLines);
        ((DisplayedContent)this.hexText.getContent()).setDimensions(this.bytesPerLine * 3, this.numberOfLines);
        ((DisplayedContent)this.previewText.getContent()).setDimensions(this.bytesPerLine, this.numberOfLines);
    }

    private void updateScrollBar() {
        ScrollBar vertical = this.getVerticalBar();
        long max = this.totalNumberOfLines();
        this.verticalBarFactor = 0;
        while (max > Integer.MAX_VALUE) {
            max >>>= 1;
            ++this.verticalBarFactor;
        }
        vertical.setMaximum((int)max);
        vertical.setSelection((int)(this.textAreasStart / (long)this.bytesPerLine >>> this.verticalBarFactor));
        vertical.setPageIncrement(this.numberOfLines_1);
        vertical.setThumb(this.numberOfLines);
    }

    void updateTextsMetrics() {
        int commonWidth;
        int width = this.getClientArea().width - this.linesText.computeSize((int)-1, (int)-1).x;
        int displayedNumberWidth = this.fontCharWidth * 4;
        this.bytesPerLine = commonWidth = width / displayedNumberWidth;
        this.textGridData.widthHint = this.hexText.computeTrim((int)0, (int)0, (int)(this.bytesPerLine * 3 * this.fontCharWidth), (int)100).width;
        this.previewGridData.widthHint = this.previewText.computeTrim((int)0, (int)0, (int)(this.bytesPerLine * this.fontCharWidth), (int)100).width;
        this.updateNumberOfLines();
        this.changed(new Control[]{this.hexHeaderText, this.linesText, this.hexText, this.previewText});
        this.updateScrollBar();
        this.refreshHeader();
        this.textAreasStart = (long)this.getVerticalBar().getSelection() * (long)this.bytesPerLine << this.verticalBarFactor;
        this.redrawTextAreas(true);
    }

    public void setDefWidth(int defValue) {
        this.defWidth = defValue;
    }

    private class ControlKeyAdapter
    extends KeyAdapter {
        private ControlKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: {
                    boolean ctrlKey;
                    boolean bl = ctrlKey = (e.stateMask & 0x40000) != 0;
                    if ((e.stateMask & 0x20000) != 0) {
                        long newPos = HexEditControl.this.doNavigateKeyPressed(ctrlKey, e.keyCode, HexEditControl.this.getCaretPos(), false);
                        HexEditControl.this.shiftStartAndEnd(newPos);
                    } else {
                        long l = HexEditControl.this.doNavigateKeyPressed(ctrlKey, e.keyCode, HexEditControl.this.getCaretPos(), e.widget == HexEditControl.this.hexText && !HexEditControl.this.isInserting);
                        HexEditControl.this.startPosition = l;
                        HexEditControl.this.endPosition = l;
                        HexEditControl.this.caretStickToStart = false;
                    }
                    HexEditControl.this.ensureCaretIsVisible();
                    Runnable delayed = () -> {
                        HexEditControl.this.redrawTextAreas(false);
                        HexEditControl.this.runnableEnd();
                    };
                    HexEditControl.this.runnableAdd(delayed);
                    HexEditControl.this.notifyLongSelectionListeners();
                    e.doit = false;
                    break;
                }
                case 0x1000009: {
                    if ((e.stateMask & SWT.MODIFIER_MASK) == 0) {
                        HexEditControl.this.redrawCaret(true);
                        break;
                    }
                    if (!HexEditControl.this.readOnly && e.stateMask == 131072) {
                        HexEditControl.this.paste();
                        break;
                    }
                    if (e.stateMask != 262144) break;
                    HexEditControl.this.copy();
                    break;
                }
                case 97: {
                    if (e.stateMask != 262144) break;
                    HexEditControl.this.selectAll();
                    break;
                }
                case 99: {
                    if (e.stateMask != 262144) break;
                    HexEditControl.this.copy();
                    break;
                }
                case 118: {
                    if (HexEditControl.this.readOnly || e.stateMask != 262144) break;
                    HexEditControl.this.paste();
                    break;
                }
                case 120: {
                    if (HexEditControl.this.readOnly || e.stateMask != 262144) break;
                    HexEditControl.this.cut();
                    break;
                }
                case 121: {
                    if (HexEditControl.this.readOnly || e.stateMask != 262144) break;
                    HexEditControl.this.redo();
                    break;
                }
                case 122: {
                    if (HexEditControl.this.readOnly || e.stateMask != 262144) break;
                    HexEditControl.this.undo();
                    break;
                }
            }
        }
    }

    private class ControlMouseAdapter
    extends MouseAdapter {
        int charLen = 1;

        public ControlMouseAdapter(boolean hexContent) {
            if (hexContent) {
                this.charLen = 3;
            }
        }

        public void mouseDown(MouseEvent e) {
            int textOffset;
            if (e.button == 1) {
                HexEditControl.this.dragging = true;
            }
            try {
                textOffset = ((StyledText)e.widget).getOffsetAtLocation(new Point(e.x, e.y));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                textOffset = ((StyledText)e.widget).getCharCount();
            }
            int byteOffset = textOffset / this.charLen;
            ((StyledText)e.widget).setTopIndex(0);
            if (e.button == 1 && (e.stateMask & SWT.MODIFIER_MASK & 0xFFFDFFFF) == 0) {
                if ((e.stateMask & SWT.MODIFIER_MASK) == 0) {
                    HexEditControl.this.caretStickToStart = false;
                    long l = HexEditControl.this.textAreasStart + (long)byteOffset;
                    HexEditControl.this.endPosition = l;
                    HexEditControl.this.startPosition = l;
                } else {
                    HexEditControl.this.shiftStartAndEnd(HexEditControl.this.textAreasStart + (long)byteOffset);
                }
                HexEditControl.this.refreshCaretsPosition();
                HexEditControl.this.setFocus();
                HexEditControl.this.refreshSelections();
                HexEditControl.this.notifyLongSelectionListeners();
            }
        }

        public void mouseUp(MouseEvent e) {
            if (e.button == 1) {
                HexEditControl.this.dragging = false;
            }
        }
    }

    private class ControlPaintAdapter
    implements PaintListener {
        boolean hexContent;

        ControlPaintAdapter(boolean isHexText) {
            this.hexContent = isHexText;
        }

        public void paintControl(PaintEvent event) {
            event.gc.setForeground(COLOR_LIGHT_SHADOW);
            int lineWidth = 1;
            int charLen = 1;
            int rightHalfWidth = 0;
            if (this.hexContent) {
                lineWidth = HexEditControl.this.fontCharWidth;
                charLen = 3;
                rightHalfWidth = (lineWidth + 1) / 2;
            }
            event.gc.setLineWidth(lineWidth);
            int block = HexEditControl.this.defWidth;
            while (block <= HexEditControl.this.bytesPerLine) {
                int xPos = charLen * block * HexEditControl.this.fontCharWidth - rightHalfWidth;
                event.gc.drawLine(xPos, event.y, xPos, event.y + event.height);
                block += HexEditControl.this.defWidth;
            }
        }
    }

    private class ControlSelectionAdapter
    extends SelectionAdapter
    implements SelectionListener {
        int charLen = 1;

        public ControlSelectionAdapter(boolean hexContent) {
            if (hexContent) {
                this.charLen = 3;
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (!HexEditControl.this.dragging) {
                return;
            }
            int lower = e.x / this.charLen;
            int higher = e.y / this.charLen;
            int caretPos = ((StyledText)e.widget).getCaretOffset() / this.charLen;
            HexEditControl.this.caretStickToStart = caretPos < higher || caretPos < lower;
            if (lower > higher) {
                lower = higher;
                higher = e.x / this.charLen;
            }
            HexEditControl.this.select(HexEditControl.this.textAreasStart + (long)lower, HexEditControl.this.textAreasStart + (long)higher);
            HexEditControl.this.redrawTextAreas(false);
        }
    }

    private class ControlTraverseAdapter
    implements TraverseListener {
        private ControlTraverseAdapter() {
        }

        public void keyTraversed(TraverseEvent e) {
            if (e.detail == 16) {
                e.doit = true;
            }
        }
    }

    private class ControlVerifyKeyAdapter
    implements VerifyKeyListener {
        private ControlVerifyKeyAdapter() {
        }

        public void verifyKey(VerifyEvent e) {
            if (HexEditControl.this.readOnly) {
                return;
            }
            if ((e.character == '\u007f' || e.character == '\b') && HexEditControl.this.isInserting) {
                if (!HexEditControl.this.deleteSelected()) {
                    if (e.character == '\b') {
                        HexEditControl hexEditControl = HexEditControl.this;
                        hexEditControl.startPosition = hexEditControl.startPosition + (long)HexEditControl.this.upANibble;
                        if (HexEditControl.this.startPosition > 0L) {
                            HexEditControl.this.content.delete(HexEditControl.this.startPosition - 1L, 1L);
                            HexEditControl hexEditControl2 = HexEditControl.this;
                            long l = hexEditControl2.startPosition - 1L;
                            hexEditControl2.startPosition = l;
                            HexEditControl.this.endPosition = l;
                        }
                    } else {
                        HexEditControl.this.content.delete(HexEditControl.this.startPosition, 1L);
                    }
                    HexEditControl.this.ensureWholeScreenIsVisible();
                    HexEditControl.this.ensureCaretIsVisible();
                    Runnable delayed = () -> {
                        HexEditControl.this.redrawTextAreas(true);
                        HexEditControl.this.runnableEnd();
                    };
                    HexEditControl.this.runnableAdd(delayed);
                    HexEditControl.this.updateScrollBar();
                    HexEditControl.this.notifyListeners(24, null);
                    HexEditControl.this.notifyLongSelectionListeners();
                }
                HexEditControl.this.upANibble = 0;
            } else {
                HexEditControl.this.doModifyKeyPressed((KeyEvent)e);
            }
            e.doit = false;
        }
    }
}

