/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataTypeAttribute;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataTypeMethod;
import org.jkiss.dbeaver.ext.oracle.model.OracleLazyReference;
import org.jkiss.dbeaver.ext.oracle.model.OracleObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectPersistAction;
import org.jkiss.dbeaver.ext.oracle.model.OracleObjectType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSourceType;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleSourceObject;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class OracleDataType
extends OracleObject<DBSObject>
implements DBSDataType,
DBSEntity,
DBPQualifiedObject,
OracleSourceObject,
DBPScriptObjectExt {
    private static final Log log = Log.getLog(OracleDataType.class);
    public static final String TYPE_CODE_COLLECTION = "COLLECTION";
    public static final String TYPE_CODE_OBJECT = "OBJECT";
    static final Map<String, TypeDesc> PREDEFINED_TYPES = new HashMap<String, TypeDesc>();
    static final Map<Integer, TypeDesc> PREDEFINED_TYPE_IDS = new HashMap<Integer, TypeDesc>();
    private String typeCode;
    private byte[] typeOID;
    private Object superType;
    private final AttributeCache attributeCache;
    private final MethodCache methodCache;
    private boolean flagPredefined;
    private boolean flagIncomplete;
    private boolean flagFinal;
    private boolean flagInstantiable;
    private TypeDesc typeDesc;
    private int valueType = 1111;
    private String sourceDeclaration;
    private String sourceDefinition;
    private OracleDataType componentType;

    static {
        PREDEFINED_TYPES.put("BFILE", new TypeDesc(DBPDataKind.CONTENT, 1111, 0, 0, 0));
        PREDEFINED_TYPES.put("BINARY ROWID", new TypeDesc(DBPDataKind.ROWID, -8, 0, 0, 0));
        PREDEFINED_TYPES.put("BINARY_DOUBLE", new TypeDesc(DBPDataKind.NUMERIC, 8, 38, 127, -84));
        PREDEFINED_TYPES.put("BINARY_FLOAT", new TypeDesc(DBPDataKind.NUMERIC, 6, 38, 127, -84));
        PREDEFINED_TYPES.put("BLOB", new TypeDesc(DBPDataKind.CONTENT, 2004, 0, 0, 0));
        PREDEFINED_TYPES.put("CANONICAL", new TypeDesc(DBPDataKind.UNKNOWN, 1111, 0, 0, 0));
        PREDEFINED_TYPES.put("CFILE", new TypeDesc(DBPDataKind.CONTENT, 1111, 0, 0, 0));
        PREDEFINED_TYPES.put("CHAR", new TypeDesc(DBPDataKind.STRING, 1, 0, 0, 0));
        PREDEFINED_TYPES.put("CLOB", new TypeDesc(DBPDataKind.CONTENT, 2005, 0, 0, 0));
        PREDEFINED_TYPES.put("CONTIGUOUS ARRAY", new TypeDesc(DBPDataKind.ARRAY, 2003, 0, 0, 0));
        PREDEFINED_TYPES.put("DATE", new TypeDesc(DBPDataKind.DATETIME, 93, 0, 0, 0));
        PREDEFINED_TYPES.put("DECIMAL", new TypeDesc(DBPDataKind.NUMERIC, 3, 38, 127, -84));
        PREDEFINED_TYPES.put("DOUBLE PRECISION", new TypeDesc(DBPDataKind.NUMERIC, 8, 38, 127, -84));
        PREDEFINED_TYPES.put("FLOAT", new TypeDesc(DBPDataKind.NUMERIC, 6, 38, 127, -84));
        PREDEFINED_TYPES.put("INTEGER", new TypeDesc(DBPDataKind.NUMERIC, 4, 38, 127, -84));
        PREDEFINED_TYPES.put("INTERVAL DAY TO SECOND", new TypeDesc(DBPDataKind.STRING, 12, 0, 0, 0));
        PREDEFINED_TYPES.put("INTERVAL YEAR TO MONTH", new TypeDesc(DBPDataKind.STRING, 12, 0, 0, 0));
        PREDEFINED_TYPES.put("CONTENT POINTER", new TypeDesc(DBPDataKind.CONTENT, 2004, 0, 0, 0));
        PREDEFINED_TYPES.put("NAMED COLLECTION", new TypeDesc(DBPDataKind.ARRAY, 2003, 0, 0, 0));
        PREDEFINED_TYPES.put("NAMED OBJECT", new TypeDesc(DBPDataKind.OBJECT, 2002, 0, 0, 0));
        PREDEFINED_TYPES.put("NUMBER", new TypeDesc(DBPDataKind.NUMERIC, 2, 38, 127, -84));
        PREDEFINED_TYPES.put("OCTET", new TypeDesc(DBPDataKind.BINARY, 1111, 0, 0, 0));
        PREDEFINED_TYPES.put("OID", new TypeDesc(DBPDataKind.STRING, 12, 0, 0, 0));
        PREDEFINED_TYPES.put("POINTER", new TypeDesc(DBPDataKind.UNKNOWN, 1111, 0, 0, 0));
        PREDEFINED_TYPES.put("REAL", new TypeDesc(DBPDataKind.NUMERIC, 7, 38, 127, -84));
        PREDEFINED_TYPES.put("REF", new TypeDesc(DBPDataKind.REFERENCE, 1111, 0, 0, 0));
        PREDEFINED_TYPES.put("SIGNED BINARY INTEGER", new TypeDesc(DBPDataKind.NUMERIC, 4, 38, 127, -84));
        PREDEFINED_TYPES.put("SMALLINT", new TypeDesc(DBPDataKind.NUMERIC, 5, 38, 127, -84));
        PREDEFINED_TYPES.put("TABLE", new TypeDesc(DBPDataKind.OBJECT, 1111, 0, 0, 0));
        PREDEFINED_TYPES.put("TIME", new TypeDesc(DBPDataKind.DATETIME, 93, 0, 0, 0));
        PREDEFINED_TYPES.put("TIME WITH TZ", new TypeDesc(DBPDataKind.DATETIME, 93, 0, 0, 0));
        PREDEFINED_TYPES.put("TIMESTAMP", new TypeDesc(DBPDataKind.DATETIME, 93, 0, 0, 0));
        PREDEFINED_TYPES.put("TIMESTAMP WITH LOCAL TZ", new TypeDesc(DBPDataKind.DATETIME, 102, 0, 0, 0));
        PREDEFINED_TYPES.put("TIMESTAMP WITH TZ", new TypeDesc(DBPDataKind.DATETIME, 101, 0, 0, 0));
        PREDEFINED_TYPES.put("TIMESTAMP WITH LOCAL TIME ZONE", new TypeDesc(DBPDataKind.DATETIME, 102, 0, 0, 0));
        PREDEFINED_TYPES.put("TIMESTAMP WITH TIME ZONE", new TypeDesc(DBPDataKind.DATETIME, 101, 0, 0, 0));
        PREDEFINED_TYPES.put("UNSIGNED BINARY INTEGER", new TypeDesc(DBPDataKind.NUMERIC, -5, 38, 127, -84));
        PREDEFINED_TYPES.put("UROWID", new TypeDesc(DBPDataKind.ROWID, -8, 0, 0, 0));
        PREDEFINED_TYPES.put("VARCHAR", new TypeDesc(DBPDataKind.STRING, 12, 0, 0, 0));
        PREDEFINED_TYPES.put("VARCHAR2", new TypeDesc(DBPDataKind.STRING, 12, 0, 0, 0));
        PREDEFINED_TYPES.put("VARYING ARRAY", new TypeDesc(DBPDataKind.ARRAY, 2003, 0, 0, 0));
        PREDEFINED_TYPES.put("VARRAY", new TypeDesc(DBPDataKind.ARRAY, 2003, 0, 0, 0));
        PREDEFINED_TYPES.put("ROWID", new TypeDesc(DBPDataKind.ROWID, -8, 0, 0, 0));
        PREDEFINED_TYPES.put("LONG", new TypeDesc(DBPDataKind.BINARY, -4, 0, 0, 0));
        PREDEFINED_TYPES.put("RAW", new TypeDesc(DBPDataKind.BINARY, -3, 0, 0, 0));
        PREDEFINED_TYPES.put("LONG RAW", new TypeDesc(DBPDataKind.BINARY, -4, 0, 0, 0));
        PREDEFINED_TYPES.put("NVARCHAR2", new TypeDesc(DBPDataKind.STRING, -9, 0, 0, 0));
        PREDEFINED_TYPES.put("NCHAR", new TypeDesc(DBPDataKind.STRING, -15, 0, 0, 0));
        PREDEFINED_TYPES.put("NCLOB", new TypeDesc(DBPDataKind.CONTENT, 2011, 0, 0, 0));
        PREDEFINED_TYPES.put("LOB POINTER", new TypeDesc(DBPDataKind.CONTENT, 2004, 0, 0, 0));
        PREDEFINED_TYPES.put("REF CURSOR", new TypeDesc(DBPDataKind.OBJECT, -10, 0, 0, 0));
        for (TypeDesc type : PREDEFINED_TYPES.values()) {
            PREDEFINED_TYPE_IDS.put(type.valueType, type);
        }
    }

    public OracleDataType(DBSObject owner, String typeName, boolean persisted) {
        super(owner, typeName, persisted);
        this.attributeCache = new AttributeCache();
        this.methodCache = new MethodCache();
        if (owner instanceof OracleDataSource) {
            this.flagPredefined = true;
            this.findTypeDesc(typeName);
        }
    }

    public OracleDataType(DBSObject owner, ResultSet dbResult) {
        super(owner, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_NAME"), true);
        boolean hasMethods;
        boolean hasAttributes;
        this.typeCode = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPECODE");
        this.typeOID = JDBCUtils.safeGetBytes((ResultSet)dbResult, (String)"TYPE_OID");
        this.flagPredefined = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"PREDEFINED", (String)"YES");
        this.flagIncomplete = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"INCOMPLETE", (String)"YES");
        this.flagFinal = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"FINAL", (String)"YES");
        this.flagInstantiable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"INSTANTIABLE", (String)"YES");
        String superTypeOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SUPERTYPE_OWNER");
        if (!CommonUtils.isEmpty((String)superTypeOwner)) {
            this.superType = new OracleLazyReference(superTypeOwner, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SUPERTYPE_NAME"));
            hasAttributes = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"LOCAL_ATTRIBUTES") > 0;
            hasMethods = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"LOCAL_METHODS") > 0;
        } else {
            hasAttributes = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ATTRIBUTES") > 0;
            hasMethods = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"METHODS") > 0;
        }
        this.attributeCache = hasAttributes ? new AttributeCache() : null;
        MethodCache methodCache = this.methodCache = hasMethods ? new MethodCache() : null;
        if (owner instanceof OracleDataSource && this.flagPredefined) {
            this.findTypeDesc(this.name);
        } else if (TYPE_CODE_COLLECTION.equals(this.typeCode)) {
            this.valueType = 2003;
        } else if (TYPE_CODE_OBJECT.equals(this.typeCode)) {
            this.valueType = 2002;
        } else if (this.name.equals("XMLTYPE") && owner.getName().equals("SYS")) {
            this.valueType = 2009;
        }
    }

    public boolean hasMethods() {
        return this.methodCache != null;
    }

    public boolean hasAttributes() {
        return this.attributeCache != null;
    }

    private boolean findTypeDesc(String typeName) {
        if (typeName.startsWith("PL/SQL")) {
            return true;
        }
        typeName = OracleDataType.normalizeTypeName(typeName);
        this.typeDesc = PREDEFINED_TYPES.get(typeName);
        if (this.typeDesc == null) {
            log.warn((Object)("Unknown predefined type: " + typeName));
            return false;
        }
        this.valueType = this.typeDesc.valueType;
        return true;
    }

    @Nullable
    public static DBPDataKind getDataKind(String typeName) {
        TypeDesc desc = PREDEFINED_TYPES.get(typeName);
        return desc != null ? desc.dataKind : null;
    }

    @Override
    @Nullable
    public OracleSchema getSchema() {
        return this.parent instanceof OracleSchema ? (OracleSchema)this.parent : null;
    }

    @Override
    public OracleSourceType getSourceType() {
        return OracleSourceType.TYPE;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBCException {
        if (this.sourceDeclaration == null && monitor != null) {
            this.sourceDeclaration = OracleUtils.getSource(monitor, this, false, false);
        }
        return this.sourceDeclaration;
    }

    public void setObjectDefinitionText(String sourceDeclaration) {
        this.sourceDeclaration = sourceDeclaration;
    }

    @Override
    public DBEPersistAction[] getCompileActions(DBRProgressMonitor monitor) {
        return new DBEPersistAction[]{new OracleObjectPersistAction(OracleObjectType.VIEW, "Compile type", "ALTER TYPE " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " COMPILE")};
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getExtendedDefinitionText(DBRProgressMonitor monitor) throws DBException {
        if (this.sourceDefinition == null && monitor != null) {
            this.sourceDefinition = OracleUtils.getSource(monitor, this, true, false);
        }
        return this.sourceDefinition;
    }

    public void setExtendedDefinitionText(String source) {
        this.sourceDefinition = source;
    }

    public String getTypeName() {
        return this.getFullyQualifiedName(DBPEvaluationContext.DDL);
    }

    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public int getTypeID() {
        return this.valueType;
    }

    public DBPDataKind getDataKind() {
        return JDBCUtils.resolveDataKind((DBPDataSource)this.getDataSource(), (String)this.getName(), (int)this.valueType);
    }

    public Integer getScale() {
        return this.typeDesc == null ? 0 : this.typeDesc.minScale;
    }

    public Integer getPrecision() {
        return this.typeDesc == null ? 0 : this.typeDesc.precision;
    }

    public long getMaxLength() {
        return CommonUtils.toInt((Object)this.getPrecision());
    }

    public long getTypeModifiers() {
        return 0L;
    }

    public int getMinScale() {
        return this.typeDesc == null ? 0 : this.typeDesc.minScale;
    }

    public int getMaxScale() {
        return this.typeDesc == null ? 0 : this.typeDesc.maxScale;
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(DBSTypedObject attribute) {
        return DBUtils.getDefaultOperators((DBSTypedObject)this);
    }

    @Override
    public DBSObject getParentObject() {
        return this.parent instanceof OracleSchema ? this.parent : (this.parent instanceof OracleDataSource ? ((OracleDataSource)this.parent).getContainer() : null);
    }

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, editable=true, order=2)
    public String getTypeCode() {
        return this.typeCode;
    }

    @Property(hidden=true, viewable=false, editable=false)
    public byte[] getTypeOID() {
        return this.typeOID;
    }

    @Property(viewable=true, editable=true, order=3)
    public OracleDataType getSuperType(DBRProgressMonitor monitor) {
        block6: {
            if (this.superType == null) {
                return null;
            }
            if (this.superType instanceof OracleDataType) {
                return (OracleDataType)this.superType;
            }
            try {
                OracleLazyReference olr = (OracleLazyReference)this.superType;
                OracleSchema superSchema = this.getDataSource().getSchema(monitor, olr.schemaName);
                if (superSchema == null) {
                    log.warn((Object)("Referenced schema '" + olr.schemaName + "' not found for super type '" + olr.objectName + "'"));
                    break block6;
                }
                this.superType = superSchema.dataTypeCache.getObject(monitor, superSchema, olr.objectName);
                if (this.superType == null) {
                    log.warn((Object)("Referenced type '" + olr.objectName + "' not found in schema '" + olr.schemaName + "'"));
                    break block6;
                }
                return (OracleDataType)this.superType;
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        this.superType = null;
        return null;
    }

    @Property(viewable=true, order=4)
    public boolean isPredefined() {
        return this.flagPredefined;
    }

    @Property(viewable=true, order=5)
    public boolean isIncomplete() {
        return this.flagIncomplete;
    }

    @Property(viewable=true, order=6)
    public boolean isFinal() {
        return this.flagFinal;
    }

    @Property(viewable=true, order=7)
    public boolean isInstantiable() {
        return this.flagInstantiable;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TYPE;
    }

    @Association
    public List<OracleDataTypeAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.attributeCache != null ? this.attributeCache.getAllObjects(monitor, this) : null;
    }

    @Nullable
    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public OracleDataTypeAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return this.attributeCache != null ? (OracleDataTypeAttribute)this.attributeCache.getObject(monitor, this, attributeName) : null;
    }

    @Nullable
    @Association
    public Collection<OracleDataTypeMethod> getMethods(DBRProgressMonitor monitor) throws DBException {
        return this.methodCache != null ? this.methodCache.getAllObjects(monitor, this) : null;
    }

    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    public Object geTypeExtension() {
        return this.typeOID;
    }

    @Property(viewable=true, order=8)
    public OracleDataType getComponentType(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.componentType != null) {
            return this.componentType;
        }
        OracleSchema schema = this.getSchema();
        if (schema == null || !TYPE_CODE_COLLECTION.equals(this.typeCode) || !this.getDataSource().isAtLeastV10()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load collection types");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT ELEM_TYPE_OWNER,ELEM_TYPE_NAME,ELEM_TYPE_MOD FROM " + OracleUtils.getSysSchemaPrefix(this.getDataSource()) + "ALL_COLL_TYPES WHERE OWNER=? AND TYPE_NAME=?");){
                    dbStat.setString(1, schema.getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (JDBCResultSet dbResults = dbStat.executeQuery();){
                        if (dbResults.next()) {
                            String compTypeSchema = JDBCUtils.safeGetString((ResultSet)dbResults, (String)"ELEM_TYPE_OWNER");
                            String compTypeName = JDBCUtils.safeGetString((ResultSet)dbResults, (String)"ELEM_TYPE_NAME");
                            this.componentType = OracleDataType.resolveDataType(monitor, this.getDataSource(), compTypeSchema, compTypeName);
                        } else {
                            log.warn((Object)("Can't resolve collection type [" + this.getName() + "]"));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error reading collection types", (Throwable)e);
        }
        return this.componentType;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.parent instanceof OracleSchema ? DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.parent, this}) : this.name;
    }

    public String toString() {
        return this.getFullyQualifiedName(DBPEvaluationContext.UI);
    }

    public static OracleDataType resolveDataType(DBRProgressMonitor monitor, OracleDataSource dataSource, String typeOwner, String typeName) {
        OracleDataType type;
        OracleSchema typeSchema;
        block8: {
            typeName = OracleDataType.normalizeTypeName(typeName);
            typeSchema = null;
            type = null;
            if (typeOwner != null) {
                try {
                    typeSchema = dataSource.getSchema(monitor, typeOwner);
                    if (typeSchema == null) {
                        log.error((Object)("Type attr schema '" + typeOwner + "' not found"));
                        break block8;
                    }
                    type = typeSchema.getDataType(monitor, typeName);
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
            } else {
                type = dataSource.getLocalDataType(typeName);
            }
        }
        if (type == null) {
            log.debug((Object)("Data type '" + typeName + "' not found - declare new one"));
            type = new OracleDataType((DBSObject)(typeSchema == null ? dataSource : typeSchema), typeName, true);
            type.flagPredefined = true;
            if (typeSchema == null) {
                dataSource.dataTypeCache.cacheObject(type);
            } else {
                typeSchema.dataTypeCache.cacheObject(type);
            }
        }
        return type;
    }

    private static String normalizeTypeName(String typeName) {
        int modEnd;
        int modIndex;
        if (CommonUtils.isEmpty((String)typeName)) {
            return "";
        }
        while ((modIndex = typeName.indexOf(40)) != -1 && (modEnd = typeName.indexOf(41, modIndex)) != -1) {
            typeName = String.valueOf(typeName.substring(0, modIndex)) + (modEnd == typeName.length() - 1 ? "" : typeName.substring(modEnd + 1));
        }
        return typeName;
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return DBSObjectState.NORMAL;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    private class AttributeCache
    extends JDBCObjectCache<OracleDataType, OracleDataTypeAttribute> {
        private AttributeCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataType owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getSysSchemaPrefix(OracleDataType.this.getDataSource()) + "ALL_TYPE_ATTRS " + "WHERE OWNER=? AND TYPE_NAME=? ORDER BY ATTR_NO");
            dbStat.setString(1, OracleDataType.this.parent.getName());
            dbStat.setString(2, OracleDataType.this.getName());
            return dbStat;
        }

        protected OracleDataTypeAttribute fetchObject(@NotNull JDBCSession session, @NotNull OracleDataType owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleDataTypeAttribute(session.getProgressMonitor(), OracleDataType.this, (ResultSet)resultSet);
        }
    }

    private class MethodCache
    extends JDBCObjectCache<OracleDataType, OracleDataTypeMethod> {
        private MethodCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataType owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT m.*,r.RESULT_TYPE_OWNER,RESULT_TYPE_NAME,RESULT_TYPE_MOD\nFROM " + OracleUtils.getSysSchemaPrefix(OracleDataType.this.getDataSource()) + "ALL_TYPE_METHODS m\n" + "LEFT OUTER JOIN " + OracleUtils.getSysSchemaPrefix(OracleDataType.this.getDataSource()) + "ALL_METHOD_RESULTS r ON r.OWNER=m.OWNER AND r.TYPE_NAME=m.TYPE_NAME AND r.METHOD_NAME=m.METHOD_NAME AND r.METHOD_NO=m.METHOD_NO\n" + "WHERE m.OWNER=? AND m.TYPE_NAME=?\n" + "ORDER BY m.METHOD_NO");
            dbStat.setString(1, OracleDataType.this.parent.getName());
            dbStat.setString(2, OracleDataType.this.getName());
            return dbStat;
        }

        protected OracleDataTypeMethod fetchObject(@NotNull JDBCSession session, @NotNull OracleDataType owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleDataTypeMethod(session.getProgressMonitor(), OracleDataType.this, (ResultSet)resultSet);
        }
    }

    static class TypeDesc {
        final DBPDataKind dataKind;
        final int valueType;
        final int precision;
        final int minScale;
        final int maxScale;

        private TypeDesc(DBPDataKind dataKind, int valueType, int precision, int minScale, int maxScale) {
            this.dataKind = dataKind;
            this.valueType = valueType;
            this.precision = precision;
            this.minScale = minScale;
            this.maxScale = maxScale;
        }
    }
}

