/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.ui.config;

import java.sql.SQLException;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2PlanConfig;
import org.jkiss.dbeaver.ext.db2.ui.editors.DB2TablespaceChooser;
import org.jkiss.dbeaver.ext.db2.ui.internal.DB2Messages;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;

public class DB2PlanSchemaConfigurator
implements DBEObjectConfigurator<DB2PlanConfig> {
    protected static final Log log = Log.getLog(DB2PlanSchemaConfigurator.class);

    public DB2PlanConfig configureObject(final DBRProgressMonitor monitor, Object db2dataSource, final DB2PlanConfig object) {
        DB2DataSource db2source = (DB2DataSource)db2dataSource;
        final JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)db2source, (String)"Read EXPLAIN tables");
        return (DB2PlanConfig)new UITask<DB2PlanConfig>(){

            protected DB2PlanConfig runTask() {
                List listTablespaces;
                DB2TablespaceChooser tsChooserDialog;
                block5: {
                    String msg = String.format(DB2Messages.dialog_explain_ask_to_create, object.getSessionUserSchema());
                    if (!UIUtils.confirmAction((String)DB2Messages.dialog_explain_no_tables, (String)msg)) {
                        return null;
                    }
                    tsChooserDialog = null;
                    listTablespaces = DB2Utils.getListOfUsableTsForExplain((DBRProgressMonitor)monitor, (JDBCSession)session);
                    if (!listTablespaces.isEmpty()) break block5;
                    DBWorkbench.getPlatformUI().showError(DB2Messages.dialog_explain_no_tablespace_found_title, DB2Messages.dialog_explain_no_tablespace_found);
                    return null;
                }
                try {
                    tsChooserDialog = new DB2TablespaceChooser(UIUtils.getActiveWorkbenchShell(), listTablespaces);
                }
                catch (SQLException e) {
                    log.error((Object)e);
                }
                if (tsChooserDialog != null && tsChooserDialog.open() == 0) {
                    object.setTablespace(tsChooserDialog.getSelectedTablespace());
                    return object;
                }
                return null;
            }
        }.execute();
    }
}

