/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.importer;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferResultSet;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.importer.StreamImporterAbstract;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataImporterCSV
extends StreamImporterAbstract {
    private static final String PROP_ENCODING = "encoding";
    private static final String PROP_HEADER = "header";
    private static final String PROP_DELIMITER = "delimiter";
    private static final String PROP_QUOTE_CHAR = "quoteChar";
    private static final String PROP_NULL_STRING = "nullString";
    private static final String PROP_EMPTY_STRING_NULL = "emptyStringNull";
    private static final String PROP_ESCAPE_CHAR = "escapeChar";
    private static final String PROP_TIMESTAMP_FORMAT = "timestampFormat";

    @Override
    @NotNull
    public List<StreamDataImporterColumnInfo> readColumnsInfo(StreamEntityMapping entityMapping, @NotNull InputStream inputStream) throws DBException {
        ArrayList<StreamDataImporterColumnInfo> columnsInfo;
        block22: {
            columnsInfo = new ArrayList<StreamDataImporterColumnInfo>();
            Map<String, Object> processorProperties = this.getSite().getProcessorProperties();
            HeaderPosition headerPosition = this.getHeaderPosition(processorProperties);
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStreamReader reader = this.openStreamReader(inputStream, processorProperties);){
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (CSVReader csvReader = this.openCSVReader(reader, processorProperties);){
                        String[] line;
                        do {
                            if ((line = csvReader.readNext()) != null) continue;
                            break block22;
                        } while (line.length == 0);
                        int i = 0;
                        while (i < line.length) {
                            String column = line[i];
                            column = headerPosition == HeaderPosition.none ? "Column" + (i + 1) : DBUtils.getUnQuotedIdentifier((DBPDataSource)entityMapping.getDataSource(), (String)column);
                            columnsInfo.add(new StreamDataImporterColumnInfo(entityMapping, i, column, "VARCHAR", 1024, DBPDataKind.STRING));
                            ++i;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new DBException("IO error reading CSV", (Throwable)e);
            }
        }
        return columnsInfo;
    }

    private HeaderPosition getHeaderPosition(Map<String, Object> processorProperties) {
        return (HeaderPosition)CommonUtils.valueOf(HeaderPosition.class, (String)CommonUtils.toString((Object)processorProperties.get(PROP_HEADER)), (Enum)HeaderPosition.top);
    }

    private CSVReader openCSVReader(Reader reader, Map<String, Object> processorProperties) {
        String escapeChar;
        String delimiter = StreamTransferUtils.getDelimiterString(processorProperties, PROP_DELIMITER);
        String quoteChar = CommonUtils.toString((Object)processorProperties.get(PROP_QUOTE_CHAR));
        if (CommonUtils.isEmpty((String)quoteChar)) {
            quoteChar = "'";
        }
        if (CommonUtils.isEmpty((String)(escapeChar = CommonUtils.toString((Object)processorProperties.get(PROP_ESCAPE_CHAR))))) {
            escapeChar = "\\";
        }
        return new CSVReader(reader, delimiter.charAt(0), quoteChar.charAt(0), escapeChar.charAt(0));
    }

    private InputStreamReader openStreamReader(InputStream inputStream, Map<String, Object> processorProperties) throws UnsupportedEncodingException {
        String encoding = CommonUtils.toString((Object)processorProperties.get(PROP_ENCODING), (String)GeneralUtils.UTF8_ENCODING);
        return new InputStreamReader(inputStream, encoding);
    }

    @Override
    public void runImport(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource streamDataSource, @NotNull InputStream inputStream, @NotNull IDataTransferConsumer consumer) throws DBException {
        IStreamDataImporterSite site = this.getSite();
        StreamEntityMapping entityMapping = site.getSourceObject();
        Map<String, Object> properties = site.getProcessorProperties();
        HeaderPosition headerPosition = this.getHeaderPosition(properties);
        boolean emptyStringNull = CommonUtils.getBoolean((Object)properties.get(PROP_EMPTY_STRING_NULL), (boolean)false);
        String nullValueMark = CommonUtils.toString((Object)properties.get(PROP_NULL_STRING));
        DBCExecutionContext context = streamDataSource.getDefaultInstance().getDefaultContext(monitor, false);
        Throwable throwable = null;
        Object var13_14 = null;
        try (DBCSession producerSession = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Transfer stream data");){
            LocalStatement localStatement = new LocalStatement(producerSession, "SELECT * FROM Stream");
            StreamTransferResultSet resultSet = new StreamTransferResultSet(producerSession, (DBCStatement)localStatement, entityMapping);
            consumer.fetchStart(producerSession, resultSet, -1L, -1L);
            this.applyTransformHints(resultSet, consumer, this.getTimeStampFormat(properties, PROP_TIMESTAMP_FORMAT));
            try {
                try {
                    Throwable throwable2 = null;
                    Object var18_22 = null;
                    try (InputStreamReader reader = this.openStreamReader(inputStream, properties);){
                        Throwable throwable3 = null;
                        Object var21_27 = null;
                        try (CSVReader csvReader = this.openCSVReader(reader, properties);){
                            int maxRows = site.getSettings().getMaxRows();
                            int targetAttrSize = entityMapping.getStreamColumns().size();
                            boolean headerRead = false;
                            int lineNum = 0;
                            while (!monitor.isCanceled()) {
                                Object[] line = csvReader.readNext();
                                if (line == null) {
                                    break;
                                }
                                if (line.length == 0) continue;
                                if (headerPosition != HeaderPosition.none && !headerRead) {
                                    headerRead = true;
                                    continue;
                                }
                                if (maxRows > 0 && lineNum >= maxRows) {
                                    break;
                                }
                                if (line.length < targetAttrSize) {
                                    String[] newLine = new String[targetAttrSize];
                                    System.arraycopy(line, 0, newLine, 0, line.length);
                                    int i = line.length;
                                    while (i < targetAttrSize) {
                                        newLine[i] = null;
                                        ++i;
                                    }
                                    line = newLine;
                                }
                                if (emptyStringNull) {
                                    int i = 0;
                                    while (i < line.length) {
                                        if ("".equals(line[i])) {
                                            line[i] = null;
                                        }
                                        ++i;
                                    }
                                }
                                if (!CommonUtils.isEmpty((String)nullValueMark)) {
                                    int i = 0;
                                    while (i < line.length) {
                                        if (nullValueMark.equals(line[i])) {
                                            line[i] = null;
                                        }
                                        ++i;
                                    }
                                }
                                resultSet.setStreamRow(line);
                                consumer.fetchRow(producerSession, resultSet);
                                if (++lineNum % 1000 != 0) continue;
                                monitor.subTask(String.valueOf(String.valueOf(lineNum)) + " rows processed");
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    throw new DBException("IO error reading CSV", (Throwable)e);
                }
            }
            finally {
                try {
                    consumer.fetchEnd(producerSession, resultSet);
                }
                finally {
                    consumer.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    static enum HeaderPosition {
        none,
        top;

    }
}

